/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="binding", type="baja:Ord", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"jsonToolkit:SlotOrdFE\")")}), @NiagaraProperty(name="tagId", type="String", defaultValue="n:name"), @NiagaraProperty(name="searchParents", type="boolean", defaultValue="false")})
public class BJsonSchemaTagProperty
extends BJsonSchemaProperty<BIDataValue> {
    public static final Property binding = BJsonSchemaTagProperty.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")));
    public static final Property tagId = BJsonSchemaTagProperty.newProperty((int)0, (String)"n:name", null);
    public static final Property searchParents = BJsonSchemaTagProperty.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaTagProperty.class);

    public BOrd getBinding() {
        return (BOrd)this.get(binding);
    }

    public void setBinding(BOrd v) {
        this.set(binding, (BValue)v, null);
    }

    public String getTagId() {
        return this.getString(tagId);
    }

    public void setTagId(String v) {
        this.setString(tagId, v, null);
    }

    public boolean getSearchParents() {
        return this.getBoolean(searchParents);
    }

    public void setSearchParents(boolean v) {
        this.setBoolean(searchParents, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaTagProperty make(BOrd ord, String tagId) {
        BJsonSchemaTagProperty tagProperty = new BJsonSchemaTagProperty();
        tagProperty.setBinding(ord);
        tagProperty.setTagId(tagId);
        return tagProperty;
    }

    private static BIDataValue lookupTag(String tag, BComponent c) {
        try {
            Id id = Id.newId((String)tag);
            Collection tags = c.tags().getAll();
            Optional<Tag> found = tags.stream().filter(t -> t.getId().equals((Object)id)).findFirst();
            if (!found.isPresent()) {
                throw new BajaRuntimeException("tag: not present" + tag + " on " + c.getName());
            }
            BIDataValue v = found.get().getValue();
            if (Log.log.isLoggable(Level.FINEST)) {
                Log.log.finest("Found tag: " + v.toString());
            }
            return v;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Error reading tag " + tag + " from " + c.getName(), (Throwable)e);
        }
    }

    @Override
    public BIDataValue getJsonValue() {
        BComplex base = this.getSchema().getBaseObject();
        if (this.getBinding() == null || this.getBinding().isNull()) {
            Log.log.warning(this.getSchema().getName() + ": Cannot function with null ord in " + this.getSlotPath());
        } else {
            try {
                BObject object = this.getBinding().get((BObject)base);
                if (object != null) {
                    if (object.getType().is(BComponent.TYPE)) {
                        try {
                            return this.findTagInComponent(object.asComponent());
                        }
                        catch (BajaRuntimeException bre) {
                            if (this.getSearchParents()) {
                                return this.searchParents(object.asComponent());
                            }
                            Log.log.log(Level.WARNING, this.getSchema() + ": Fetching Tag", bre);
                        }
                    } else {
                        Log.log.warning(this.getSchema() + ": Tags can only be fetched from BComponent type, not: " + object.toDebugString());
                    }
                }
            }
            catch (UnresolvedException ue) {
                this.getSchema().getConfig().getDebug().getMetrics().resolveError();
                Log.log.log(Level.WARNING, this.getSchema() + ": base:" + base.getName() + ": cannot find child tagged component: " + this.getBinding(), ue);
            }
        }
        return BString.DEFAULT;
    }

    private BIDataValue searchParents(BComponent component) {
        BComponent parent;
        while ((parent = (BComponent)component.getParent()) != null) {
            try {
                return this.findTagInComponent(parent);
            }
            catch (BajaRuntimeException bre) {
                component = parent;
                continue;
            }
            break;
        }
        return BString.DEFAULT;
    }

    private BIDataValue findTagInComponent(BComponent component) {
        BIDataValue value;
        block3: {
            value = BJsonSchemaTagProperty.lookupTag(this.getTagId(), component);
            if (!this.getSchema().getConfig().getUseEscapeCharacters() && value.getType().is(BString.TYPE)) {
                try {
                    String unescaped = SlotPath.unescape((String)value.toString());
                    value = BString.make((String)unescaped);
                }
                catch (Exception e) {
                    if (!Log.log.isLoggable(Level.FINE)) break block3;
                    Log.log.log(Level.FINE, "Could not unescape value " + value, e);
                }
            }
        }
        return value;
    }
}

