/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridiumx.jsonToolkit.outbound.schema.BIJsonProperty;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.config.BMetadataField;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="field", type="BMetadataField", defaultValue="BMetadataField.DEFAULT"), @NiagaraProperty(name="useParentBinding", type="boolean", defaultValue="true"), @NiagaraProperty(name="jsonName", type="String", defaultValue="BString.DEFAULT", flags=13, override=true), @NiagaraProperty(name="jsonNameSource", type="jsonToolkit:JsonSchemaNameSource", defaultValue="BJsonSchemaNameSource.displayName", flags=4, override=true)})
public class BJsonSchemaMetadataProperty
extends BJsonSchemaBoundMember
implements BIJsonProperty<BString> {
    public static final Property field = BJsonSchemaMetadataProperty.newProperty((int)0, (BValue)BMetadataField.DEFAULT, null);
    public static final Property useParentBinding = BJsonSchemaMetadataProperty.newProperty((int)0, (boolean)true, null);
    public static final Property jsonName = BJsonSchemaMetadataProperty.newProperty((int)13, (BValue)BString.DEFAULT, null);
    public static final Property jsonNameSource = BJsonSchemaMetadataProperty.newProperty((int)4, (BValue)BJsonSchemaNameSource.displayName, null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaMetadataProperty.class);
    private static final String NO_VALUE = "";

    public BMetadataField getField() {
        return (BMetadataField)this.get(field);
    }

    public void setField(BMetadataField v) {
        this.set(field, (BValue)v, null);
    }

    public boolean getUseParentBinding() {
        return this.getBoolean(useParentBinding);
    }

    public void setUseParentBinding(boolean v) {
        this.setBoolean(useParentBinding, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaMetadataProperty make(BMetadataField metadataField, BOrd bindingOrd) {
        BJsonSchemaMetadataProperty property = BJsonSchemaMetadataProperty.make(metadataField);
        property.setBinding(bindingOrd);
        property.setUseParentBinding(false);
        property.setField(metadataField);
        return property;
    }

    public static BJsonSchemaMetadataProperty make(BMetadataField metadataField) {
        BJsonSchemaMetadataProperty property = new BJsonSchemaMetadataProperty();
        property.setField(metadataField);
        return property;
    }

    @Override
    public BString getJsonValue() {
        if (this.isBindOrdSet()) {
            return this.getMetadataValue();
        }
        if (Log.log.isLoggable(Level.WARNING)) {
            Log.log.warning(String.format("Json schema [%s] member [%s] Skipping Null Binding", this.getSchema().getName(), this.getSchemaPath()));
        }
        return BString.DEFAULT;
    }

    private BString getMetadataValue() {
        OrdTarget ordTarget = this.getOrdTarget();
        BObject target = ordTarget.get();
        String value = NO_VALUE;
        switch (this.getField().getOrdinal()) {
            case 0: {
                value = JsonSchemaNameUtil.getNameOfTarget(ordTarget);
                break;
            }
            case 1: {
                value = JsonSchemaNameUtil.getDisplayNameOfTarget(ordTarget);
                break;
            }
            case 6: {
                value = JsonSchemaNameUtil.getNameOfTargetsParent(ordTarget);
                break;
            }
            case 2: {
                value = JsonSchemaNameUtil.getTargetsPath(ordTarget);
                break;
            }
            case 3: {
                value = target.isComponent() ? target.asComponent().getHandle().toString() : NO_VALUE;
                break;
            }
            case 4: {
                value = target.getType().getTypeSpec().getTypeName();
                break;
            }
            case 5: {
                value = target.getType().getTypeSpec().toString();
                break;
            }
            case 7: {
                value = JsonSchemaNameUtil.getNameOfNearest(ordTarget, BDevice.TYPE);
                break;
            }
            case 8: {
                value = JsonSchemaNameUtil.getNameOfNearest(ordTarget, BFolder.TYPE);
                break;
            }
            case 9: {
                value = target.isComponent() ? this.getHistoryName(target.asComponent()) : NO_VALUE;
                break;
            }
            case 10: {
                value = target.isComponent() ? this.getHistoryId(target.asComponent()) : NO_VALUE;
                break;
            }
            case 11: {
                value = target.toString(null);
                break;
            }
            default: {
                Log.log.severe("Unhandled metadata property: " + (Object)((Object)this.getField()));
            }
        }
        return BString.make((String)value);
    }

    private String getHistoryName(BComponent component) {
        Optional<BHistoryId> historyId = this.getHistory(component);
        return historyId.isPresent() ? historyId.get().getHistoryDisplayName() : NO_VALUE;
    }

    private String getHistoryId(BComponent component) {
        Optional<BHistoryId> historyId = this.getHistory(component);
        return SlotPath.unescape((String)historyId.map(BHistoryId::encodeToString).orElse(NO_VALUE));
    }

    private Optional<BHistoryId> getHistory(BComponent component) {
        if (component instanceof BControlPoint) {
            return BHistoryId.getHistoryIdFromPoint((BControlPoint)((BControlPoint)component.as(BControlPoint.class)));
        }
        return Optional.empty();
    }

    @Override
    public List<String> getPropertiesToIncludeInJson(BComplex resolvedTarget) {
        return Collections.emptyList();
    }

    @Override
    public BOrd getBinding() {
        if (this.getUseParentBinding()) {
            BComplex parent = this.getParent();
            if (parent instanceof BJsonSchemaBoundMember) {
                return ((BJsonSchemaBoundMember)parent.as(BJsonSchemaBoundMember.class)).getBinding();
            }
            throw new UnresolvedException("useParentBinding requires a binding set in the parent schema component");
        }
        return super.getBinding();
    }

    @Override
    public boolean isBindOrdSet() {
        return this.getUseParentBinding() ? this.getParent() instanceof BJsonSchemaBoundMember && ((BJsonSchemaBoundMember)this.getParent().as(BJsonSchemaBoundMember.class)).isBindOrdSet() : super.isBindOrdSet();
    }
}

