/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.postprocess;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaDebugFolder;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BIPostProcessor;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=2), @NiagaraProperty(name="historyMaxSize", type="int", defaultValue="BInteger.make(10)")})
@NiagaraAction(name="reset")
public class BSchemaHistoryDebug
extends BComponent
implements BIPostProcessor {
    public static final Property enabled = BSchemaHistoryDebug.newProperty((int)2, (boolean)true, null);
    public static final Property historyMaxSize = BSchemaHistoryDebug.newProperty((int)0, (BValue)BInteger.make((int)10), null);
    public static final Action reset = BSchemaHistoryDebug.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSchemaHistoryDebug.class);
    private final AtomicInteger count = new AtomicInteger();
    private final TreeMap<Integer, HistoryItem> histMap = new TreeMap();
    private static final BIcon DEBUG_ICON = BIcon.make((String)"module://icons/x16/bug.png");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public int getHistoryMaxSize() {
        return this.getInt(historyMaxSize);
    }

    public void setHistoryMaxSize(int v) {
        this.setInt(historyMaxSize, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is(this.getType(), parent.getType(), BJsonSchemaDebugFolder.TYPE, null);
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(historyMaxSize)) {
            while (this.histMap.size() > this.getHistoryMaxSize()) {
                this.histMap.pollFirstEntry();
            }
        }
    }

    @Override
    public void postProcess(BJsonSchema schema, Exception exception) {
        try {
            Date updateTime = new Date();
            this.histMap.put(this.count.incrementAndGet(), new HistoryItem(updateTime, schema.getOutput(), exception, schema instanceof BRelativeJsonSchema ? ((BRelativeJsonSchema)schema).getCurrentBasePath() : null));
            if (this.histMap.size() > this.getHistoryMaxSize()) {
                this.histMap.pollFirstEntry();
            }
        }
        catch (Exception e) {
            Log.log.warning("Spy failed: " + e.getMessage());
        }
    }

    public void spy(SpyWriter out) {
        out.startTable(true);
        out.th((Object)"No.");
        out.th((Object)"Date");
        out.th((Object)"Base Item");
        out.th((Object)"Result");
        out.th((Object)"Error");
        this.histMap.descendingMap().keySet().forEach(histNo -> BSchemaHistoryDebug.spyHistoryItem(histNo, out, this.histMap.get(histNo)));
        out.endTable();
    }

    public BIcon getIcon() {
        return DEBUG_ICON;
    }

    public String historyAt(int index) {
        return this.histMap.containsKey(index) ? this.histMap.get(index).getJson() : null;
    }

    public int currentSize() {
        return this.histMap.size();
    }

    private static void spyHistoryItem(Integer histNo, SpyWriter out, HistoryItem historyItem) {
        out.tr((Object)histNo, (Object)historyItem.getTime(), (Object)historyItem.getBaseItem().orElse("N/A"), (Object)historyItem.getJson(), (Object)BSchemaHistoryDebug.outputStack(historyItem));
    }

    private static String outputStack(HistoryItem historyItem) {
        return historyItem.getError().isPresent() ? BSchemaHistoryDebug.stackTraceToString(historyItem.getError().get()) : "";
    }

    private static String stackTraceToString(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public void doReset() {
        this.histMap.clear();
        this.count.set(0);
    }

    static class HistoryItem {
        private final Date time;
        private final String json;
        private final Exception exception;
        private final String baseItem;

        HistoryItem(Date time, String json, Exception exception, String baseItem) {
            this.time = (Date)time.clone();
            this.json = json;
            this.exception = exception;
            this.baseItem = baseItem;
        }

        Date getTime() {
            return (Date)this.time.clone();
        }

        String getJson() {
            return this.json;
        }

        Optional<Exception> getError() {
            return Optional.ofNullable(this.exception);
        }

        Optional<String> getBaseItem() {
            return Optional.ofNullable(this.baseItem);
        }
    }
}

