/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.object;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonObject;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundSlotsContainer;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaPropertyNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="jsonSlotNameSource", type="jsonToolkit:JsonSchemaPropertyNameSource", defaultValue="BJsonSchemaPropertyNameSource.displayName")
public class BJsonSchemaBoundObject
extends BJsonSchemaBoundSlotsContainer
implements BIJsonObject {
    public static final Property jsonSlotNameSource = BJsonSchemaBoundObject.newProperty((int)0, (BValue)BJsonSchemaPropertyNameSource.displayName, null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaBoundObject.class);
    private Map<String, String> jsonPropertyNames;

    public BJsonSchemaPropertyNameSource getJsonSlotNameSource() {
        return (BJsonSchemaPropertyNameSource)this.get(jsonSlotNameSource);
    }

    public void setJsonSlotNameSource(BJsonSchemaPropertyNameSource v) {
        this.set(jsonSlotNameSource, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaBoundObject make(BOrd ord) {
        BJsonSchemaBoundObject boundObject = new BJsonSchemaBoundObject();
        boundObject.setBinding(ord);
        return boundObject;
    }

    @Override
    public void started() {
        super.started();
        if (!this.getSchema().isRelative() && this.getSchema().getEnabled()) {
            this.updatePropertyJsonNames();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals(jsonSlotNameSource) || property.equals(binding) || property.equals(slotsToInclude) || property.equals(slotList)) && !this.getSchema().isRelative()) {
            this.updatePropertyJsonNames();
        }
    }

    @Override
    public void populateObjectContent(JSONWriter json) {
        BComplex resolvedTarget = this.getTarget();
        List<String> propNames = this.getPropertiesToIncludeInJson(resolvedTarget);
        if (this.jsonPropertyNames == null) {
            this.updatePropertyJsonNames(resolvedTarget);
        }
        propNames.forEach(propName -> {
            String jsonName = this.jsonPropertyNames.computeIfAbsent((String)propName, name -> this.getPropertyJsonName((String)name, resolvedTarget));
            json.key(jsonName).value(this.jsonTypedSlotValue((String)propName, (BObject)resolvedTarget));
        });
    }

    @Override
    protected void onSchemaEvent(BSchemaEvent event) {
        super.onSchemaEvent(event);
        if (event.getOrdinal() == 0) {
            this.updatePropertyJsonNames();
        }
    }

    private String getPropertyJsonName(String propName, BComplex target) {
        String name = "";
        BComplex resolvedTarget = target == null ? this.getTarget() : target;
        Property prop = resolvedTarget.getProperty(propName);
        if (prop == null) {
            JsonSchemaUtil.logger.warning(String.format("Unknown property %s in object %s when parsing json schema " + this.getSchema().getName(), propName, resolvedTarget.getName()));
            return name;
        }
        switch (this.getJsonSlotNameSource().getOrdinal()) {
            case 0: {
                name = resolvedTarget.getDisplayName((Slot)prop, null);
                break;
            }
            case 1: {
                name = prop.getName();
            }
        }
        return JsonSchemaNameUtil.applyNamingRules(this, name);
    }

    private void updatePropertyJsonNames() {
        this.updatePropertyJsonNames(null);
    }

    private void updatePropertyJsonNames(BComplex target) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
            JsonSchemaUtil.logger.finest("updatePropertyJsonNames " + this.getName());
        }
        this.jsonPropertyNames = new LinkedHashMap<String, String>();
        BComplex resolvedTarget = target == null ? this.getTarget() : target;
        List<String> propNames = this.getPropertiesToIncludeInJson(resolvedTarget);
        propNames.forEach(propName -> this.jsonPropertyNames.put((String)propName, this.getPropertyJsonName((String)propName, resolvedTarget)));
        this.clearCache();
    }
}

