/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.config.folder;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameCasing;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSpacing;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaTuningPolicy;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaDebugFolder;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaOverrideFolder;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="nameCasingRule", type="jsonToolkit:JsonSchemaNameCasing", defaultValue="BJsonSchemaNameCasing.camel"), @NiagaraProperty(name="nameSpacingRule", type="jsonToolkit:JsonSchemaNameSpacing", defaultValue="BJsonSchemaNameSpacing.remove"), @NiagaraProperty(name="dateFormatPattern", type="String", defaultValue="BJsonSchemaConfigFolder.DEFAULT_DATE_PATTERN"), @NiagaraProperty(name="numericPrecision", type="int", defaultValue="4", facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)")}), @NiagaraProperty(name="useEscapeCharacters", type="boolean", defaultValue="true"), @NiagaraProperty(name="tuningPolicy", type="jsonToolkit:JsonSchemaTuningPolicy", defaultValue="new BJsonSchemaTuningPolicy()"), @NiagaraProperty(name="overrides", type="jsonToolkit:JsonSchemaOverrideFolder", defaultValue="new BJsonSchemaOverrideFolder()"), @NiagaraProperty(name="debug", type="jsonToolkit:JsonSchemaDebugFolder", defaultValue="new BJsonSchemaDebugFolder()")})
public class BJsonSchemaConfigFolder
extends BFolder {
    public static final Property nameCasingRule = BJsonSchemaConfigFolder.newProperty((int)0, (BValue)BJsonSchemaNameCasing.camel, null);
    public static final Property nameSpacingRule = BJsonSchemaConfigFolder.newProperty((int)0, (BValue)BJsonSchemaNameSpacing.remove, null);
    public static final Property dateFormatPattern = BJsonSchemaConfigFolder.newProperty((int)0, (String)"yyyy-MM-dd HH:mm:ss.SSSZ", null);
    public static final Property numericPrecision = BJsonSchemaConfigFolder.newProperty((int)0, (int)4, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property useEscapeCharacters = BJsonSchemaConfigFolder.newProperty((int)0, (boolean)true, null);
    public static final Property tuningPolicy = BJsonSchemaConfigFolder.newProperty((int)0, (BValue)new BJsonSchemaTuningPolicy(), null);
    public static final Property overrides = BJsonSchemaConfigFolder.newProperty((int)0, (BValue)new BJsonSchemaOverrideFolder(), null);
    public static final Property debug = BJsonSchemaConfigFolder.newProperty((int)0, (BValue)new BJsonSchemaDebugFolder(), null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaConfigFolder.class);
    private DateFormat dateFormat;
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSZ";

    public BJsonSchemaNameCasing getNameCasingRule() {
        return (BJsonSchemaNameCasing)this.get(nameCasingRule);
    }

    public void setNameCasingRule(BJsonSchemaNameCasing v) {
        this.set(nameCasingRule, (BValue)v, null);
    }

    public BJsonSchemaNameSpacing getNameSpacingRule() {
        return (BJsonSchemaNameSpacing)this.get(nameSpacingRule);
    }

    public void setNameSpacingRule(BJsonSchemaNameSpacing v) {
        this.set(nameSpacingRule, (BValue)v, null);
    }

    public String getDateFormatPattern() {
        return this.getString(dateFormatPattern);
    }

    public void setDateFormatPattern(String v) {
        this.setString(dateFormatPattern, v, null);
    }

    public int getNumericPrecision() {
        return this.getInt(numericPrecision);
    }

    public void setNumericPrecision(int v) {
        this.setInt(numericPrecision, v, null);
    }

    public boolean getUseEscapeCharacters() {
        return this.getBoolean(useEscapeCharacters);
    }

    public void setUseEscapeCharacters(boolean v) {
        this.setBoolean(useEscapeCharacters, v, null);
    }

    public BJsonSchemaTuningPolicy getTuningPolicy() {
        return (BJsonSchemaTuningPolicy)this.get(tuningPolicy);
    }

    public void setTuningPolicy(BJsonSchemaTuningPolicy v) {
        this.set(tuningPolicy, (BValue)v, null);
    }

    public BJsonSchemaOverrideFolder getOverrides() {
        return (BJsonSchemaOverrideFolder)this.get(overrides);
    }

    public void setOverrides(BJsonSchemaOverrideFolder v) {
        this.set(overrides, (BValue)v, null);
    }

    public BJsonSchemaDebugFolder getDebug() {
        return (BJsonSchemaDebugFolder)this.get(debug);
    }

    public void setDebug(BJsonSchemaDebugFolder v) {
        this.set(debug, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJsonSchema getSchema() {
        return (BJsonSchema)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BJsonSchema.TYPE);
    }

    public BIcon getIcon() {
        BIcon base = super.getIcon();
        return BIcon.make((BIcon)base, (BIcon)BIcon.make((String)"module://icons/x16/badges/gear.png"));
    }

    private void setupDate() {
        try {
            this.dateFormat = new SimpleDateFormat(this.getDateFormatPattern());
        }
        catch (RuntimeException re) {
            JsonSchemaUtil.logger.warning("Ignoring bad date format pattern " + this.getDateFormatPattern());
            this.setDateFormatPattern(DEFAULT_DATE_PATTERN);
        }
    }

    public void started() throws Exception {
        this.setupDate();
        super.started();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(dateFormatPattern)) {
            this.setupDate();
        } else if (property.equals(nameCasingRule) || property.equals(nameSpacingRule)) {
            this.getSchema().fireSchemaModified(BSchemaEvent.namingStrategyChanged);
        }
    }

    public String formatTime(BAbsTime input) {
        if (input.getMillis() == 0L) {
            return "";
        }
        Date dateTime = new Date(input.getMillis());
        return this.getSchema().getConfig().getDateFormat().format(dateTime);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }
}

