/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.alarm.property;

import com.tridiumx.jsonToolkit.outbound.schema.alarm.property.BIJsonAlarmDataResolver;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="alarmProperty", type="baja:DynamicEnum", defaultValue="getAlarmPropEnum()")
public class BJsonSchemaAlarmRecordProperty
extends BJsonSchemaProperty<Object>
implements BIJsonAlarmDataResolver {
    public static final Property alarmProperty = BJsonSchemaAlarmRecordProperty.newProperty((int)0, (BValue)BJsonSchemaAlarmRecordProperty.getAlarmPropEnum(), null);
    public static final Type TYPE = Sys.loadType(BJsonSchemaAlarmRecordProperty.class);
    private Object resolvedValue;
    private static final String FALLBACK_TO_EMPTY_STRING = "";
    private static final int MAX_FROZEN_PROP_ORDINAL = new BAlarmRecord().getFrozenPropertiesArray().length;

    public BDynamicEnum getAlarmProperty() {
        return (BDynamicEnum)this.get(alarmProperty);
    }

    public void setAlarmProperty(BDynamicEnum v) {
        this.set(alarmProperty, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object getJsonValue() {
        return this.resolvedValue;
    }

    @Override
    public void resolve(BAlarmRecord r) {
        String tag = this.getAlarmProperty().getTag();
        try {
            Object object = this.resolvedValue = this.getAlarmProperty().getOrdinal() < MAX_FROZEN_PROP_ORDINAL ? r.get(tag) : r.getAlarmFacet(tag);
            if (this.resolvedValue == null) {
                throw new NullPointerException("Null value for Alarm Property " + tag);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolved value [" + tag + "] from alarm record: " + this.resolvedValue);
            }
            if (tag.equals("msgText") || tag.equals("instructions")) {
                String s = this.resolvedValue.toString();
                BFormat res = BFormat.make((String)s);
                this.resolvedValue = res.format((Object)r, Context.NULL);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Formatted " + tag + " value as: " + this.resolvedValue);
                }
            }
        }
        catch (NullPointerException e) {
            log.log(Level.WARNING, "Could not find alarm property " + tag + " on " + r.toSummaryString(), BJsonSchemaAlarmRecordProperty.isLogFinest() ? e : null);
            this.resolvedValue = FALLBACK_TO_EMPTY_STRING;
        }
    }

    private static BDynamicEnum getAlarmPropEnum() {
        Property[] props = new BAlarmRecord().getFrozenPropertiesArray();
        String[] alarmData = BAlarmRecord.getAlarmDataFields();
        String[] values = new String[props.length + alarmData.length];
        for (int i = 0; i < values.length; ++i) {
            if (i < props.length) {
                if (BJsonSchemaAlarmRecordProperty.isLogFinest()) {
                    log.finest(i + " : " + props[i].getName());
                }
                values[i] = props[i].getName();
                continue;
            }
            if (BJsonSchemaAlarmRecordProperty.isLogFinest()) {
                log.finest(i + " : " + alarmData[i - props.length]);
            }
            values[i] = alarmData[i - props.length];
        }
        return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])values));
    }

    private static boolean isLogFinest() {
        return Sys.isStation() && log.isLoggable(Level.FINEST);
    }

    public static BDynamicEnum getAlarmPropOf(String tag) {
        BEnumRange range = BJsonSchemaAlarmRecordProperty.getAlarmPropEnum().getRange();
        int ordinal = range.tagToOrdinal(tag);
        return BDynamicEnum.make((int)ordinal, (BEnumRange)range);
    }

    public static BJsonSchemaAlarmRecordProperty make(String tag) {
        BJsonSchemaAlarmRecordProperty p = new BJsonSchemaAlarmRecordProperty();
        p.setAlarmProperty(BJsonSchemaAlarmRecordProperty.getAlarmPropOf(tag));
        return p;
    }
}

