/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema;

import com.tridium.json.JSONException;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonProperty;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaTuningPolicy;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaConfigFolder;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BIPostProcessor;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BJsonSchemaMetrics;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaPropertyList;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQueryFolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailException;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryRunner;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaConfigException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaSecurity;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="output", type="BString", defaultValue="BString.DEFAULT", flags=11, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:JsonOutputWidget\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"jsonToolkit:JsonOutputEditor\"))")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="baja:Status", defaultValue="BStatus.down", flags=3), @NiagaraProperty(name="faultCause", type="baja:String", defaultValue="", flags=3), @NiagaraProperty(name="lastUpdated", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="config", type="jsonToolkit:JsonSchemaConfigFolder", defaultValue="new BJsonSchemaConfigFolder()"), @NiagaraProperty(name="queries", type="jsonToolkit:JsonSchemaQueryFolder", defaultValue="new BJsonSchemaQueryFolder()")})
@NiagaraActions(value={@NiagaraAction(name="generateJson", flags=2064), @NiagaraAction(name="forceGenerateJson", flags=2064), @NiagaraAction(name="clearCache", flags=16), @NiagaraAction(name="clearOutput", flags=16), @NiagaraAction(name="executeQueries", flags=16)})
@NiagaraTopic(name="schemaModified", eventType="BSchemaEvent")
public class BJsonSchema
extends BJsonSchemaMember
implements LicenseLimit {
    public static final Property output = BJsonSchema.newProperty((int)11, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:JsonOutputWidget")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:JsonOutputEditor"))));
    public static final Property enabled = BJsonSchema.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonSchema.newProperty((int)3, (BValue)BStatus.down, null);
    public static final Property faultCause = BJsonSchema.newProperty((int)3, (String)"", null);
    public static final Property lastUpdated = BJsonSchema.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property config = BJsonSchema.newProperty((int)0, (BValue)new BJsonSchemaConfigFolder(), null);
    public static final Property queries = BJsonSchema.newProperty((int)0, (BValue)new BJsonSchemaQueryFolder(), null);
    public static final Action generateJson = BJsonSchema.newAction((int)2064, null);
    public static final Action forceGenerateJson = BJsonSchema.newAction((int)2064, null);
    public static final Action clearCache = BJsonSchema.newAction((int)16, null);
    public static final Action clearOutput = BJsonSchema.newAction((int)16, null);
    public static final Action executeQueries = BJsonSchema.newAction((int)16, null);
    public static final Topic schemaModified = BJsonSchema.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonSchema.class);
    protected final ThreadLocal<Context> currentContext = new ThreadLocal();
    protected final QueryRunner queryRunner = new QueryRunner(this);
    private Clock.Ticket queryExecuteTicket = Clock.expiredTicket;
    private Clock.Ticket minWritePublishTicket = Clock.expiredTicket;
    private static final String DEFAULT_OUTPUT = BString.DEFAULT.toString();
    private String lastUser;
    private final Object mutex = new Object();

    public String getOutput() {
        return this.getString(output);
    }

    public void setOutput(String v) {
        this.setString(output, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Override
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Override
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastUpdated() {
        return (BAbsTime)this.get(lastUpdated);
    }

    public void setLastUpdated(BAbsTime v) {
        this.set(lastUpdated, (BValue)v, null);
    }

    public BJsonSchemaConfigFolder getConfig() {
        return (BJsonSchemaConfigFolder)this.get(config);
    }

    public void setConfig(BJsonSchemaConfigFolder v) {
        this.set(config, (BValue)v, null);
    }

    public BJsonSchemaQueryFolder getQueries() {
        return (BJsonSchemaQueryFolder)this.get(queries);
    }

    public void setQueries(BJsonSchemaQueryFolder v) {
        this.set(queries, (BValue)v, null);
    }

    public void generateJson() {
        this.invoke(generateJson, null, null);
    }

    public void forceGenerateJson() {
        this.invoke(forceGenerateJson, null, null);
    }

    public void clearCache() {
        this.invoke(clearCache, null, null);
    }

    public void clearOutput() {
        this.invoke(clearOutput, null, null);
    }

    public void executeQueries() {
        this.invoke(executeQueries, null, null);
    }

    public void fireSchemaModified(BSchemaEvent event) {
        this.fire(schemaModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        this.setup();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() {
        if (this.isRunning() && this.getEnabled() && this.getConfig().getTuningPolicy().getWriteOnStart()) {
            this.generateJson();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled)) {
            if (this.getEnabled()) {
                this.setup();
                if (this.getConfig().getTuningPolicy().getWriteOnEnabled()) {
                    this.generateJson();
                }
            } else {
                this.disableAll();
            }
        } else if (property.getName().equals(BJsonSchemaQueryFolder.queryInterval.getName()) || property.getName().equals(BJsonSchemaTuningPolicy.updateStrategy.getName())) {
            this.cancelQueryExecutionTimer();
            this.processQueries(context);
            this.cancelMinWritePublishTimer();
        } else if (property.equals(output)) {
            this.getConfig().getDebug().getMetrics().outputChanged(this.getOutput());
            if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
                JsonSchemaUtil.logger.fine(String.format("Json schema [%s] new output [%s]", this.getName(), this.getOutput()));
            }
        }
        if (property.getName().equals(BJsonSchemaTuningPolicy.updateStrategy.getName())) {
            this.fireSchemaModified(this.requiresMemberSubscriptions() ? BSchemaEvent.subscriptionsEnabled : BSchemaEvent.subscriptionsDisabled);
        }
    }

    private void setup() {
        if (this.requiresMemberSubscriptions()) {
            this.fireSchemaModified(BSchemaEvent.subscriptionsEnabled);
        }
        this.processQueries(null);
    }

    @Override
    public void started() {
        this.initLicenseProperty();
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.disableAll();
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!ParentLegal.disableChecks && parent instanceof BJsonSchema) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "cannotNestSchema", null);
        }
        return true;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        boolean check;
        boolean bl = check = (child instanceof BIJsonSchemaMember || child instanceof BIPostProcessor) && !(child instanceof BIJsonProperty) && !(child instanceof BJsonSchemaPropertyList);
        if (ParentLegal.disableChecks) {
            if (!check) {
                JsonSchemaUtil.logger.severe("Child not allowed on Schema: " + child.toDebugString() + " @ " + this.toDebugString());
            }
            return true;
        }
        return check;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value.getType().is(BIJsonSchemaMember.TYPE) && ((BIJsonSchemaMember[])this.getChildren(BIJsonSchemaMember.class)).length >= 1) {
            throw new JsonSchemaConfigException(this.getName() + ": Only 1 root member permitted");
        }
    }

    @Override
    public String getJsonName() {
        return "";
    }

    @Override
    public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        this.processChildJsonMembers(jsonWriter, jsonKeysValid);
    }

    public BJsonSchemaMember getRoot() {
        BJsonSchemaMember[] children = (BJsonSchemaMember[])this.getChildren(BJsonSchemaMember.class);
        return children.length > 0 ? children[0] : null;
    }

    protected void disableAll() {
        this.cancelMinWritePublishTimer();
        this.cancelQueryExecutionTimer();
        if (this.isRunning()) {
            this.fireSchemaModified(BSchemaEvent.subscriptionsDisabled);
        }
        this.clearCache();
    }

    protected void startQueryExecutionTimer(Context context) {
        if (this.getEnabled() && this.isRunning() && this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.cov && this.queryExecuteTicket.isExpired() && this.queryIntervalIsSet()) {
            this.queryExecuteTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getQueries().getQueryInterval(), (Action)executeQueries, null);
            this.doExecuteQueries(context);
        }
    }

    private void cancelQueryExecutionTimer() {
        if (!this.queryExecuteTicket.isExpired()) {
            this.queryExecuteTicket.cancel();
            this.queryExecuteTicket = Clock.expiredTicket;
        }
    }

    protected boolean shouldRunQueries() {
        return this.isRunning() && this.getEnabled() && this.queryIntervalIsSet() && this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.onDemandOnly;
    }

    protected boolean queryIntervalIsSet() {
        return this.getQueries().getQueryInterval().getMillis() > 0L;
    }

    protected void cancelMinWritePublishTimer() {
        if (!this.minWritePublishTicket.isExpired()) {
            this.minWritePublishTicket.cancel();
            this.minWritePublishTicket = Clock.expiredTicket;
        }
    }

    public boolean requiresMemberSubscriptions() {
        return this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.cov && !this.isRelative();
    }

    public final void requestGenerateJson(Context context) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("requestGenerateJson called for schema %s", this.getName()));
        }
        this.getConfig().getDebug().getMetrics().incrementRequestCounter();
        BRelTime minWrite = this.getConfig().getTuningPolicy().getMinWriteTime();
        if (minWrite.equals((Object)BRelTime.DEFAULT) || this.maxWriteTimeExceeded()) {
            this.generateAndOutputJson(context);
        } else if (!minWrite.equals((Object)BRelTime.DEFAULT)) {
            this.cancelMinWritePublishTimer();
            this.minWritePublishTicket = Clock.schedule((BComponent)this, (BRelTime)minWrite, (Action)forceGenerateJson, null);
        }
    }

    public String currentUser() {
        Context ctx = this.currentContext.get();
        return ctx == null ? "system" : ctx.getUser().getUsername();
    }

    public boolean userHasPermission(BValue value) {
        return JsonSchemaSecurity.userHasReadPermission(value, this.currentContext.get());
    }

    private boolean maxWriteTimeExceeded() {
        BRelTime maxWrite = this.getConfig().getTuningPolicy().getMaxWriteTime();
        return maxWrite != BRelTime.DEFAULT && this.getLastUpdated().isBefore(BAbsTime.now().subtract(maxWrite));
    }

    public void doGenerateJson(Context context) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
            JsonSchemaUtil.logger.finest(String.format("Json Schema %s doGenerateJson called", this.getName()));
        }
        this.requestGenerateJson(context);
    }

    public void doForceGenerateJson(Context context) {
        this.cancelMinWritePublishTimer();
        this.generateAndOutputJson(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void generateAndOutputJson(Context context) {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        LicenseLimit.checkExportLicensed();
        Object object = this.mutex;
        synchronized (object) {
            this.doWithContext(context, () -> {
                if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
                    JsonSchemaUtil.logger.fine(String.format("doGenerateJson called for schema %s", this.getName()));
                }
                this.processQueries(context);
                JSONStringer json = new JSONStringer();
                Throwable schemaGenException = null;
                try {
                    this.process((JSONWriter)json, false);
                }
                catch (JSONException | PermissionException e) {
                    schemaGenException = e;
                    String msg = this.getName() + " Failed to process json schema: " + e.getMessage();
                    if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
                        msg = msg + '\n' + json.toString();
                    }
                    json = new JSONStringer();
                    JsonSchemaUtil.logger.log(Level.SEVERE, msg, e);
                }
                String output = json.toString();
                this.setOutput(output != null ? output : DEFAULT_OUTPUT);
                this.setLastUpdated(BAbsTime.now());
                this.postProcessors((Exception)schemaGenException);
            });
        }
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("doGenerateJson complete for schema %s", this.getName()));
        }
    }

    protected void processQueries(Context context) {
        this.startQueryExecutionTimer(context);
        if (this.shouldRunQueries()) {
            this.doExecuteQueries(context);
        }
    }

    public void doExecuteQueries(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.doWithContext(context, () -> {
            try {
                this.queryRunner.executeQueries(this.getBaseObject(), this.currentContext.get());
            }
            catch (QueryFailException e) {
                JsonSchemaUtil.logger.severe(String.format("Json Schema [%s] query execution failed: [%s]", this.getName(), e.getMessage()));
            }
        });
    }

    public void doClearCache() {
        if (this.isRunning()) {
            this.fireSchemaModified(BSchemaEvent.cacheCleared);
        }
        for (BJsonSchemaQuery query : (BJsonSchemaQuery[])this.getQueries().getChildren(BJsonSchemaQuery.class)) {
            query.clearLastResult();
        }
    }

    public void doClearOutput() {
        this.setOutput(DEFAULT_OUTPUT);
        this.setLastUpdated(BAbsTime.DEFAULT);
    }

    public OrdTarget getOrdTarget(BJsonSchemaBoundMember member, BObject overrideBase) {
        return member.getBinding().resolve((BObject)(overrideBase != null ? overrideBase : this.getBaseObject()), this.currentContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithContext(Context context, Runnable runnable) {
        boolean contextAlreadySet;
        boolean bl = contextAlreadySet = this.currentContext.get() != null;
        if (!contextAlreadySet) {
            this.setCurrentContext(context);
        }
        try {
            runnable.run();
        }
        finally {
            if (!contextAlreadySet) {
                this.currentContext.remove();
            }
        }
    }

    private void setCurrentContext(Context context) {
        String user;
        if (context == null) {
            context = JsonSchemaSecurity.createServiceContext();
        }
        this.currentContext.set(context);
        if (context != null && context.getUser() != null && !(user = context.getUser().getName()).equals(this.lastUser)) {
            this.synchronousSchemaEvent(BSchemaEvent.cacheCleared);
            this.lastUser = user;
        }
    }

    public boolean isRelative() {
        return false;
    }

    public BJsonSchemaMetrics getMetrics() {
        return this.getConfig().getDebug().getMetrics();
    }

    public BComplex getBaseObject() {
        return Sys.getStation();
    }
}

