/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.selector;

import com.jayway.jsonpath.InvalidJsonException;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.selector.BJsonStringSelector;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="path", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="status", type="baja:Status", defaultValue="BStatus.ok", flags=65537)})
public class BJsonPath
extends BJsonStringSelector {
    public static final Property path = BJsonPath.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property status = BJsonPath.newProperty((int)65537, (BValue)BStatus.ok, null);
    public static final Type TYPE = Sys.loadType(BJsonPath.class);

    public String getPath() {
        return this.getString(path);
    }

    public void setPath(String v) {
        this.setString(path, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        block6: {
            try {
                Object result = this.runJsonPathQuery(message.getString(), this.getPath(), Object.class);
                if (result instanceof String || result instanceof Number || result instanceof Boolean) {
                    this.setNewGoodOutValue(result.toString());
                    break block6;
                }
                if (result instanceof JSONAware) {
                    this.setNewGoodOutValue(((JSONAware)result).toJSONString());
                    break block6;
                }
                if (result instanceof LinkedHashMap) {
                    Map tempResult = (Map)result;
                    this.setNewGoodOutValue(new JSONObject(tempResult).toJSONString());
                    break block6;
                }
                this.setStatus(BStatus.fault);
                throw new RoutingFailedException(message.getString(), "Could not extract value from result type " + result.getClass(), null);
            }
            catch (InvalidJsonException ije) {
                this.setStatus(BStatus.fault);
                throw new RoutingFailedException(message.getString(), "JSON Path error: Invalid JSON input", ije);
            }
            catch (Exception e) {
                this.setStatus(BStatus.fault);
                throw new RoutingFailedException(message.getString(), "JSON Path error: " + e.getMessage(), e);
            }
        }
    }

    protected void setNewGoodOutValue(String newString) {
        this.setOut(newString);
        this.setStatus(BStatus.ok);
    }

    @Override
    protected Property[] getRerunTriggers() {
        return new Property[]{path};
    }
}

