/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridiumx.jsonToolkit.inbound.BJsonInbound;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.routing.slot.BAddSlotDetail;
import com.tridiumx.jsonToolkit.inbound.routing.slot.DynamicSlotUtil;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="learnMode", type="boolean", defaultValue="false")
@NiagaraAction(name="addSlot", parameterType="jsonToolkit:AddSlotDetail", defaultValue="new BAddSlotDetail()")
public abstract class BJsonRouter
extends BJsonInbound
implements DynamicSlotUtil {
    public static final Property learnMode = BJsonRouter.newProperty((int)0, (boolean)false, null);
    public static final Action addSlot = BJsonRouter.newAction((int)0, (BValue)new BAddSlotDetail(), null);
    public static final Type TYPE = Sys.loadType(BJsonRouter.class);

    public boolean getLearnMode() {
        return this.getBoolean(learnMode);
    }

    public void setLearnMode(boolean v) {
        this.setBoolean(learnMode, v, null);
    }

    public void addSlot(BAddSlotDetail parameter) {
        this.invoke(addSlot, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.resetDynamicProperties(this);
    }

    public void added(Property property, Context context) {
        this.readOnlySummaryOnAdd(this, property);
        super.added(property, context);
    }

    public void doAddSlot(BAddSlotDetail detail) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding " + detail.getSlotName() + ' ' + (Object)((Object)detail.getSlotType()));
        }
        this.add(SlotPath.escape((String)detail.getSlotName()), (BValue)detail.getSlotDefaultValue());
    }

    public void setNewValueOnSlot(String message, String slotName, BValue value) throws RoutingFailedException {
        try {
            this.set(slotName, value);
        }
        catch (NoSuchSlotException nsse) {
            if (this.getLearnMode()) {
                try {
                    this.add(slotName, value, 9);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not create learnt slot " + slotName, e);
                }
            }
            throw new RoutingFailedException(message, "Could not find property " + slotName, nsse);
        }
    }
}

