/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.handler.exportMarker;

import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerNotFoundException;
import com.tridiumx.jsonToolkit.inbound.handler.BJsonSetPointHandler;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BJsonExportSetpointHandler
extends BJsonSetPointHandler {
    public static final Type TYPE = Sys.loadType(BJsonExportSetpointHandler.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BControlPoint lookupTarget(BString msg, String id) throws RoutingFailedException {
        try {
            BJsonExportMarker foundExportMarker = BJsonSchemaService.register().lookupExportMarker(id);
            if (foundExportMarker != null) {
                BComponent target = (BComponent)foundExportMarker.getParent();
                if (!(target instanceof BControlPoint)) {
                    throw new RoutingFailedException(msg.getString(), "Expected a control point: " + id, null);
                }
                BControlPoint cp = (BControlPoint)target;
                if (cp.isWritablePoint() && foundExportMarker.getPlatformWritable()) {
                    return cp;
                }
                throw new RoutingFailedException(msg.getString(), "Write denied on Export Marker with id: " + id, null);
            }
        }
        catch (ExportMarkerNotFoundException e) {
            throw new RoutingFailedException(msg.getString(), "Cannot find export marker", e);
        }
        throw new RoutingFailedException(msg.getString(), "Could not find Export Marker with id: " + id, null);
    }

    @Override
    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(BIcon.std((String)"diagnostics.png"));
    }
}

