/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.handler;

import com.tridium.json.JSONObject;
import com.tridiumx.jsonToolkit.inbound.handler.BJsonHandler;
import com.tridiumx.jsonToolkit.inbound.handler.SetpointValueRejectedException;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaSecurity;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.UnsupportedConversionTypeException;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="idKey", type="String", defaultValue="niagaraId"), @NiagaraProperty(name="valueKey", type="String", defaultValue="value"), @NiagaraProperty(name="slotNameKey", type="String", defaultValue="slotName"), @NiagaraProperty(name="defaultWriteSlot", type="String", defaultValue="BString.DEFAULT")})
public class BJsonSetPointHandler
extends BJsonHandler {
    public static final Property idKey = BJsonSetPointHandler.newProperty((int)0, (String)"niagaraId", null);
    public static final Property valueKey = BJsonSetPointHandler.newProperty((int)0, (String)"value", null);
    public static final Property slotNameKey = BJsonSetPointHandler.newProperty((int)0, (String)"slotName", null);
    public static final Property defaultWriteSlot = BJsonSetPointHandler.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BJsonSetPointHandler.class);

    public String getIdKey() {
        return this.getString(idKey);
    }

    public void setIdKey(String v) {
        this.setString(idKey, v, null);
    }

    public String getValueKey() {
        return this.getString(valueKey);
    }

    public void setValueKey(String v) {
        this.setString(valueKey, v, null);
    }

    public String getSlotNameKey() {
        return this.getString(slotNameKey);
    }

    public void setSlotNameKey(String v) {
        this.setString(slotNameKey, v, null);
    }

    public String getDefaultWriteSlot() {
        return this.getString(defaultWriteSlot);
    }

    public void setDefaultWriteSlot(String v) {
        this.setString(defaultWriteSlot, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString msg, Context cx) throws RoutingFailedException {
        block7: {
            try {
                Map keyValues = this.lookupKeyValues(msg.toString(), LOG, new String[]{this.getIdKey(), this.getSlotNameKey(), this.getValueKey()});
                String id = (String)keyValues.get(this.getIdKey());
                String slotNameToSet = (String)keyValues.get(this.getSlotNameKey());
                Object value = keyValues.get(this.getValueKey());
                BJsonSetPointHandler.validateParams(msg, id, value);
                BControlPoint target = this.lookupTarget(msg, id);
                if (target == null) {
                    throw new RoutingFailedException(msg.getString(), "Cannot find target with id " + id, null);
                }
                LOG.fine("Found Export Marker with id: " + id);
                if (slotNameToSet != null && !slotNameToSet.isEmpty()) {
                    this.setValue(target, value, slotNameToSet);
                    break block7;
                }
                if (!this.getDefaultWriteSlot().equals(BString.DEFAULT.getString())) {
                    this.setValue(target, value, this.getDefaultWriteSlot());
                    break block7;
                }
                throw new RoutingFailedException(msg.getString(), "Missing priority", null);
            }
            catch (UnsupportedConversionTypeException conv) {
                throw new RoutingFailedException(msg.getString(), "Cannot convert input", conv);
            }
            catch (NoSuchSlotException nse) {
                throw new RoutingFailedException(msg.getString(), "Cannot find slot to write to", nse);
            }
            catch (SetpointValueRejectedException e) {
                throw new RoutingFailedException(msg.getString(), "Setpoint value change rejected: " + e.getMessage(), e);
            }
        }
    }

    protected BControlPoint lookupTarget(BString msg, String id) throws RoutingFailedException {
        BOrd ord = BOrd.make((String)("h:" + id));
        BObject found = ord.get((BObject)Sys.getStation());
        if (found.getType().is(BControlPoint.TYPE)) {
            return (BControlPoint)found.as(BControlPoint.class);
        }
        throw new RoutingFailedException(msg.getString(), "Target must be a control component", null);
    }

    private static void validateParams(BString msg, String id, Object value) throws RoutingFailedException {
        if (id == null) {
            throw new RoutingFailedException(msg.getString(), "Incoming message missing id", null);
        }
        if (value == null) {
            throw new RoutingFailedException(msg.getString(), "Incoming message missing value", null);
        }
    }

    private void setValue(BControlPoint target, Object value, String slotNameToSet) throws UnsupportedConversionTypeException, SetpointValueRejectedException {
        String previousValueForAudit = target.get(slotNameToSet).toString();
        BIStatusValue statusValue = BJsonSetPointHandler.extractStatusValue(value);
        BJsonSetPointHandler.validateValue(target, statusValue);
        Context serviceContext = BJsonSetPointHandler.checkPermissions(target, slotNameToSet, previousValueForAudit);
        if (statusValue != null) {
            target.set(slotNameToSet, (BValue)statusValue);
        } else {
            Property property = target.getProperty(slotNameToSet);
            target.set(slotNameToSet, property.getDefaultValue());
            ((BStatusValue)target.get(slotNameToSet)).setStatusNull(true);
        }
        this.result("Set Success", null);
        Log.audit(serviceContext, "Changed", TYPE.getTypeName() + " > " + target.getSlotPath(), slotNameToSet, previousValueForAudit, target.get(slotNameToSet));
    }

    private static Context checkPermissions(BControlPoint target, String slotNameToSet, String previousValueForAudit) throws SetpointValueRejectedException {
        Context serviceContext = JsonSchemaSecurity.createServiceContext();
        if (serviceContext == null) {
            throw new SetpointValueRejectedException("Set point value via JSON exportMarker requires a service user setup @ " + BJsonSchemaService.TYPE.getTypeName() + " / " + BJsonSchemaService.runAsUser);
        }
        if (!JsonSchemaSecurity.userHasWritePermission((BValue)target, serviceContext)) {
            Log.audit(serviceContext, "Change Failed", TYPE.getTypeName() + " > " + target.getSlotPath(), slotNameToSet, previousValueForAudit, target.get(slotNameToSet));
            throw new SetpointValueRejectedException("Rejected write based on lack of permissions for " + serviceContext.getUser());
        }
        return serviceContext;
    }

    private static void validateValue(BControlPoint target, BIStatusValue newStatusValue) throws SetpointValueRejectedException {
        if (newStatusValue != null) {
            BStatusValue currentValue = target.getStatusValue();
            if (!newStatusValue.getType().is(currentValue.getType())) {
                throw new SetpointValueRejectedException(String.format("Incorrect type [%s] for [%s]", newStatusValue.getType(), target.getClass().getSimpleName()));
            }
            if (target instanceof BNumericWritable) {
                BNumericWritable tn = (BNumericWritable)target;
                BStatusNumeric sn = (BStatusNumeric)newStatusValue;
                BJsonSetPointHandler.verifyNumericBounds((BValue)sn, tn.getFacets());
            }
        }
    }

    private static BIStatusValue extractStatusValue(Object value) throws UnsupportedConversionTypeException {
        BIStatusValue statusValue;
        if (value == JSONObject.NULL) {
            statusValue = null;
        } else {
            BValue v = JsonSchemaUtil.toBValue(value);
            statusValue = BStatusValue.make((BObject)v);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Extracted statusValue: " + statusValue);
        }
        return statusValue;
    }

    public static void verifyNumericBounds(BValue v, BFacets facets) throws SetpointValueRejectedException {
        if (facets == null) {
            return;
        }
        if (v instanceof BStatusNumeric) {
            v = ((BStatusNumeric)v).getValueValue();
        }
        BNumber num = (BNumber)v;
        double value = num.getNumeric();
        BNumber min = (BNumber)facets.get("min");
        BNumber max = (BNumber)facets.get("max");
        if (min != null && value < min.getNumeric()) {
            throw BJsonSetPointHandler.CreateRejectedException(num, min, max, min, Character.valueOf('<'));
        }
        if (max != null && value > max.getNumeric()) {
            throw BJsonSetPointHandler.CreateRejectedException(num, min, max, max, Character.valueOf('>'));
        }
    }

    private static SetpointValueRejectedException CreateRejectedException(BNumber n, BNumber min, BNumber max, BNumber failedOn, Character operator) {
        return new SetpointValueRejectedException(n.getNumeric() + " " + operator + " " + failedOn + " [" + min + ',' + max + ']');
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"diagnostics.png");
    }

    @Override
    protected Property[] getRerunTriggers() {
        return new Property[]{idKey, valueKey, slotNameKey};
    }
}

