/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.routing.ext.BRouterExt;
import com.tridiumx.jsonToolkit.inbound.routing.ext.RouterExtException;
import com.tridiumx.jsonToolkit.util.JsonKeyExtractUtil;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ThreadPool;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="lastResult", type="baja:String", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="lastResultTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastInput", type="baja:String", defaultValue="BString.DEFAULT", flags=65539)})
@NiagaraActions(value={@NiagaraAction(name="route", parameterType="baja:String", defaultValue="BString.make(\"\")", flags=2072), @NiagaraAction(name="runLastInput", flags=2048)})
public abstract class BJsonInbound
extends BComponent
implements JsonKeyExtractUtil {
    public static final Property enabled = BJsonInbound.newProperty((int)0, (boolean)true, null);
    public static final Property lastResult = BJsonInbound.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property lastResultTime = BJsonInbound.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastInput = BJsonInbound.newProperty((int)65539, (BValue)BString.DEFAULT, null);
    public static final Action route = BJsonInbound.newAction((int)2072, (BValue)BString.make((String)""), null);
    public static final Action runLastInput = BJsonInbound.newAction((int)2048, null);
    public static final Type TYPE = Sys.loadType(BJsonInbound.class);
    public static final Logger LOG = Log.child("routing");
    public static final Property[] NO_PROPERTIES = new Property[0];

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getLastResult() {
        return this.getString(lastResult);
    }

    public void setLastResult(String v) {
        this.setString(lastResult, v, null);
    }

    public BAbsTime getLastResultTime() {
        return (BAbsTime)this.get(lastResultTime);
    }

    public void setLastResultTime(BAbsTime v) {
        this.set(lastResultTime, (BValue)v, null);
    }

    public String getLastInput() {
        return this.getString(lastInput);
    }

    public void setLastInput(String v) {
        this.setString(lastInput, v, null);
    }

    public void route(BString parameter) {
        this.invoke(route, (BValue)parameter, null);
    }

    public void runLastInput() {
        this.invoke(runLastInput, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected Property[] getRerunTriggers() {
        return NO_PROPERTIES;
    }

    public void changed(Property property, Context context) {
        Property[] rerunOnChange = this.getRerunTriggers();
        if (this.isRunning() && Arrays.asList(rerunOnChange).contains(property) && !this.getLastInput().isEmpty()) {
            this.doRoute((BString)this.get(lastInput), context);
        }
    }

    public void doRoute(BString string, Context cx) {
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        try {
            this.process(string, cx);
        }
        catch (RoutingFailedException e) {
            this.routingFailed(e.getPayload(), this.getLexicon().get("failedRoute") + ": " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
        }
        catch (Exception e) {
            this.routingFailed(string.getString(), this.getLexicon().get("cannotRoute") + " - " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
        }
    }

    private void process(BString string, Context cx) throws RoutingFailedException {
        LicenseLimit.checkImportLicensed();
        this.setLastInput(string.getString());
        this.sanityCheck(string.toString());
        this.routeValue(string, cx);
        this.setLastResult("Routed");
        this.setLastResultTime(BAbsTime.now());
    }

    protected abstract void routeValue(BString var1, Context var2) throws RoutingFailedException;

    public void doRunLastInput(Context cx) {
        this.doRoute((BString)this.get(lastInput), cx);
    }

    protected void processRouterExt(BString message) {
        BRouterExt[] utils;
        for (BRouterExt u : utils = (BRouterExt[])this.getChildren(BRouterExt.class)) {
            try {
                u.route(message);
            }
            catch (RouterExtException re) {
                LOG.log(Level.WARNING, u.getName(), re);
                return;
            }
        }
    }

    protected void routingFailed(String payload, String reason, Exception e) {
        StringBuilder message = new StringBuilder(String.format("Routing failed in [%s] because [%s]", this.getName(), reason));
        if (!payload.isEmpty()) {
            message.append(String.format(" for message [%s]", this.loggableJson(payload)));
        }
        if (e != null && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.WARNING, message.toString(), e);
        } else {
            LOG.log(Level.WARNING, message.toString());
        }
        this.setLastResult(message.toString());
        this.setLastResultTime(BAbsTime.now());
    }

    protected <T> T runJsonPathQuery(String message, String query, Class<T> type) throws RoutingFailedException {
        try {
            return (T)AccessController.doPrivileged(() -> {
                DocumentContext jsonContext = JsonPath.parse(message);
                return jsonContext.read(query, type, new Predicate[0]);
            });
        }
        catch (InvalidJsonException ije) {
            throw new RoutingFailedException(message, "JSON Path error: Invalid JSON input", ije);
        }
        catch (Exception e) {
            throw new RoutingFailedException(message, "JSON Path error: " + e.getMessage(), e);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return ThreadPool.post(this, action, argument, cx);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"connections.png");
    }
}

