/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.exportMarker;

import com.tridiumx.jsonToolkit.exportMarker.DuplicateExportIdException;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerIdInvalidException;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerNotFoundException;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionEventFilter;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.FilterResult;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="sendHistorySince", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=69), @NiagaraProperty(name="sendAlarmSince", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=69), @NiagaraProperty(name="platformWritable", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="resetId", flags=384), @NiagaraAction(name="forceSetId", parameterType="baja:String", defaultValue="BString.DEFAULT", flags=388)})
public class BJsonExportMarker
extends BComponent
implements SubscriptionEventFilter {
    public static final Property id = BJsonExportMarker.newProperty((int)65, (BValue)BString.DEFAULT, null);
    public static final Property sendHistorySince = BJsonExportMarker.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Property sendAlarmSince = BJsonExportMarker.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Property platformWritable = BJsonExportMarker.newProperty((int)0, (boolean)false, null);
    public static final Action resetId = BJsonExportMarker.newAction((int)384, null);
    public static final Action forceSetId = BJsonExportMarker.newAction((int)388, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BJsonExportMarker.class);
    public static final Logger log = Log.child(TYPE.getDisplayName(Context.NULL));
    private static final String EMPTY_STRING = "";
    static final String FILTER_ENABLED_SLOT = "filterEnabled";
    static final String TOLERANCE_SLOT = "covTolerance";
    static final String LAST_VALUE_SLOT = "lastPublishedValue";
    static final String NUMERIC_OUT = BNumericPoint.out.getName();
    private boolean firstPublish = true;
    private final Object mutex = new Object();
    private String oldId = "";
    private final Object lock = new Object();

    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    public BAbsTime getSendHistorySince() {
        return (BAbsTime)this.get(sendHistorySince);
    }

    public void setSendHistorySince(BAbsTime v) {
        this.set(sendHistorySince, (BValue)v, null);
    }

    public BAbsTime getSendAlarmSince() {
        return (BAbsTime)this.get(sendAlarmSince);
    }

    public void setSendAlarmSince(BAbsTime v) {
        this.set(sendAlarmSince, (BValue)v, null);
    }

    public boolean getPlatformWritable() {
        return this.getBoolean(platformWritable);
    }

    public void setPlatformWritable(boolean v) {
        this.setBoolean(platformWritable, v, null);
    }

    public void resetId() {
        this.invoke(resetId, null, null);
    }

    public void forceSetId(BString parameter) {
        this.invoke(forceSetId, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BJsonExportMarker make(String id, boolean writable) {
        BJsonExportMarker exportMarker = new BJsonExportMarker();
        exportMarker.setId(id);
        exportMarker.setPlatformWritable(writable);
        return exportMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetId(Context cx) throws DuplicateExportIdException {
        Object object = this.lock;
        synchronized (object) {
            this.unregister();
            this.setId(EMPTY_STRING);
            this.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doForceSetId(BString id, Context cx) throws DuplicateExportIdException {
        Object object = this.lock;
        synchronized (object) {
            this.unregister();
            this.setId(id.toString());
            this.register();
        }
    }

    public void checkInvalidId() throws ExportMarkerIdInvalidException {
        if (this.getId().equals(EMPTY_STRING)) {
            throw new ExportMarkerIdInvalidException(this.getParent().getName());
        }
    }

    public void started() throws DuplicateExportIdException {
        this.register();
        this.ensureNumericToleranceSlots();
    }

    private void ensureNumericToleranceSlots() {
        if (this.getParent() instanceof BNumericPoint) {
            if (this.getProperty(FILTER_ENABLED_SLOT) == null) {
                this.add(FILTER_ENABLED_SLOT, (BValue)BBoolean.TRUE, 2048);
            }
            if (this.getProperty(TOLERANCE_SLOT) == null) {
                this.add(TOLERANCE_SLOT, (BValue)BDouble.DEFAULT, 2048);
            }
            if (this.getProperty(LAST_VALUE_SLOT) == null) {
                this.add(LAST_VALUE_SLOT, (BValue)BDouble.DEFAULT, 3);
            }
        } else {
            if (this.getProperty(FILTER_ENABLED_SLOT) != null) {
                this.remove(FILTER_ENABLED_SLOT);
            }
            if (this.getProperty(TOLERANCE_SLOT) != null) {
                this.remove(TOLERANCE_SLOT);
            }
            if (this.getProperty(LAST_VALUE_SLOT) != null) {
                this.remove(LAST_VALUE_SLOT);
            }
        }
    }

    private void checkForDuplicateId() throws DuplicateExportIdException {
        try {
            BJsonExportMarker existing = BJsonSchemaService.register().lookupExportMarker(this.getId());
            if (existing != null) {
                throw new DuplicateExportIdException(this.getId() + " already exists at " + existing.getSlotPath());
            }
        }
        catch (ExportMarkerNotFoundException exportMarkerNotFoundException) {
            // empty catch block
        }
    }

    public void stopped() {
        this.unregister();
    }

    private void register() throws DuplicateExportIdException {
        block3: {
            if (((BJsonExportMarker[])this.getParentComponent().getChildren(BJsonExportMarker.class)).length > 1) {
                throw new DuplicateExportIdException(this.getParent().getName() + " has more that one export marker");
            }
            this.checkForDuplicateId();
            try {
                BJsonSchemaService.register().registerMarker(this);
            }
            catch (ExportMarkerIdInvalidException e) {
                if (!log.isLoggable(Level.FINEST)) break block3;
                log.log(Level.FINEST, "Could not register invalid id " + this.getId() + " on point " + this.getParent().getName());
            }
        }
    }

    private void unregister() {
        block3: {
            if (this.isRunning()) {
                try {
                    BJsonSchemaService.register().unregisterMarker(this);
                }
                catch (ExportMarkerIdInvalidException e) {
                    if (!log.isLoggable(Level.FINEST)) break block3;
                    log.log(Level.FINEST, "Stopping marker", e);
                }
            }
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(id)) {
            try {
                this.checkForDuplicateId();
                BJsonSchemaService.register().updateMarker(this.oldId, this);
                this.oldId = this.getId();
            }
            catch (DuplicateExportIdException | ExportMarkerIdInvalidException | ExportMarkerNotFoundException e) {
                log.log(Level.WARNING, this.getParent().getName() + " Changing Export Id", e);
            }
        }
    }

    @Override
    public FilterResult test(BComponentEvent event) {
        if (!(event.getValue() instanceof BStatusNumeric) || event.getId() != 0) {
            return FilterResult.CONTINUE;
        }
        if (!event.getSlotName().equals(NUMERIC_OUT)) {
            return FilterResult.IGNORE;
        }
        return this.changeToleranceExceeded(event) ? FilterResult.IGNORE : FilterResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeToleranceExceeded(BComponentEvent event) {
        this.ensureNumericToleranceSlots();
        BValue newValue = event.getValue();
        double tolerance = this.getDouble(this.getProperty(TOLERANCE_SLOT));
        Object object = this.mutex;
        synchronized (object) {
            double diff;
            BNumber lastPublishedValue;
            if (!this.firstPublish && this.getBoolean(this.getProperty(FILTER_ENABLED_SLOT)) && tolerance > 0.0 && (lastPublishedValue = (BNumber)this.get(LAST_VALUE_SLOT).as(BNumber.class)) != null && (diff = Math.abs(lastPublishedValue.getDouble() - ((BStatusNumeric)newValue.as(BStatusNumeric.class)).getValue())) < tolerance) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.format("Json schema filtering out change to [%s] slot [%s] difference [%s] tolerance [%s] last published [%s]", event.getSourceComponent(), event.getSlotName(), diff, tolerance, lastPublishedValue.getDouble()));
                }
                return true;
            }
            this.firstPublish = false;
            this.set(LAST_VALUE_SLOT, (BValue)((BStatusNumeric)newValue.as(BStatusNumeric.class)).getValueValue().as(BNumber.class));
        }
        return false;
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BControlPoint.TYPE);
    }

    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(super.getIcon());
    }

    public static BIcon addExportBadge(BIcon base) {
        return BIcon.make((BIcon)base, (BIcon)BIcon.make((String)"module://icons/x16/badges/play.png"));
    }
}

