/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlRoot;
import com.tridium.html.util.HtmlTag;
import com.tridium.html.util.HtmlText;
import com.tridium.html.util.HtmlTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class HtmlParser
extends HtmlTokenizer {
    private static final Logger log = Logger.getLogger("html");
    private final HtmlNode root;
    private HtmlNode currentTag;
    private final ArrayList<HtmlNode> tagStack;
    private static Map<String, String> noEndTag = new HashMap<String, String>();
    private static Map<String, String> ignorableEndTag;

    public HtmlParser() {
        this.currentTag = this.root = new HtmlRoot();
        this.tagStack = new ArrayList();
    }

    public HtmlRoot getParseRoot() {
        return (HtmlRoot)this.root;
    }

    @Override
    public void handleText(String str) {
        if (str.length() > 0) {
            this.add(new HtmlText(str));
        }
    }

    @Override
    public void handleComment(String str) {
    }

    @Override
    public void handleStartTag(int lineNo, String str, Map<String, String> attribs) {
        HtmlNode parent;
        HtmlTag tag = new HtmlTag(str, attribs, lineNo);
        int n = 0;
        for (parent = this.currentTag; parent != null && !this.validParent(parent, tag); parent = parent.getParent()) {
            ++n;
        }
        if (parent == null) {
            log.warning("Cannot find valid parent for '<" + str + ">' (line " + (lineNo + 1) + ").");
        } else if (n > 0) {
            log.warning("Missing end tag before '<" + str + ">' (line " + (lineNo + 1) + ").");
            for (int i = 0; i < n; ++i) {
                this.moveToParent();
            }
        }
        this.add(tag);
        if (!noEndTag.containsKey(str) && !ignorableEndTag.containsKey(str)) {
            this.moveToChild();
        }
    }

    @Override
    public void handleEndTag(int lineNo, String str) {
        if (ignorableEndTag.containsKey(str)) {
            return;
        }
        if (this.tagStack.size() == 0) {
            log.warning("Unmatched '</" + str + ">' (line " + (lineNo + 1) + ").");
        } else {
            String name;
            boolean found = false;
            int n = 0;
            for (HtmlNode node = this.currentTag; node != null; node = node.getParent()) {
                ++n;
                if (!(node instanceof HtmlTag) || !(name = ((HtmlTag)node).getTagName()).equals(str)) continue;
                found = true;
                break;
            }
            if (found) {
                for (int i = 0; i < n; ++i) {
                    this.moveToParent();
                }
            } else {
                name = ((HtmlTag)this.currentTag).getTagName();
                if (!name.equals("P")) {
                    log.warning("WARNING: Unmatched '</" + str + ">' (line " + (lineNo + 1) + ").");
                }
            }
        }
    }

    private void add(HtmlNode n) {
        this.currentTag.add(n);
    }

    private void moveToChild() {
        this.currentTag = this.currentTag.get(this.currentTag.size() - 1);
        this.tagStack.add(this.currentTag);
    }

    private void moveToParent() {
        this.currentTag = this.currentTag.getParent();
        this.tagStack.remove(this.tagStack.size() - 1);
    }

    private boolean validParent(HtmlNode parent, HtmlTag child) {
        String name = child.getTagName();
        if (name.equals("TD") || name.equals("TH")) {
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof HtmlTag)) {
                return false;
            }
            return ((HtmlTag)parent).getTagName().equals("TR");
        }
        if (name.equals("TR")) {
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof HtmlTag)) {
                return false;
            }
            return ((HtmlTag)parent).getTagName().equals("TABLE");
        }
        return true;
    }

    static {
        noEndTag.put("BR", null);
        noEndTag.put("HR", null);
        noEndTag.put("IMG", null);
        noEndTag.put("LINK", null);
        ignorableEndTag = new HashMap<String, String>();
        ignorableEndTag.put("DD", null);
        ignorableEndTag.put("DT", null);
        ignorableEndTag.put("LI", null);
    }
}

