/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.ui.util.LayoutUtil;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;

public class BReplaceDialog
extends BDialog {
    public static final Property yesButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("yes"), null);
    public static final Property yesAllButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("yes all"), null);
    public static final Property noButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("no"), null);
    public static final Property noAllButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("no all"), null);
    public static final Property cancelButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("_cancel"), null);
    public static final Action buttonPressed = BReplaceDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BReplaceDialog.class);
    private static String cancelText;
    private static String yesText;
    private static String yesAllText;
    private static String noText;
    private static String noAllText;
    public static final int YES_ALL = 16;
    public static final int NO_ALL = 32;
    private BImage icon = QUESTION_ICON;
    private RectGeom iconRect = new RectGeom();
    private RectGeom contentRect = new RectGeom();
    private RectGeom buttonsRect = new RectGeom();
    private Size buttonDim = new Size();
    private int result = 4;
    private static final long MAX_FILE_SIZE_CRC = 0x2000000L;

    public BButton getYesButton() {
        return (BButton)this.get(yesButton);
    }

    public void setYesButton(BButton v) {
        this.set(yesButton, (BValue)v, null);
    }

    public BButton getYesAllButton() {
        return (BButton)this.get(yesAllButton);
    }

    public void setYesAllButton(BButton v) {
        this.set(yesAllButton, (BValue)v, null);
    }

    public BButton getNoButton() {
        return (BButton)this.get(noButton);
    }

    public void setNoButton(BButton v) {
        this.set(noButton, (BValue)v, null);
    }

    public BButton getNoAllButton() {
        return (BButton)this.get(noAllButton);
    }

    public void setNoAllButton(BButton v) {
        this.set(noAllButton, (BValue)v, null);
    }

    public BButton getCancelButton() {
        return (BButton)this.get(cancelButton);
    }

    public void setCancelButton(BButton v) {
        this.set(cancelButton, (BValue)v, null);
    }

    public void buttonPressed(BWidgetEvent event) {
        this.invoke(buttonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReplaceDialog() {
        throw new UnsupportedOperationException();
    }

    public BReplaceDialog(BWidget owner) {
        super(owner, TYPE.getModule().getLexicon().getText("ReplaceDialog.title"), true);
        this.linkTo("linkA", (BComponent)this.getCancelButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkB", (BComponent)this.getYesButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkC", (BComponent)this.getYesAllButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkD", (BComponent)this.getNoButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkE", (BComponent)this.getNoAllButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        BReplaceDialog.initButtonText();
        this.getYesButton().setText(yesText);
        this.getYesAllButton().setText(yesAllText);
        this.getNoButton().setText(noText);
        this.getNoAllButton().setText(noAllText);
        this.getCancelButton().setText(cancelText);
        this.setDefaultButton(this.getYesButton());
        this.setContent((BWidget)new BNullWidget());
    }

    public int promptResult(BIFile currentFile, BIFile newFile) {
        Object[] args;
        String labelText;
        if (this.getResult() == 16) {
            return 4;
        }
        if (this.getResult() == 32) {
            return 8;
        }
        if (currentFile.isDirectory()) {
            labelText = newFile.isDirectory() ? this.getLexicon().getText("ReplaceDialog.message.replaceDirWithDir", new Object[]{currentFile.getFileName()}) : this.getLexicon().getText("ReplaceDialog.message.replaceFileWithDir", new Object[]{currentFile.getFileName()});
        } else if (newFile.isDirectory()) {
            labelText = this.getLexicon().getText("ReplaceDialog.message.replaceDirWithFile", new Object[]{currentFile.getFileName()});
        } else if (BReplaceDialog.tooLargeForCRC(currentFile) || BReplaceDialog.tooLargeForCRC(newFile)) {
            args = new Object[]{currentFile.getFileName(), new Long(currentFile.getSize()), new Long(newFile.getSize())};
            labelText = this.getLexicon().getText("ReplaceDialog.message.replaceFileWithFileNoCRC", args);
        } else {
            args = new Object[]{currentFile.getFileName(), new Long(currentFile.getSize()), Long.toHexString(DaemonFileUtil.getCrc((BIFile)currentFile)), new Long(newFile.getSize()), Long.toHexString(DaemonFileUtil.getCrc((BIFile)newFile))};
            labelText = this.getLexicon().getText("ReplaceDialog.message.replaceFileWithFile", args);
        }
        BLabel label = new BLabel(labelText);
        label.setHalign(BHalign.left);
        this.setContent((BWidget)label);
        this.setBoundsCenteredOnOwner();
        this.open();
        if (this.getResult() == 16) {
            return 4;
        }
        if (this.getResult() == 32) {
            return 8;
        }
        return this.getResult();
    }

    static void initButtonText() {
        if (cancelText != null) {
            return;
        }
        cancelText = TYPE.getModule().getLexicon().getText("ReplaceDialog.cancel");
        yesText = TYPE.getModule().getLexicon().getText("ReplaceDialog.yes");
        yesAllText = TYPE.getModule().getLexicon().getText("ReplaceDialog.yesAll");
        noText = TYPE.getModule().getLexicon().getText("ReplaceDialog.no");
        noAllText = TYPE.getModule().getLexicon().getText("ReplaceDialog.noAll");
    }

    public void computePreferredSize() {
        this.computeIconPrefSize();
        this.computeContentPrefSize();
        this.computeButtonsPrefSize();
        double iw = this.iconRect.width;
        double ih = this.iconRect.height;
        double cw = this.contentRect.width;
        double ch = this.contentRect.height;
        double bw = this.buttonsRect.width;
        double bh = this.buttonsRect.height;
        double w = Math.max(iw + cw, bw);
        double h = Math.max(ih, ch) + bh;
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        double w = this.getWidth();
        double h = this.getHeight();
        this.layoutButtons(w, h);
        this.layoutContentAndIcon(w, h);
    }

    private void computeIconPrefSize() {
        this.iconRect.width = this.icon.getWidth() + 8.0;
        this.iconRect.height = this.icon.getHeight() + 8.0;
    }

    private void computeContentPrefSize() {
        BWidget c = this.getContent();
        c.computePreferredSize();
        this.contentRect.width = c.getPreferredWidth() + 12.0;
        this.contentRect.height = c.getPreferredHeight() + 8.0;
        BSize size = LayoutUtil.getPreferredSizeForDialogContent((BWidget)this.getContent());
        this.contentRect.width = size.width();
        this.contentRect.height = size.height();
    }

    private void computeButtonsPrefSize() {
        double bh = 0.0;
        double bw = 0.0;
        int count = 0;
        BButton b = this.getYesButton();
        b.computePreferredSize();
        bw = Math.max(bw, b.getPreferredWidth());
        bh = Math.max(bh, b.getPreferredHeight());
        ++count;
        b = this.getYesAllButton();
        b.computePreferredSize();
        bw = Math.max(bw, b.getPreferredWidth());
        bh = Math.max(bh, b.getPreferredHeight());
        ++count;
        b = this.getNoButton();
        b.computePreferredSize();
        bw = Math.max(bw, b.getPreferredWidth());
        bh = Math.max(bh, b.getPreferredHeight());
        ++count;
        b = this.getNoAllButton();
        b.computePreferredSize();
        bw = Math.max(bw, b.getPreferredWidth());
        bh = Math.max(bh, b.getPreferredHeight());
        ++count;
        b = this.getCancelButton();
        b.computePreferredSize();
        bw = Math.max(bw, b.getPreferredWidth());
        bh = Math.max(bh, b.getPreferredHeight());
        this.buttonDim.width = bw;
        this.buttonDim.height = bh;
        this.buttonsRect.width = bw * (double)(++count) + (double)(4 * (count - 1)) + 8.0;
        this.buttonsRect.height = bh + 8.0;
    }

    private void layoutButtons(double w, double h) {
        double bx = this.buttonsRect.x = (w - this.buttonsRect.width) / 2.0 + 4.0;
        double by = this.buttonsRect.y = h - this.buttonDim.height - 4.0;
        double bw = this.buttonDim.width;
        double bh = this.buttonDim.height;
        this.getYesButton().setBounds(bx, by, bw, bh);
        this.getYesAllButton().setBounds(bx += bw + 4.0, by, bw, bh);
        this.getNoButton().setBounds(bx += bw + 4.0, by, bw, bh);
        this.getNoAllButton().setBounds(bx += bw + 4.0, by, bw, bh);
        this.getCancelButton().setBounds(bx += bw + 4.0, by, bw, bh);
        bx += bw + 4.0;
    }

    private void layoutContentAndIcon(double w, double h) {
        double aw;
        double ah = this.buttonsRect.y - 8.0;
        this.iconRect.x = 4.0;
        this.iconRect.y = (ah - this.iconRect.height) / 2.0 + 4.0;
        double cx = this.iconRect.x + this.iconRect.width + 4.0;
        double cy = 4.0;
        double cw = aw = w - cx - 4.0;
        double ch = ah;
        this.contentRect.x = cx;
        this.contentRect.y = cy;
        this.contentRect.width = cw;
        this.contentRect.height = ch;
        this.getContent().setBounds(cx, cy, cw, ch);
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
        g.drawImage(this.icon, this.iconRect.x, this.iconRect.y);
    }

    public int getResult() {
        return this.result;
    }

    public void close(int result) {
        this.result = result;
        this.close();
    }

    public void doButtonPressed(BWidgetEvent event) {
        BWidget src = event.getWidget();
        if (src == this.getCancelButton()) {
            this.close(2);
        }
        if (src == this.getYesButton()) {
            this.close(4);
        }
        if (src == this.getYesAllButton()) {
            this.close(16);
        }
        if (src == this.getNoButton()) {
            this.close(8);
        }
        if (src == this.getNoAllButton()) {
            this.close(32);
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.result = 2;
        this.close();
    }

    public static boolean tooLargeForCRC(BIFile file) {
        return file.getSize() > 0x2000000L;
    }
}

