/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BRemoteModuleList;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.stationtransfer.BStationTransferGridPane;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platDaemon.ui.stationtransfer.StationWizardModel;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.net.ConnectException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraSlots(actions={@NiagaraAction(name="handleSelectionChanged", parameterType="bajaui:WidgetEvent", defaultValue="new BWidgetEvent()", flags=4), @NiagaraAction(name="handleStationDirectoryChanged", flags=4)})
public class BStationCopier
extends BDaemonSessionView {
    public static final Action handleSelectionChanged = BStationCopier.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Action handleStationDirectoryChanged = BStationCopier.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BStationCopier.class);
    private static final long LARGE_BOG_FILE_MB = 2L;
    private static final long LARGE_BOG_FILE_BYTES = 0x200000L;
    private BList localList;
    private BList remoteList;
    private final StationListModel localStations = new StationListModel();
    private final StationListModel remoteStations;
    private BLabel remoteLabel;
    private WizardCommand installRemoteCommand;
    private WizardCommand installLocalCommand;
    private DeleteCommand deleteCommand;
    private RenameCommand renameCommand;
    private boolean sourceTargetDirsSame = true;
    private boolean processSelectionEvents = true;
    private BDirectory localStationsRoot = this.loadLocalStationDirectory();
    private BDirectory remoteStationsRoot;
    private BDirectoryChoice dirChoice;
    private BTextField remotePath;

    public void handleSelectionChanged(BWidgetEvent param) {
        this.invoke(handleSelectionChanged, (BValue)param, null);
    }

    public void handleStationDirectoryChanged() {
        this.invoke(handleStationDirectoryChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BStationCopier() {
        try {
            this.localStations.loadValue(this.localStationsRoot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remoteStations = new StationListModel();
        BStationTransferGridPane grid = new BStationTransferGridPane();
        BFlowPane flow = new BFlowPane(BHalign.left);
        grid.setTopLeft((BWidget)flow);
        BLabel localLabel = new BLabel();
        flow.add(null, (BValue)new BBorderPane((BWidget)localLabel, 5.0, 5.0, 5.0, 5.0));
        flow = new BFlowPane(BHalign.left);
        grid.setTopRight((BWidget)flow);
        this.remoteLabel = new BLabel();
        flow.add(null, (BValue)new BBorderPane((BWidget)this.remoteLabel, 5.0, 5.0, 5.0, 5.0));
        this.dirChoice = new BDirectoryChoice(this.localStationsRoot);
        grid.setCenterLeft((BWidget)this.dirChoice);
        this.linkTo((BComponent)this.dirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleStationDirectoryChanged);
        this.remotePath = new BTextField("", 35, false);
        grid.setCenterRight((BWidget)this.remotePath);
        this.localList = new BList((ListModel)this.localStations);
        grid.setBottomLeft((BWidget)new BBorderPane((BWidget)this.localList, BBorder.none, BInsets.DEFAULT));
        this.localList.setMultipleSelection(false);
        this.linkTo((BComponent)this.localList, (Slot)BList.selectionModified, (Slot)handleSelectionChanged);
        BGridPane buttons = new BGridPane(1);
        buttons.setColumnAlign(BHalign.fill);
        AsyncGroup cg = new AsyncGroup();
        this.installLocalCommand = new WizardCommand("StationCopier.installLocal");
        buttons.add(null, (BValue)new BButton((Command)this.installLocalCommand));
        cg.add((AsyncGroup.AsyncGroupMember)this.installLocalCommand);
        this.installRemoteCommand = new WizardCommand("StationCopier.installRemote");
        buttons.add(null, (BValue)new BButton((Command)this.installRemoteCommand));
        cg.add((AsyncGroup.AsyncGroupMember)this.installRemoteCommand);
        this.renameCommand = new RenameCommand();
        buttons.add(null, (BValue)new BButton((Command)this.renameCommand));
        cg.add((AsyncGroup.AsyncGroupMember)this.renameCommand);
        this.deleteCommand = new DeleteCommand();
        buttons.add(null, (BValue)new BButton((Command)this.deleteCommand));
        cg.add((AsyncGroup.AsyncGroupMember)this.deleteCommand);
        this.installLocalCommand.setEnabled(false);
        this.installRemoteCommand.setEnabled(false);
        this.renameCommand.setEnabled(false);
        this.deleteCommand.setEnabled(false);
        grid.setBottomCenter((BWidget)buttons);
        this.remoteList = new BList((ListModel)this.remoteStations);
        grid.setBottomRight((BWidget)new BBorderPane((BWidget)this.remoteList, BBorder.none, BInsets.DEFAULT));
        this.remoteList.setMultipleSelection(false);
        this.linkTo((BComponent)this.remoteList, (Slot)BList.selectionModified, (Slot)handleSelectionChanged);
        localLabel.setText(this.getLexicon().getText("StationCopier.localStations.heading"));
        localLabel.setImage(BImage.make((BIcon)BLocalHost.INSTANCE.getIcon()));
        BScrollPane scroll = new BScrollPane((BWidget)grid);
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)scroll));
    }

    public void doHandleStationDirectoryChanged() throws Exception {
        this.localStationsRoot = this.dirChoice.getDirectory();
        this.localStations.loadValue(this.localStationsRoot);
        this.checkSourceTargetDirsSame();
    }

    protected BDirectory loadLocalStationDirectory() {
        try {
            return BFileSystem.INSTANCE.makeDir(SystemFilePaths.getStationsDirPath((boolean)true), null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new BajaRuntimeException(t);
        }
    }

    @Override
    protected final void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        DaemonSessionTask loadingTask = new DaemonSessionTask(this.getLexicon(), "StationCopier.loading.title", "StationCopier.loading.message");
        this.taskStarted(loadingTask);
        try {
            ViewQuery vq;
            String stationName;
            this.remoteLabel.setText(this.getLexicon().getText("StationCopier.remoteStations.heading", new Object[]{session.getRemoteAddressString()}));
            this.remoteLabel.setImage(BImage.make((BIcon)session.getIcon()));
            FilePath stationsDirectoryPath = SystemFilePaths.getStationsDirPath((BIFileSpace)session.getFileSpace());
            FileHeaderInfo info = DaemonFileUtil.getFileHeaderInfo((BDaemonSession)this.getDaemonSession(), (FileHeaderMessage)new FileHeaderMessage(stationsDirectoryPath, (BDaemonFileSpace)session.getFileSpace(), false));
            if (info == null) {
                DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)SystemFilePaths.getStationsDirPath((BIFileSpace)session.getFileSpace()), (BDaemonFileSpace)session.getFileSpace()), null, null);
            }
            this.remoteStationsRoot = (BDirectory)session.getFileSpace().findFile(SystemFilePaths.getStationsDirPath((BIFileSpace)session.getFileSpace()), BCacheAccessPolicy.forceFetch);
            this.remotePath.setText(DaemonFileUtil.getNormalizedFilePath((BIFileStore)this.remoteStationsRoot.getStore()).getBody());
            this.checkSourceTargetDirsSame();
            this.remoteStations.loadValue(this.remoteStationsRoot);
            BNiagaraWbShell shell = (BNiagaraWbShell)BWbShell.getWbShell((BWidget)this);
            assert (shell != null);
            OrdQuery[] q = shell.getActiveOrd().parse();
            if (q[q.length - 1] instanceof ViewQuery && (stationName = (vq = (ViewQuery)q[q.length - 1]).getParameter("transferRemote", null)) != null) {
                this.taskFinished(loadingTask);
                this.removeViewQueryParamsFromActiveOrd("transferRemote");
                this.copySpecifiedLocalStation(stationName);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            this.taskFinished(loadingTask);
        }
    }

    private void removeViewQueryParamsFromActiveOrd(String ... paramNamesToRemove) {
        BNiagaraWbShell shell = (BNiagaraWbShell)BWbShell.getWbShell((BWidget)this);
        assert (shell != null);
        OrdQuery[] q = shell.getActiveOrd().parse();
        if (q[q.length - 1] instanceof ViewQuery) {
            ViewQuery vq = (ViewQuery)q[q.length - 1];
            HashSet paramSet = new HashSet();
            Collections.addAll(paramSet, paramNamesToRemove);
            boolean trimmed = false;
            boolean firstVqParm = true;
            StringBuilder vqUpdated = new StringBuilder();
            vqUpdated.append(vq.getViewId());
            for (String vqParmName : vq.getParameterNames()) {
                if (paramSet.contains(vqParmName)) {
                    trimmed = true;
                    continue;
                }
                if (firstVqParm) {
                    firstVqParm = false;
                    vqUpdated.append("?");
                }
                vqUpdated.append(vqParmName).append("=").append(vq.getParameter(vqParmName));
            }
            if (trimmed) {
                q[q.length - 1] = new ViewQuery(vq.getScheme(), vqUpdated.toString());
                shell.tab().updateOrd(BOrd.make((OrdQuery[])q));
            }
        }
    }

    private void checkSourceTargetDirsSame() throws ConnectException, AuthenticationException {
        boolean bl = this.sourceTargetDirsSame = this.getDaemonSession().usesLocalNiagaraUserHome() && this.remotePath.getText().equalsIgnoreCase(this.localStationsRoot.getFilePath().getBody());
        if (this.sourceTargetDirsSame) {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(false);
        }
    }

    public void doHandleSelectionChanged(BWidgetEvent evt) {
        if (!this.processSelectionEvents) {
            return;
        }
        this.processSelectionEvents = false;
        if (evt.getWidget() == this.localList && this.localList.getSelectedIndex() >= 0) {
            this.remoteList.getSelection().deselectAll();
        } else if (evt.getWidget() == this.remoteList && this.remoteList.getSelectedIndex() >= 0) {
            this.localList.getSelection().deselectAll();
        }
        if (this.localList.getSelectedIndex() >= 0) {
            this.installLocalCommand.setEnabled(!this.sourceTargetDirsSame);
            this.installRemoteCommand.setEnabled(false);
            this.deleteCommand.setEnabled(true);
            this.renameCommand.setEnabled(true);
        } else if (this.remoteList.getSelectedIndex() >= 0) {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(!this.sourceTargetDirsSame);
            this.deleteCommand.setEnabled(true);
            this.renameCommand.setEnabled(true);
        } else {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(false);
            this.deleteCommand.setEnabled(false);
            this.renameCommand.setEnabled(false);
        }
        this.processSelectionEvents = true;
    }

    private void copySpecifiedLocalStation(String stationName) {
        try {
            BDaemonSession session;
            BDaemonSessionView.stopAllRefreshTimers(this.getWbShell(), this.getDaemonSession().getHost());
            if (!StationWizardModel.open((BDirectory)this.localStationsRoot.getNavChild(stationName), this.remoteStationsRoot, (BRemoteModuleList)this.getDaemonPlatform().getModuleList(), this, true) && (session = ((BDaemonFileSpace)this.remoteStationsRoot.getFileSpace()).getDaemonSession()) != null && session.isConnected()) {
                this.remoteStations.loadValue(this.remoteStationsRoot);
            }
        }
        catch (Exception e) {
            CommandUtil.error((Command)this.installRemoteCommand, (Throwable)e);
        }
        finally {
            BDaemonSessionView.startAllRefreshTimers(this.getWbShell(), this.getDaemonSession().getHost());
        }
    }

    private class StationListModel
    extends ListModel {
        private final Array<BIFile> list = new Array(BIFile.class);

        public void loadValue(BDirectory directory) {
            this.list.clear();
            if (directory != null) {
                try {
                    if (directory.getStore() instanceof BDaemonDirectoryStore) {
                        ((BDaemonDirectoryStore)directory.getStore()).reset();
                    }
                    for (BIFile kid : directory.listFiles()) {
                        if (!kid.isDirectory()) continue;
                        BIDirectory kidDirectory = (BIDirectory)kid;
                        for (BIFile kidFile : kidDirectory.listFiles()) {
                            if (!kidFile.getFileName().equals("config.bog")) continue;
                            this.list.add((Object)kid);
                        }
                    }
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.SEVERE, "error loading station list", e);
                }
            }
            this.updateList();
        }

        public int getItemCount() {
            return this.list.size();
        }

        public Object getItem(int row) {
            return this.getDirectoryAt(row).getFileName();
        }

        public BDirectory getDirectoryAt(int row) {
            return (BDirectory)this.list.get(row);
        }

        public BImage getItemIcon(int index) {
            return null;
        }
    }

    private class DeleteCommand
    extends AsyncCommand {
        public DeleteCommand() {
            super((BWidget)BStationCopier.this, TYPE.getModule(), "StationCopier.delete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block12: {
                try {
                    BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)true);
                    if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                        if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.message", new Object[]{BStationCopier.this.localStations.getItem(BStationCopier.this.localList.getSelectedIndex())}))) break block12;
                        try {
                            AccessController.doPrivileged(() -> {
                                BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex()).delete();
                                return null;
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            throw pae.getException();
                        }
                        BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                        BStationCopier.this.localList.getSelection().deselectAll();
                        break block12;
                    }
                    if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.message", new Object[]{BStationCopier.this.remoteStations.getItem(BStationCopier.this.remoteList.getSelectedIndex())}))) break block12;
                    BStationCopier.this.processSelectionEvents = false;
                    BDirectory dir = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                    String dirName = dir.getFileName();
                    try {
                        BStationSurrogate station = BStationCopier.this.getStationSurrogate(dirName, true);
                        if (station != null) {
                            station.deleteStation(null, (DaemonSessionTaskListener)BStationCopier.this);
                        } else {
                            BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)new DeleteStationMessage(dirName));
                            DaemonFileUtil.transfer((BDaemonSession)BStationCopier.this.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)dir.getFilePath(), (BDaemonFileSpace)BStationCopier.this.getDaemonSession().getFileSpace()), null, (DaemonSessionTaskListener)BStationCopier.this);
                        }
                        BStationCopier.this.resetAppSurrogates();
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                        BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                    }
                    catch (ICancelHint.CanceledException canceledException) {
                        // empty catch block
                    }
                    BStationCopier.this.processSelectionEvents = true;
                    BStationCopier.this.remoteList.getSelection().deselectAll();
                }
                catch (Throwable t) {
                    CommandUtil.error((Command)this, (Throwable)t);
                }
                finally {
                    BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)false);
                }
            }
        }
    }

    private class RenameCommand
    extends AsyncCommand {
        public RenameCommand() {
            super((BWidget)BStationCopier.this, TYPE.getModule(), "StationCopier.rename");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doInvokeAsync() {
            try {
                BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)true);
                String newName = BStringPromptDialog.getString((BWidget)BStationCopier.this, (BImage)BImage.make((String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgIcon")), (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgTitle"), (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgMessage"), (TextController)new StationNameController());
                if (newName == null) {
                    return;
                }
                if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                    BDirectory dir = BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex());
                    if (newName.equalsIgnoreCase(dir.getFileName())) {
                        return;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= BStationCopier.this.localStations.getItemCount()) {
                            BFileSystem.INSTANCE.move(dir.getFilePath(), dir.getFilePath().getParent().merge(newName), null);
                            BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                            BStationCopier.this.localList.getSelection().deselectAll();
                            return;
                        }
                        if (i != BStationCopier.this.localList.getSelectedIndex() && newName.equalsIgnoreCase(BStationCopier.this.localStations.getDirectoryAt(i).getFileName())) {
                            throw new Exception(BStationCopier.this.getLexicon().getText("StationCopier.rename.duplicateErrorDetails"));
                        }
                        ++i;
                    }
                }
                BDirectory dir = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                if (newName.equalsIgnoreCase(dir.getFileName())) {
                    return;
                }
                for (int i = 0; i < BStationCopier.this.remoteStations.getItemCount(); ++i) {
                    if (i == BStationCopier.this.remoteList.getSelectedIndex() || !newName.equalsIgnoreCase(BStationCopier.this.remoteStations.getDirectoryAt(i).getFileName())) continue;
                    throw new Exception(BStationCopier.this.getLexicon().getText("StationCopier.rename.duplicateErrorDetails"));
                }
                BStationSurrogate station = BStationCopier.this.getStationSurrogate(dir.getFileName(), true);
                boolean running = station.isStationRunning();
                boolean mustReboot = false;
                if (running) {
                    if (station.isRestartEnabled()) {
                        if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.stopTitle"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.rename.stopMessage"))) {
                            return;
                        }
                    } else {
                        if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.promptRebootTitle"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.rename.promptRebootMessage"))) {
                            return;
                        }
                        mustReboot = true;
                    }
                    station.stopStation((ICancelHint)BStationCopier.this, (DaemonSessionTaskListener)BStationCopier.this);
                }
                UpdateStationMessage updateMsg = new UpdateStationMessage(newName, false, station.getIsAutoStart(), station.getIsAutoRestart(), true);
                DeleteStationMessage deleteMsg = new DeleteStationMessage(station.getStationName());
                DaemonFileUtil.transfer((BDaemonSession)BStationCopier.this.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeRename((FilePath)SystemFilePaths.getStationsDirPath((BIFileSpace)BStationCopier.this.getDaemonSession().getFileSpace()).merge(station.getStationName()), (String)newName, (BDaemonFileSpace)BStationCopier.this.getDaemonSession().getFileSpace()), null, (DaemonSessionTaskListener)BStationCopier.this);
                BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)deleteMsg);
                BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateStationMessage());
                BStationCopier.this.resetAppSurrogates();
                BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)updateMsg);
                if (mustReboot) {
                    BWbShell shell = BWbShell.getWbShell((BWidget)BStationCopier.this);
                    BStationCopier.this.getDaemonSession().sendRebootRequest();
                    BDialog.message((BWidget)shell, (String)BStationCopier.this.getLexicon().getText("DaemonSessionView.reboot.notifyTitle", new Object[]{BStationCopier.this.getDaemonSession().getRemoteAddressString()}), (Object)BStationCopier.this.getLexicon().getText("DaemonSessionView.reboot.notifyMessage", new Object[]{BStationCopier.this.getDaemonSession().getRemoteAddressString()}));
                    return;
                }
                try {
                    if (running) {
                        station = BStationCopier.this.getStationSurrogate(newName, true);
                        station.startStation((ICancelHint)BStationCopier.this, (DaemonSessionTaskListener)BStationCopier.this);
                    }
                    BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                }
                catch (Throwable t) {
                    try {
                        CommandUtil.error((Command)this, (Throwable)t);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                        BStationCopier.this.remoteList.getSelection().deselectAll();
                    }
                }
                BStationCopier.this.remoteList.getSelection().deselectAll();
                return;
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
                return;
            }
            finally {
                BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)false);
            }
        }
    }

    private class WizardCommand
    extends AsyncCommand {
        public WizardCommand(String pLexKey) {
            super((BWidget)BStationCopier.this, TYPE.getModule(), pLexKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            try {
                BDaemonSession session;
                BDirectory targetStationsRoot;
                BINavNode configBogNode;
                BDirectory dirToInstall;
                BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)true);
                BDaemonSessionView.stopAllRefreshTimers(BStationCopier.this.getWbShell(), BStationCopier.this.getDaemonSession().getHost());
                if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                    dirToInstall = BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex());
                    configBogNode = dirToInstall.getNavChild("config.bog");
                    if (configBogNode == null) {
                        BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.message"));
                        return;
                    }
                    Version bogVersion = ((BBogFile)configBogNode).getBogVersion();
                    if (BStationCopier.this.getDaemonPlatform().getIsNiagara4() != bogVersion.compareTo(ValueDocEncoder.BOG_VERSION_4) >= 0) {
                        if (BStationCopier.this.getDaemonPlatform().getIsNiagara4()) {
                            BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.axBog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.axBog.message"));
                        } else {
                            BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.n4Bog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.n4Bog.message"));
                        }
                        return;
                    }
                    targetStationsRoot = BStationCopier.this.remoteStationsRoot;
                } else {
                    dirToInstall = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                    configBogNode = dirToInstall.getNavChild("config.bog");
                    if (configBogNode == null) {
                        BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.message"));
                        return;
                    }
                    boolean anyStationRunning = false;
                    BAppSurrogate[] surrogates = BStationCopier.this.getAppSurrogates();
                    if (surrogates != null) {
                        for (int i = 0; i < surrogates.length; ++i) {
                            if (!surrogates[i].isAppRunning()) continue;
                            anyStationRunning = true;
                            break;
                        }
                    }
                    if (((BBogFile)configBogNode).getSize() > 0x200000L && anyStationRunning && 8 == BDialog.open((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.largeBogFile.dlgTitle"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.largeBogFile.dlgMessage", new Object[]{String.valueOf(2L)}), (int)12, (BImage)BDialog.WARNING_ICON)) {
                        return;
                    }
                    targetStationsRoot = BStationCopier.this.localStationsRoot;
                }
                if (!StationWizardModel.open(dirToInstall, targetStationsRoot, (BRemoteModuleList)BStationCopier.this.getDaemonPlatform().getModuleList(), BStationCopier.this) && (session = ((BDaemonFileSpace)BStationCopier.this.remoteStationsRoot.getFileSpace()).getDaemonSession()) != null && session.isConnected()) {
                    if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                    } else {
                        BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                    }
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            finally {
                BStationSurrogate.setStationDirectoryWatchPauseState((BDaemonSession)BStationCopier.this.getDaemonSession(), (boolean)false);
                BDaemonSessionView.startAllRefreshTimers(BStationCopier.this.getWbShell(), BStationCopier.this.getDaemonSession().getHost());
            }
        }
    }
}

