/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.TreeSet;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

class UninstallCommand
extends AsyncCommand {
    private InstallerTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public UninstallCommand(BWidget owner, InstallerTableModel tableModel) {
        super(owner, lex, "SoftwareManager.command.uninstallSelected");
        this.tableModel = tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
        try {
            if (shell != null) {
                shell.enterBusy();
            }
            int[] rows = this.tableModel.getTable().getSelection().getRows();
            String[] toUninstall = new String[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                toUninstall[i] = this.tableModel.getNameAt(rows[i]);
            }
            InstallScenario solution = this.tableModel.getScenario().solve(null, toUninstall, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            if (solution.getUnmetDependencies().length == 0) {
                this.tableModel.setScenario(solution);
            } else {
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("UninstallCommand.broken.title"), (Object)this.makeBrokenDepsDialog(solution));
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    private BWidget makeBrokenDepsDialog(InstallScenario solution) {
        BIndentPane pane = new BIndentPane();
        TreeSet<PartSpec> specs = new TreeSet<PartSpec>();
        for (int i = 0; i < solution.getUnmetDependencies().length; ++i) {
            specs.add(solution.getUnmetDependencies()[i].getPartSpec());
        }
        LexiconText itemText = LexiconText.make((String)"platDaemon", (String)"UninstallCommand.broken.itemHeading");
        for (PartSpec spec : specs) {
            pane.add(itemText, new Object[]{spec.getPartName()});
            pane.indent();
            for (InstallerTableRow depRow : this.tableModel.getReverseDependenciesAt(this.tableModel.indexOf(spec))) {
                switch (depRow.getInstallStatus().getOrdinal()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        pane.add(depRow.getPartName());
                    }
                }
            }
            pane.unindent();
        }
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(320.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)cpane);
    }
}

