/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.PemSource;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BCodeSigner;
import com.tridium.install.part.BModulePart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.security.CodeSigner;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;

@NiagaraType
@NiagaraAction(name="viewCertificate", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BSignatureDetailsPane
extends BBorderPane {
    public static final Action viewCertificate = BSignatureDetailsPane.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BSignatureDetailsPane.class);
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
    private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
    private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");
    private static final BImage UNKNOWN = BImage.make((String)"module://icons/x16/questionMark.png");
    private CertificateChainValidator certValidator;
    private ModuleVerificationMode verificationMode;
    private int targetWidth = 0;

    public void viewCertificate(BMouseEvent parameter) {
        this.invoke(viewCertificate, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSignatureDetailsPane(CertificateChainValidator certValidator, ModuleVerificationMode verificationMode, int targetWidth) {
        this.setBorder(BBorder.make((int)4));
        this.certValidator = certValidator;
        this.verificationMode = verificationMode;
        this.targetWidth = targetWidth;
    }

    public void loadValue(BModulePart module) {
        BLabel label;
        String details;
        List statuses = module.getSignatureStatus(this.certValidator);
        StringBuilder statusStringBuilder = new StringBuilder();
        boolean isError = false;
        for (ModuleSignatureStatusEnum status : statuses) {
            if (!status.isAcceptable(this.verificationMode)) {
                isError = true;
            }
            if (statusStringBuilder.length() != 0) {
                statusStringBuilder.append("\n");
            }
            statusStringBuilder.append(LEX.getText("signatureStatusEnum." + status.toString()));
        }
        BImage statusIcon = isError ? SECURITY_LOW : (statuses.contains(ModuleSignatureStatusEnum.OK) ? SECURITY_HIGH : (statuses.contains(ModuleSignatureStatusEnum.UNKNOWN) ? UNKNOWN : SECURITY_MEDIUM));
        ((BLabel)this.getLabel()).setImage(statusIcon);
        BLabel signerStatus = new BLabel(statusStringBuilder.toString());
        signerStatus.setHalign(BHalign.left);
        BGridPane statusPane = new BGridPane(2);
        LabelUtil.addLabelWidgetPair((BPane)statusPane, (String)LEX.getText("PartDetailsPane.status"), (BWidget)signerStatus);
        statusPane.setRowAlign(BValign.top);
        BIndentPane signatureDetails = new BIndentPane();
        signatureDetails.add((BWidget)statusPane);
        this.setContent((BWidget)signatureDetails);
        if (statuses.contains(ModuleSignatureStatusEnum.INVALID_SIGNATURE)) {
            details = LEX.getText("signatureStatus." + ModuleSignatureStatusEnum.INVALID_SIGNATURE + ".error.details");
            String failureCause = module.getSignatureFailureCause();
            if (!failureCause.isEmpty()) {
                details = details + "\n" + LEX.getText("PartDetailsPane.failureCause", new Object[]{failureCause});
            }
            label = new BLabel(SECURITY_LOW, details);
            label.setHalign(BHalign.left);
            label.setWordWrapEnabled(true, (double)(this.targetWidth - signatureDetails.getIndentWidth()));
            signatureDetails.indent();
            signatureDetails.add((BWidget)label);
            signatureDetails.unindent();
        } else if (statuses.contains(ModuleSignatureStatusEnum.UNSIGNED)) {
            BImage icon;
            String details2;
            if (ModuleSignatureStatusEnum.UNSIGNED.isAcceptable(this.verificationMode)) {
                details2 = LEX.getText("signatureStatus." + ModuleSignatureStatusEnum.UNSIGNED + ".warning.details");
                icon = SECURITY_MEDIUM;
            } else {
                details2 = LEX.getText("signatureStatus." + ModuleSignatureStatusEnum.UNSIGNED + ".error.details");
                icon = SECURITY_LOW;
            }
            label = new BLabel(icon, details2);
            label.setHalign(BHalign.left);
            label.setWordWrapEnabled(true, (double)(this.targetWidth - signatureDetails.getIndentWidth()));
            signatureDetails.indent();
            signatureDetails.add((BWidget)label);
            signatureDetails.unindent();
        } else if (statuses.contains(ModuleSignatureStatusEnum.UNKNOWN)) {
            details = LEX.getText("signatureStatus." + ModuleSignatureStatusEnum.UNKNOWN + ".warning.details");
            BLabel label2 = new BLabel(UNKNOWN, details);
            label2.setHalign(BHalign.left);
            label2.setWordWrapEnabled(true, (double)(this.targetWidth - signatureDetails.getIndentWidth()));
            signatureDetails.indent();
            signatureDetails.add((BWidget)label2);
            signatureDetails.unindent();
        }
        BVector signers = module.getCodeSigners();
        if (signers.getPropertiesArray().length > 0) {
            BLabel signersLabel = new BLabel(LEX.getText("PartDetailsPane.signers"));
            signersLabel.setHalign(BHalign.left);
            signersLabel.setFont(LabelUtil.BOLD_TEXT_FONT);
            signatureDetails.add((BWidget)signersLabel);
            signatureDetails.indent();
            SlotCursor c = signers.getProperties();
            while (c.next()) {
                CodeSigner signer = ((BCodeSigner)c.get()).getCodeSigner();
                List sorted = CertUtils.sortCertChain(signer.getSignerCertPath().getCertificates());
                X509Certificate cert = (X509Certificate)sorted.get(0);
                String subject = PemSource.extractFriendlyName((X500Name)JcaX500NameUtil.getSubject((X509Certificate)cert));
                BHyperlinkLabel viewCertificateLink = new BHyperlinkLabel();
                viewCertificateLink.add("certificate", (BValue)BX509Certificate.make((X509Certificate)cert));
                viewCertificateLink.setText(subject);
                BFont font = viewCertificateLink.getFont();
                font = font.isNull() ? BFont.make((BFont)Theme.label().getTextFont((IStylable)viewCertificateLink), (int)4) : BFont.make((BFont)font, (int)4);
                viewCertificateLink.setForeground(BBrush.makeSolid((BColor)BColor.blue));
                viewCertificateLink.setFont(font);
                this.linkTo((BComponent)viewCertificateLink, (Slot)BWidget.mouseEvent, (Slot)viewCertificate);
                signatureDetails.add((BWidget)viewCertificateLink);
                signatureDetails.indent();
                statuses = ModuleSignatureStatusEnum.getSignatureStatus((CodeSigner)signer, (CertificateChainValidator)this.certValidator);
                for (ModuleSignatureStatusEnum status : statuses) {
                    BImage icon;
                    String details3;
                    if (status == ModuleSignatureStatusEnum.OK) continue;
                    if (status.isAcceptable(this.verificationMode)) {
                        details3 = LEX.getText("signatureStatus." + status + ".warning.details");
                        icon = SECURITY_MEDIUM;
                    } else {
                        details3 = LEX.getText("signatureStatus." + status + ".error.details");
                        icon = SECURITY_LOW;
                    }
                    BLabel label3 = new BLabel(icon, details3);
                    label3.setHalign(BHalign.left);
                    label3.setWordWrapEnabled(true, (double)(this.targetWidth - signatureDetails.getIndentWidth() * 2));
                    signatureDetails.add((BWidget)label3);
                }
                signatureDetails.unindent();
            }
            signatureDetails.unindent();
        }
    }

    public void setLabel(String text) {
        this.setLabel((BWidget)new BLabel(text, Theme.widget().getBoldText()));
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
    }

    public void doViewCertificate(BMouseEvent event) throws Exception {
        BWidget widget;
        BValue value;
        if (event.getId() == 502 && (value = (widget = event.getWidget()).get("certificate")) instanceof BX509Certificate) {
            NX509Certificate certificate = NX509Certificate.make((X509Certificate)((BX509Certificate)value).getX509Certificate());
            BCertViewDialog.show((BWidget)this, (NX509Certificate)certificate);
        }
    }
}

