/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.HostNotFipsReadyItem;
import com.tridium.platDaemon.ui.licenseinstall.BCertList;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseList;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.license.UiUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.tools.BRequestLicenseTool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BLicenseManager
extends BDaemonSessionView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BLicenseManager.class);
    private BDaemonSession session = null;
    private BLabel hostNameLabel;
    private BLabel hostIDLabel;
    private BLabel brandLabel;
    private BCertList certs;
    private BLicenseList licenses;
    private CommandBindings.ListSelection licensesSelection;
    private CommandBindings.ListSelection certsSelection;
    private BButtonPane licenseButtons;
    private ImportLicenseCommand importLicenseCommand;
    private ExportLicenseCommand exportLicenseCommand;
    private Command viewLicenseCommand;
    private Command deleteLicenseCommand;
    private ChangeBrandLicenseCommand changeBrandLicenseCommand;
    private BTextField brandField;
    private BButtonPane certButtons;
    private AddCertCommand addCertCommand;
    private Command viewCertificateCommand;
    private Command deleteCertificateCommand;
    private static final String LICENSE_DB_FOLDER = "db";
    public static final Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final Logger logger = Logger.getLogger("platDaemon");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLicenseManager() {
        BIBeamPane contentPane = new BIBeamPane();
        BGridPane upperPane = new BGridPane(2);
        upperPane.setHalign(BHalign.left);
        upperPane.setValign(BValign.top);
        upperPane.setColumnGap(10.0);
        upperPane.setRowGap(6.0);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.hostNameLabel"), (boolean)true));
        this.hostNameLabel = new BLabel();
        upperPane.add(null, (BValue)this.hostNameLabel);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.hostIDLabel"), (boolean)true));
        this.hostIDLabel = new BLabel();
        upperPane.add(null, (BValue)this.hostIDLabel);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.brandLabel"), (boolean)true));
        this.brandLabel = new BLabel();
        upperPane.add(null, (BValue)this.brandLabel);
        contentPane.setTop((BWidget)new BBorderPane((BWidget)upperPane, 0.0, 0.0, 6.0, 0.0));
        this.licenses = new BLicenseList();
        this.importLicenseCommand = new ImportLicenseCommand(this.licenses);
        this.exportLicenseCommand = new ExportLicenseCommand(this.licenses);
        this.viewLicenseCommand = this.licenses.getViewCommand();
        this.deleteLicenseCommand = this.licenses.getDeleteCommand();
        this.changeBrandLicenseCommand = new ChangeBrandLicenseCommand(this.licenses);
        CommandBindings bindings = new CommandBindings();
        bindings.addCommand((Command)this.importLicenseCommand, BCommandEnablePolicy.always);
        bindings.addCommand((Command)this.exportLicenseCommand, BCommandEnablePolicy.anySelection);
        bindings.addCommand(this.viewLicenseCommand, BCommandEnablePolicy.singleSelection);
        bindings.addCommand(this.deleteLicenseCommand, BCommandEnablePolicy.anySelection);
        bindings.addCommand((Command)this.changeBrandLicenseCommand, BCommandEnablePolicy.always);
        bindings.setDoubleClickCommand(this.viewLicenseCommand);
        bindings.setSupport((CommandBindings.Support)this);
        this.licenses.setController((ListController)new FileListController(bindings));
        this.licensesSelection = new CommandBindings.ListSelection(bindings);
        this.licenses.setSelection((ListSelection)this.licensesSelection);
        this.licenses.setMultipleSelection(true);
        this.licenseButtons = new BButtonPane();
        this.licenseButtons.setUniformColumnWidth(false);
        this.licenseButtons.add((Command)this.importLicenseCommand);
        this.licenseButtons.add((Command)this.exportLicenseCommand);
        this.licenseButtons.add(this.viewLicenseCommand);
        this.licenseButtons.add(this.deleteLicenseCommand);
        BLabel label = new BLabel(this.getLexicon().getText("LicenseManager.licenseList.header"));
        contentPane.setLeft((BWidget)new BEdgePane((BWidget)label, (BWidget)this.licenseButtons, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.licenses, BBorder.none, BInsets.DEFAULT), 4.0, 0.0, 10.0, 0.0)));
        label.setHalign(BHalign.left);
        this.certs = new BCertList();
        this.addCertCommand = new AddCertCommand(this.certs);
        this.viewCertificateCommand = this.certs.getViewCommand();
        this.deleteCertificateCommand = this.certs.getDeleteCommand();
        bindings = new CommandBindings();
        bindings.addCommand((Command)this.addCertCommand, BCommandEnablePolicy.always);
        bindings.addCommand(this.viewCertificateCommand, BCommandEnablePolicy.singleSelection);
        bindings.addCommand(this.deleteCertificateCommand, BCommandEnablePolicy.anySelection);
        bindings.setDoubleClickCommand(this.certs.getViewCommand());
        bindings.setSupport((CommandBindings.Support)this);
        this.certs.setController((ListController)new FileListController(bindings));
        this.certsSelection = new CommandBindings.ListSelection(bindings);
        this.certs.setSelection((ListSelection)this.certsSelection);
        this.certs.setMultipleSelection(true);
        this.certButtons = new BButtonPane();
        this.certButtons.setUniformColumnWidth(false);
        this.certButtons.add((Command)this.addCertCommand);
        this.certButtons.add(this.viewCertificateCommand);
        this.certButtons.add(this.deleteCertificateCommand);
        label = new BLabel(this.getLexicon().getText("LicenseManager.certList.header"));
        contentPane.setRight((BWidget)new BEdgePane((BWidget)label, (BWidget)this.certButtons, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.certs, BBorder.none, BInsets.DEFAULT), 4.0, 0.0, 10.0, 0.0)));
        label.setHalign(BHalign.left);
        contentPane.setCenter((BWidget)new BBox(20.0, 0.0));
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)contentPane));
    }

    @Override
    protected final void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        this.session = session;
        this.certs.loadValue(session, this);
        this.licenses.loadValue(session, this);
        this.hostNameLabel.setText(session.getRemoteAddressString());
        this.hostIDLabel.setText(this.getHostId());
        this.brandLabel.setText(this.licenses.getBrandId() == null ? "" : this.licenses.getBrandId());
        this.licensesSelection.setCommandEnabledStates();
        this.certsSelection.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (this.session == null) {
            command.setEnabled(false);
        } else {
            boolean combinedEnabledState = false;
            combinedEnabledState = command == this.importLicenseCommand || command == this.deleteLicenseCommand || command == this.addCertCommand || command == this.deleteCertificateCommand ? bindingBasedState && !this.isLicenseReadonly() : (command == this.changeBrandLicenseCommand ? bindingBasedState && !this.isLicenseReadonly() && this.isBrandChangeAllowed() : bindingBasedState);
            command.setEnabled(combinedEnabledState);
        }
    }

    public String getHostId() {
        return this.session.getHostProperties().getHostId();
    }

    public Version getNreVersion() {
        String versionString = this.session.getHostProperties().getNrePartVersion();
        if (versionString.equals("")) {
            return this.session.getHostProperties().isNiagara4() ? new Version("4.0") : new Version("3.0");
        }
        if (versionString.endsWith(".???")) {
            versionString = versionString.substring(0, versionString.length() - 4);
        }
        return new Version(versionString);
    }

    public String getBrandId() {
        return this.licenses.getBrandId();
    }

    public boolean isLicenseReadonly() {
        return this.session.getHostProperties().getIsLicenseReadonly();
    }

    public boolean isBrandChangeAllowed() {
        return this.session.getHostProperties().getAllowBrandChange();
    }

    protected LicenseInfo[] getDatabaseLicenses() throws Exception {
        ArrayList<LicenseInfo> result = new ArrayList<LicenseInfo>();
        VendorLicense[] dbLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.getHostId());
        String b = this.getBrandId();
        for (VendorLicense dbLicense : dbLicenses) {
            if (dbLicense.getBrandId() != null && b != null && !b.equals(dbLicense.getBrandId())) continue;
            result.add(new LicenseInfo(dbLicense, null));
            b = dbLicense.getBrandId();
        }
        return result.toArray(new LicenseInfo[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sync(LicenseSync<LicenseInfo> licenseSync, LicenseSync<CertificateInfo> certSync) throws Exception {
        IFileInfo update;
        IFileInfo add;
        int i;
        int count;
        FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
        ArrayList allAdds = new ArrayList();
        ArrayList allUpdates = new ArrayList();
        ArrayList allRemoves = new ArrayList();
        ArrayList<LicenseInfo> fipsLicenses = new ArrayList<LicenseInfo>();
        boolean mustRestart = false;
        boolean anyUpdates = false;
        if (licenseSync != null) {
            count = licenseSync.toRemove.size();
            allRemoves.addAll(licenseSync.toRemove);
            for (i = 0; i < count; ++i) {
                IFileInfo remove = (IFileInfo)licenseSync.toRemove.get(i);
                message.addDelete(remove.getFile().getFilePath());
                anyUpdates = true;
            }
            count = licenseSync.toAdd.size();
            allAdds.addAll(licenseSync.toAdd);
            for (i = 0; i < count; ++i) {
                add = (IFileInfo)licenseSync.toAdd.get(i);
                if (this.hasFipsFeature(add)) {
                    fipsLicenses.add((LicenseInfo)add);
                }
                PortalLicenseUtil.addFile((FileTransferMessage)message, (IFileInfo)add);
                mustRestart = true;
                anyUpdates = true;
            }
            count = licenseSync.toUpdate.size();
            allUpdates.addAll(licenseSync.toUpdate);
            for (i = 0; i < count; ++i) {
                update = (IFileInfo)licenseSync.toUpdate.get(i);
                if (this.hasFipsFeature(update)) {
                    fipsLicenses.add((LicenseInfo)update);
                }
                PortalLicenseUtil.addFile((FileTransferMessage)message, (IFileInfo)update);
                mustRestart = true;
                anyUpdates = true;
            }
        }
        if (certSync != null) {
            count = certSync.toAdd.size();
            allAdds.addAll(certSync.toAdd);
            for (i = 0; i < count; ++i) {
                add = (IFileInfo)certSync.toAdd.get(i);
                PortalLicenseUtil.addFile((FileTransferMessage)message, (IFileInfo)add);
                anyUpdates = true;
            }
            count = certSync.toUpdate.size();
            allUpdates.addAll(certSync.toUpdate);
            for (i = 0; i < count; ++i) {
                update = (IFileInfo)certSync.toUpdate.get(i);
                PortalLicenseUtil.addFile((FileTransferMessage)message, (IFileInfo)update);
                anyUpdates = true;
            }
        }
        ArrayList<HostNotFipsReadyItem> errors = new ArrayList<HostNotFipsReadyItem>();
        if (!anyUpdates) {
            BDialog.message((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.currentTitle"), (Object)this.getLexicon().getText("LicenseManager.sync.currentMessage"));
            return;
        }
        if (!fipsLicenses.isEmpty()) {
            if (!FipsOptionsHelper.getInstance().isHostFipsReady(this.session, errors::add)) {
                BDialog.error((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.fipsNotReady.title"), (Object)this.buildFipsPane(fipsLicenses, errors));
                return;
            }
        }
        DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)message, null, (DaemonSessionTaskListener)this);
        String msg = this.getLexicon().getText("LicenseManager.sync.successMessage");
        if (mustRestart && this.areAppsRunning()) {
            String footer = this.session.getHostProperties().getAllowStationRestart() ? this.getLexicon().getText("LicenseManager.sync.promptRestart") : this.getLexicon().getText("LicenseManager.sync.promptReboot");
            BWidget content = UiUtil.buildUpdateDescription((String)msg, (String)footer, (IFileInfo[])allAdds.toArray(new IFileInfo[allAdds.size()]), (IFileInfo[])allUpdates.toArray(new IFileInfo[allUpdates.size()]), (IFileInfo[])allRemoves.toArray(new IFileInfo[allRemoves.size()]));
            if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.successTitle"), (Object)content, (int)12)) {
                if (this.session.getHostProperties().getAllowStationRestart()) {
                    BAppSurrogate[] apps;
                    for (BAppSurrogate app : apps = this.getAppSurrogates()) {
                        if (!app.isAppRunning()) continue;
                        app.restartAppAsync();
                    }
                } else {
                    this.session.sendRebootRequest();
                }
            }
        } else {
            BWidget content = UiUtil.buildUpdateDescription((String)msg, (IFileInfo[])allAdds.toArray(new IFileInfo[allAdds.size()]), (IFileInfo[])allUpdates.toArray(new IFileInfo[allUpdates.size()]), (IFileInfo[])allRemoves.toArray(new IFileInfo[allRemoves.size()]));
            BDialog.message((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.successTitle"), (Object)content);
        }
        this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
        BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
        this.certs.loadValue(this.session, this);
        this.licenses.loadValue(this.session, this);
        this.brandLabel.setText(this.licenses.getBrandId() == null ? "" : this.licenses.getBrandId());
    }

    private boolean hasFipsFeature(IFileInfo fileInfo) {
        if (fileInfo instanceof LicenseInfo) {
            return ((LicenseInfo)fileInfo).vendorLicense.getFeature("fips140-2") != null;
        }
        return false;
    }

    private BWidget buildFipsPane(List<LicenseInfo> licenseInfos, List<HostNotFipsReadyItem> notFipsReadyItems) {
        BIndentPane indentPane = new BIndentPane();
        indentPane.add(this.getLexicon().getText("LicenseManager.sync.fipsNotReady.details"));
        indentPane.add((BWidget)new BBox(0.0, 3.0));
        indentPane.add(this.getLexicon().getText("LicenseManager.sync.fipsNotReady.licenses"));
        indentPane.indent();
        for (LicenseInfo licenseInfo : licenseInfos) {
            indentPane.add(licenseInfo.getInstalledFileName());
        }
        indentPane.unindent();
        indentPane.add((BWidget)new BBox(0.0, 3.0));
        indentPane.add(this.getLexicon().getText("LicenseManager.sync.fipsNotReady.items"));
        indentPane.indent();
        for (HostNotFipsReadyItem notFipsReadyItem : notFipsReadyItems) {
            indentPane.add(notFipsReadyItem.getDescriptionWidget());
        }
        return new BBorderPane((BWidget)indentPane, 5.0, 5.0, 5.0, 5.0);
    }

    private boolean brandedLicenseExists(List<VendorLicense> licenses) {
        for (VendorLicense license : licenses) {
            if (license.getBrandId() == null || license.getBrandId().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private BRadioButton makeButton(ToggleCommandGroup<? super ToggleCommand> group, String text, boolean selected, final LicenseImport importFunction) {
        BRadioButton result = new BRadioButton(text, selected);
        ImportLicenseButtonCommand command = new ImportLicenseButtonCommand(result){

            @Override
            public void importLicense() throws Exception {
                importFunction.importLicense();
            }
        };
        result.setCommand((Command)command, false, false);
        group.add((ToggleCommand)command);
        return result;
    }

    public static class LicenseListModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return UiLexicon.bajaui().getText("fileChooser.name");
                }
                case 1: {
                    return lex.getText("LicenseManager.hostIDLabel");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BIFile file = (BIFile)this.kids[row];
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    try {
                        if (file.getExtension() == null || !file.getExtension().equals("license")) {
                            return "";
                        }
                        XElem licenseElem = XParser.make((InputStream)file.getInputStream()).parse(true);
                        return licenseElem.get("hostId", "");
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private class AddCertCommand
    extends AsyncCommand {
        public AddCertCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicenseManager.addCert");
        }

        public void doInvokeAsync() {
            block7: {
                try {
                    BIFile[] certfiles;
                    if (BLicenseManager.this.isLicenseReadonly()) {
                        throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyCertificates");
                    }
                    BIFile currentSelection = BFileSystem.INSTANCE.findFile(SystemFilePaths.getCertificatesDirPath((boolean)BLicenseManager.this.session.getHostProperties().isNiagara4()));
                    if (currentSelection == null) {
                        currentSelection = BFileSystem.INSTANCE.getSysHome();
                    }
                    if ((certfiles = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.message", new Object[]{BLicenseManager.this.session.getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)BCertList.filter, (IFileFilter)BCertList.filter)).length <= 0) break block7;
                    try {
                        ArrayList<CertificateInfo> toInstall = new ArrayList<CertificateInfo>();
                        for (BIFile certfile : certfiles) {
                            toInstall.add(new CertificateInfo(certfile));
                        }
                        CertificateInfo[] installedCerts = BLicenseManager.this.certs.getCertificates();
                        LicenseSync sync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installedCerts, (CertificateInfo[])toInstall.toArray(new CertificateInfo[toInstall.size()]));
                        BLicenseManager.this.sync(null, (LicenseSync<CertificateInfo>)sync);
                    }
                    catch (Exception e) {
                        throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addCertException", (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    CommandUtil.error((Command)this, (Throwable)t);
                }
            }
        }
    }

    private abstract class ImportLicenseButtonCommand
    extends ToggleCommand {
        public ImportLicenseButtonCommand(BRadioButton button) {
            super((BWidget)button, button.getText());
        }

        public abstract void importLicense() throws Exception;
    }

    private static interface LicenseImport {
        public void importLicense() throws Exception;
    }

    private class ChangeBrandLicenseCommand
    extends AsyncCommand {
        public ChangeBrandLicenseCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicenseManager.changeBrandLicense");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                if (BLicenseManager.this.isLicenseReadonly()) {
                    throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyLicenses");
                }
                if (!BLicenseManager.this.isBrandChangeAllowed()) {
                    throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyBrand");
                }
                BGridPane grid = new BGridPane(1);
                BEdgePane pane = new BEdgePane();
                pane.setTop((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandMessage")));
                BGridPane brandGrid = new BGridPane(1);
                BLicenseManager.this.brandField = new BTextField("", 40);
                BLicenseManager.this.brandField.setEnabled(true);
                brandGrid.add("brandField", (BValue)BLicenseManager.this.brandField);
                pane.setCenter((BWidget)brandGrid);
                grid.add(null, (BValue)pane);
                if (2 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    return;
                }
                if (BLicenseManager.this.session == null) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noPlatConnection")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                if (BLicenseManager.this.getBrandId() == null) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noExistingBrand")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                String newBrand = BLicenseManager.this.brandField.getText();
                if (newBrand.length() == 0 || BLicenseManager.this.getBrandId().equals(newBrand)) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.brandNotUnique")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                LicenseInfo[] existingLicenses = null;
                try {
                    existingLicenses = BLicenseManager.this.licenses.getLicenses();
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noDeviceLicense")), 10.0, 10.0, 10.0, 10.0), (Throwable)e);
                    return;
                }
                if (existingLicenses == null || existingLicenses.length == 0) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noDeviceLicense")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                boolean checkAgainstLocalLicenseDb = true;
                ArrayList<VendorLicense> brandedLicenses = new ArrayList<VendorLicense>();
                if (!PortalLicenseUtil.isApiAvailable()) {
                    BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noPortalApi")), 10.0, 10.0, 10.0, 10.0), (int)1);
                    return;
                }
                try {
                    List brandedModels = PortalLicenseUtil.getExistingLicenses((String)BLicenseManager.this.getHostId(), (String)newBrand, null);
                    block8: for (Object brandedModel : brandedModels) {
                        for (XElem licenseElem : brandedModel.getLicenseElements()) {
                            VendorLicense brandedLicense = VendorLicense.make((String)"portal", (XElem)licenseElem);
                            brandedLicense.load("portal", licenseElem);
                            LicenseDatabase.LOCAL_INSTANCE.add(brandedLicense);
                            String vendorLicenseBrand = brandedLicense.getBrandId();
                            if (vendorLicenseBrand == null || !vendorLicenseBrand.equals(newBrand)) continue;
                            brandedLicenses.add(brandedLicense);
                            checkAgainstLocalLicenseDb = false;
                            continue block8;
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, lex.getText("LicenseManager.changeBrandLicense.portalLicensesError"), e);
                }
                if (checkAgainstLocalLicenseDb) {
                    VendorLicense[] dbLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(BLicenseManager.this.getHostId(), newBrand);
                    Collections.addAll(brandedLicenses, dbLicenses);
                }
                if (brandedLicenses.isEmpty() || !BLicenseManager.this.brandedLicenseExists(brandedLicenses)) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.noLicenses", new Object[]{newBrand})), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                if (2 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandWarning")), 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    return;
                }
                ArrayList<LicenseInfo> toAdd = new ArrayList<LicenseInfo>();
                Feature.Brand brandFeature = null;
                for (VendorLicense license : brandedLicenses) {
                    brandFeature = license.getBrandFeature();
                    FilePath brandedLicenseFilePath = LicenseDatabase.LICENSES_DIR_PATH.merge(BLicenseManager.LICENSE_DB_FOLDER).merge(BLicenseManager.this.getHostId()).merge(license.getLicenseName() + ".license");
                    BIFile brandedLicenseFile = BFileSystem.INSTANCE.findFile(brandedLicenseFilePath);
                    toAdd.add(new LicenseInfo(license, brandedLicenseFile));
                }
                try {
                    LicenseSync sync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (Feature.Brand)brandFeature, (LicenseInfo[])existingLicenses, (LicenseInfo[])toAdd.toArray(new LicenseInfo[0]));
                    BLicenseManager.this.sync((LicenseSync<LicenseInfo>)sync, null);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicenseManager.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicenseManager.changeBrandLicense.licenseChangeFailed")), 10.0, 10.0, 10.0, 10.0), (Throwable)e);
                    return;
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class ImportLicenseCommand
    extends AsyncCommand {
        public ImportLicenseCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicenseManager.importLicense");
            this.setEnabled(false);
        }

        private void importFile() throws Exception {
            BDirectory currentSelection = BFileSystem.INSTANCE.getSysHome();
            BIFile[] licenseFiles = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.message", new Object[]{BLicenseManager.this.session.getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)BLicenseList.importFilter, (IFileFilter)BLicenseList.importFilter, (BFileChooserListView.ListModel)new LicenseListModel());
            if (licenseFiles.length > 0) {
                ArrayList toInstall = new ArrayList();
                for (BIFile licenseFile : licenseFiles) {
                    if (!BLicenseManager.this.licenses.getValidator().accept(licenseFile)) continue;
                    Collections.addAll(toInstall, PortalLicenseUtil.getLicenseInfo((BIFile)licenseFile, (String)BLicenseManager.this.getHostId(), (String)BLicenseManager.this.getBrandId()));
                }
                if (toInstall.size() > 0) {
                    LicenseInfo[] installedLicenses = BLicenseManager.this.licenses.getLicenses();
                    LicenseSync sync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])installedLicenses, (LicenseInfo[])toInstall.toArray(new LicenseInfo[toInstall.size()]));
                    BLicenseManager.this.sync((LicenseSync<LicenseInfo>)sync, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void getOnline(List<LicenseInfo> portalLicenseList) throws Exception {
            void var8_14;
            LicenseInfo[] installedLicenses = BLicenseManager.this.licenses.getLicenses();
            CertificateInfo[] installedCerts = BLicenseManager.this.certs.getCertificates();
            HashSet<String> vendorSet = new HashSet<String>();
            for (LicenseInfo licenseInfo : installedLicenses) {
                vendorSet.add(licenseInfo.vendorLicense.getVendor());
            }
            for (LicenseInfo licenseInfo : installedCerts) {
                vendorSet.add(licenseInfo.vendorCertificate.getVendor());
            }
            LicenseInfo[] portalLicenses = portalLicenseList.toArray(new LicenseInfo[portalLicenseList.size()]);
            boolean mustRequest = true;
            Object var8_12 = null;
            LicenseSync certSync = null;
            try {
                LicenseSync licenseSync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])installedLicenses, (LicenseInfo[])portalLicenses);
                for (LicenseInfo portalLicense : portalLicenses) {
                    vendorSet.add(portalLicense.vendorLicense.getVendor());
                }
                mustRequest = licenseSync.unchanged() && LicenseInfo.countActiveLicenses((LicenseInfo[])installedLicenses, (BAbsTime)BAbsTime.now()) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] vendors = new String[vendorSet.size()];
                vendorSet.toArray(vendors);
                CertificateInfo[] portalCerts = CertificateInfo.make((XElem[])PortalLicenseUtil.getCertificates((String[])vendors));
                certSync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installedCerts, (CertificateInfo[])portalCerts);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (var8_14 != null || certSync != null) {
                BLicenseManager.this.sync((LicenseSync<LicenseInfo>)var8_14, certSync);
            }
            if (mustRequest) {
                BRequestLicenseTool.requestLicense((BWidget)BLicenseManager.this.getWbShell(), (String)BLicenseManager.this.getHostId());
            }
        }

        public void requestLicense() throws Exception {
            UiUtil.requestLicense((BWidgetShell)this.getOwner().getShell(), (String)BLicenseManager.this.getHostId());
        }

        public void doInvokeAsync() {
            try {
                if (BLicenseManager.this.isLicenseReadonly()) {
                    throw new LocalizableRuntimeException("platDaemon", "LicenseManager.readonlyLicenses");
                }
                BGridPane grid = new BGridPane(1);
                ToggleCommandGroup grp = new ToggleCommandGroup();
                grid.add(null, (BValue)BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.file"), true, this::importFile));
                LicenseInfo[] installedLicenses = BLicenseManager.this.licenses.getLicenses();
                LicenseInfo[] dbLicenses = BLicenseManager.this.getDatabaseLicenses();
                LicenseSync dbSync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])installedLicenses, (LicenseInfo[])dbLicenses);
                BRadioButton useDb = BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.localDb"), false, () -> BLicenseManager.this.sync((LicenseSync<LicenseInfo>)dbSync, null));
                grid.add(null, (BValue)useDb);
                if (dbSync.unchanged()) {
                    useDb.setEnabled(false);
                }
                try {
                    if (PortalLicenseUtil.isApiAvailable()) {
                        if (PortalLicenseUtil.requestLicensesOnline()) {
                            List licenseModels = PortalLicenseUtil.getExistingLicenses((String)BLicenseManager.this.getHostId(), (String)BLicenseManager.this.licenses.getBrandId(), (Version)BLicenseManager.this.getNreVersion());
                            if (licenseModels.size() == 0) {
                                grid.add(null, (BValue)BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.getOnline"), false, () -> this.getOnline(Collections.emptyList())));
                            } else {
                                for (LicenseModel model : licenseModels) {
                                    if (model.hasDescription()) {
                                        grid.add(null, (BValue)BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.getModelOnline", new Object[]{model.toString(BLicenseManager.this.getCurrentContext())}), false, () -> this.getOnline(model.getLicenseInfos())));
                                        continue;
                                    }
                                    grid.add(null, (BValue)BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.getOnline"), false, () -> this.getOnline(model.getLicenseInfos())));
                                }
                            }
                        } else {
                            BRadioButton requestLicense = BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, lex.getText("LicenseManager.importType.requestLicense"), false, this::requestLicense);
                            grid.add(null, (BValue)requestLicense);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error getting license updates online", e);
                    grid.add(null, (BValue)BLicenseManager.this.makeButton((ToggleCommandGroup<? super ToggleCommand>)grp, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.getOnline"), false, () -> this.getOnline(Collections.emptyList())));
                }
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importType.dlgTitle"), (Object)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    ((ImportLicenseButtonCommand)grp.getSelected()).importLicense();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class ExportLicenseCommand
    extends AsyncCommand {
        public ExportLicenseCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicenseManager.exportLicense");
        }

        public void doInvokeAsync() {
            try {
                BDirectory currentSelection = BFileSystem.INSTANCE.getSysHome();
                FilePath path = BFileChooserDialog.chooseFilePath((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.message", new Object[]{BLicenseManager.this.session.getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)BLicenseList.larFilter, (IFilePathFilter)BLicenseList.larPathFilter, (BFileChooserListView.ListModel)new LicenseListModel(), (String)"licenses.lar");
                if (path != null) {
                    BLicenseArchiveFile dest = (BLicenseArchiveFile)BFileSystem.INSTANCE.findFile(path);
                    if (dest == null) {
                        dest = (BLicenseArchiveFile)BFileSystem.INSTANCE.makeFile(path);
                    } else if (8 == BDialog.confirm((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.replaceFileDialog.title"), (Object)BLicenseManager.this.getLexicon().getText("LicenseManager.replaceFileDialog.message", new Object[]{path.getName()}))) {
                        return;
                    }
                    int[] sel = BLicenseManager.this.licenses.getSelection().getItems();
                    VendorLicense[] lics = new VendorLicense[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        lics[i] = ((BLicenseManager)BLicenseManager.this).licenses.getLicenseInfo((int)sel[i]).vendorLicense;
                    }
                    dest.writeLicenses(lics);
                    BDialog.message((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.fileWrittenDialog.title"), (Object)BLicenseManager.this.getLexicon().getText("LicenseManager.fileWrittenDialog.message", new Object[]{path.getName()}));
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class FileListController
    extends CommandBindings.ListController {
        public FileListController(CommandBindings bindings) {
            super(bindings);
        }

        public void focusGained(BFocusEvent event) {
            BLicenseManager.this.setTransferWidget((BTransferWidget)this.getList());
            if (this.getList() == BLicenseManager.this.certs) {
                BLicenseManager.this.licenses.getSelection().deselectAll();
            } else {
                BLicenseManager.this.certs.getSelection().deselectAll();
            }
        }
    }
}

