/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class TcpIpStep
extends DistInstallWizardStep {
    private BCheckBox updateTcpIpCheckBox;

    public TcpIpStep(DistInstallWizardModel wizardModel) {
        super(wizardModel);
        Throwable throwable;
        ZipFile distFile;
        File file;
        BTcpIpHostSettings hostSettings = wizardModel.getDistribution().getTcpIpChanges();
        if (wizardModel.getSession().getHostProperties().supportsServlet("dhcpd")) {
            BDhcpdHostSettings hostSettingsInDistribution = new BDhcpdHostSettings();
            file = wizardModel.getDistribution().getLocalInstallableFile();
            try {
                distFile = new ZipFile(file);
                throwable = null;
                try {
                    DhcpdUtil.loadFromSession((BDhcpdHostSettings)hostSettingsInDistribution, (BDaemonSession)wizardModel.getSession());
                    boolean foundConfFile2 = false;
                    String[] enabledAdapters = null;
                    Enumeration<? extends ZipEntry> zipEntryEnumeration = distFile.entries();
                    while (zipEntryEnumeration.hasMoreElements() && (!foundConfFile2 || enabledAdapters == null)) {
                        ZipEntry entry = zipEntryEnumeration.nextElement();
                        if (entry.getName().equals("niagara_home/platform/dhcpd/dhcpd.conf")) {
                            foundConfFile2 = true;
                            DhcpdUtil.dhcpdConfToSettings((BDhcpdHostSettings)hostSettingsInDistribution, (InputStream)distFile.getInputStream(entry));
                            continue;
                        }
                        if (!entry.getName().equals("niagara_home/platform/dhcpd/dhcpd_adapters_list")) continue;
                        enabledAdapters = TextUtil.split((String)FileUtil.readString((Reader)new InputStreamReader(distFile.getInputStream(entry))).trim(), (char)',');
                        for (int i = 0; i < enabledAdapters.length; ++i) {
                            enabledAdapters[i] = DhcpdUtil.adapterOsNameToId((String)enabledAdapters[i]);
                        }
                    }
                    if (foundConfFile2) {
                        SlotCursor c = hostSettingsInDistribution.getDhcpdSubnets().loadSlots().getProperties();
                        while (c.next()) {
                            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
                            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
                            dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(false);
                        }
                        for (SlotCursor slotCursor : enabledAdapters) {
                            String propName = SlotPath.escape((String)slotCursor);
                            BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)hostSettingsInDistribution.getDhcpdSubnets().get(propName);
                            if (dhcpdSettings == null) continue;
                            dhcpdSettings.setIsDhcpdIpv4Enabled(true);
                        }
                    } else {
                        hostSettingsInDistribution = null;
                    }
                }
                catch (Throwable foundConfFile2) {
                    throwable = foundConfFile2;
                    throw foundConfFile2;
                }
                finally {
                    if (distFile != null) {
                        if (throwable != null) {
                            try {
                                distFile.close();
                            }
                            catch (Throwable foundConfFile2) {
                                throwable.addSuppressed(foundConfFile2);
                            }
                        } else {
                            distFile.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                wizardModel.getLogger().log(Level.SEVERE, "Failed to read DHCPD settings from distribution, skipping DHCPD handling", e);
                hostSettingsInDistribution = null;
            }
            if (hostSettingsInDistribution != null) {
                DhcpdUtil.copyDhcpdSlotToAdapters((BDhcpdHostSettings)hostSettingsInDistribution, (BTcpIpHostSettings)hostSettings);
            }
        }
        if (wizardModel.getSession().getHostProperties().supportsServlet("linkcfg")) {
            BLinkCfgHostSettings linkSettingsInDistribution = new BLinkCfgHostSettings();
            file = wizardModel.getDistribution().getLocalInstallableFile();
            try {
                distFile = new ZipFile(file);
                throwable = null;
                try {
                    LinkCfgUtil.loadFromSession((BLinkCfgHostSettings)linkSettingsInDistribution, (BDaemonSession)wizardModel.getSession());
                    boolean foundConfFile3 = false;
                    Enumeration<? extends ZipEntry> zipEntryEnumeration = distFile.entries();
                    while (zipEntryEnumeration.hasMoreElements() && !foundConfFile3) {
                        ZipEntry entry = zipEntryEnumeration.nextElement();
                        if (!entry.getName().equals("niagara_home/platform/net/link.cfg")) continue;
                        foundConfFile3 = true;
                        LinkCfgUtil.linkCfgToSettings((BLinkCfgHostSettings)linkSettingsInDistribution, (InputStream)distFile.getInputStream(entry));
                        break;
                    }
                    if (!foundConfFile3) {
                        linkSettingsInDistribution = null;
                    }
                }
                catch (Throwable foundConfFile3) {
                    throwable = foundConfFile3;
                    throw foundConfFile3;
                }
                finally {
                    if (distFile != null) {
                        if (throwable != null) {
                            try {
                                distFile.close();
                            }
                            catch (Throwable foundConfFile3) {
                                throwable.addSuppressed(foundConfFile3);
                            }
                        } else {
                            distFile.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                wizardModel.getLogger().log(Level.SEVERE, "Failed to read Link settings from distribution, skipping Link handling", e);
                linkSettingsInDistribution = null;
            }
            if (linkSettingsInDistribution != null) {
                LinkCfgUtil.copyLinkCfgSlotToHost((BLinkCfgHostSettings)linkSettingsInDistribution, (BTcpIpHostSettings)hostSettings);
            }
        }
        BIndentPane indent = new BIndentPane();
        indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("DistInstaller.TcpIpStep.header"), (boolean)true));
        indent.indent();
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        grid.setValign(BValign.top);
        grid.setHalign(BHalign.left);
        boolean ipv6Supported = false;
        SlotCursor c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            if (!adapter.getIsIpv6Supported()) continue;
            ipv6Supported = true;
            break;
        }
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.hostName"), (BWidget)new BLabel(this.nvl(hostSettings.getHostName())), (boolean)false);
        if (ipv6Supported) {
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.niagaraUsesIpv6"), (BWidget)new BLabel(String.valueOf(hostSettings.getNiagaraUsesIpv6())), (boolean)false);
        }
        if (!hostSettings.getUsesAdapterLevelSettings()) {
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.domain"), (BWidget)new BLabel(this.nvl(hostSettings.getDomain())), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(this.nvl(hostSettings.getDefaultGateway())), (boolean)false);
            StringBuilder dnsHosts = new StringBuilder();
            SlotCursor dnsList = hostSettings.getDnsHosts().getProperties();
            while (dnsList.next(BString.class)) {
                dnsHosts.append(dnsList.get().toString());
                dnsHosts.append(" ");
            }
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(this.nvl(dnsHosts.toString())), (boolean)false);
            if (ipv6Supported) {
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(this.nvl(hostSettings.getIpv6DefaultGateway())), (boolean)false);
                StringBuilder dns6Hosts = new StringBuilder();
                SlotCursor dnsList2 = hostSettings.getIpv6DnsHosts().getProperties();
                while (dnsList2.next(BString.class)) {
                    dns6Hosts.append(dnsList2.get().toString());
                    dns6Hosts.append(" ");
                }
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(this.nvl(dns6Hosts.toString())), (boolean)false);
            }
        }
        BTcpIpLinkSettings tcpIpLinkSettings = (BTcpIpLinkSettings)hostSettings.get("linkModeSettings");
        BVector linkModesSupported = (BVector)hostSettings.get("linkModesSupported");
        if (tcpIpLinkSettings != null && linkModesSupported != null) {
            boolean showLinkReview = true;
            if (linkModesSupported.getPropertyCount() == 1 && tcpIpLinkSettings.getLinkMode().getOrdinal() == 0) {
                showLinkReview = false;
            }
            if (showLinkReview) {
                BDaisyChainSettings daisyChainSettings;
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.activeLinkMode"), (BWidget)new BLabel(tcpIpLinkSettings.getLinkMode().getDisplayTag(null)), (boolean)false);
                if (tcpIpLinkSettings instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)tcpIpLinkSettings).getIsStpSupported()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpLabel"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getIsStpEnabled())), (boolean)false);
                    if (daisyChainSettings.getIsStpEnabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpBridgePriority"), (BWidget)new BLabel(daisyChainSettings.getBridgePriority().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority1"), (BWidget)new BLabel(daisyChainSettings.getPortPriority1().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority2"), (BWidget)new BLabel(daisyChainSettings.getPortPriority2().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpHelloTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getHelloTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpForwardDelayTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getForwardDelayTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpMaxAgingTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getMaxAgingTime())), (boolean)false);
                    }
                }
            }
        }
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.interfaceCategory"), (BWidget)new BNullWidget(), (boolean)false);
        indent.indent();
        indent.add((BWidget)grid);
        indent.indent();
        boolean firstPass = true;
        SlotCursor c2 = hostSettings.getAdapters().getProperties();
        while (c2.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c2.get();
            grid = new BGridPane(2);
            grid.setColumnGap(6.0);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            if (!firstPass) {
                grid.add(null, (BValue)new BBox(1.0, 1.0));
                grid.add(null, (BValue)new BBox(1.0, 1.0));
            }
            firstPass = false;
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceId"), (BWidget)new BLabel(adapter.getAdapterId()), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceDesc"), (BWidget)new BLabel(adapter.getDescription()), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.macAddress"), (BWidget)new BLabel(adapter.getMediaAccessControlAddress()), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isAdapterEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsAdapterEnabled())), (boolean)false);
            if (adapter.getIsAdapterEnabled()) {
                BDhcpdAdapterSettings dhcpdAdapterSettings;
                if (adapter.getCanUseDhcp()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isDhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsDhcpEnabled())), (boolean)false);
                    if (!adapter.getIsDhcpEnabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipAddress"), (BWidget)new BLabel(this.nvl(adapter.getIpAddress())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.subnetMask"), (BWidget)new BLabel(this.nvl(adapter.getSubnetMask())), (boolean)false);
                        if (hostSettings.getUsesAdapterLevelSettings()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.domain"), (BWidget)new BLabel(this.nvl(adapter.getDomain())), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(this.nvl(adapter.getDefaultGateway())), (boolean)false);
                            StringBuilder dnsHosts = new StringBuilder();
                            SlotCursor dnsList = adapter.getDnsHosts().getProperties();
                            while (dnsList.next(BString.class)) {
                                dnsHosts.append(dnsList.get().toString());
                                dnsHosts.append(" ");
                            }
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(this.nvl(dnsHosts.toString())), (boolean)false);
                        }
                    }
                }
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Supported"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Supported())), (boolean)false);
                if (adapter.getIsIpv6Supported()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Enabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Enabled())), (boolean)false);
                    if (adapter.getIsIpv6Enabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6DhcpEnabled())), (boolean)false);
                        if (!adapter.getIsIpv6DhcpEnabled()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Address"), (BWidget)new BLabel(this.nvl(adapter.getIpv6Address())), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength"), (BWidget)new BLabel(this.nvl(String.valueOf(adapter.getIpv6SubnetPrefixLength()))), (boolean)false);
                            if (hostSettings.getUsesAdapterLevelSettings()) {
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(this.nvl(adapter.getIpv6DefaultGateway())), (boolean)false);
                                StringBuilder dns6Hosts = new StringBuilder();
                                SlotCursor dnsList = adapter.getIpv6DnsHosts().getProperties();
                                while (dnsList.next(BString.class)) {
                                    dns6Hosts.append(dnsList.get().toString());
                                    dns6Hosts.append(" ");
                                }
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(this.nvl(dns6Hosts.toString())), (boolean)false);
                            }
                        }
                    }
                }
                if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings")) != null) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.isDhcpdEnabled"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled())), (boolean)false);
                    if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.defaultLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getDefaultLeaseTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.maxLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getMaxLeaseTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.subnet.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnet()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.netmask.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnetMask()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangestart.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getStartClientAddress()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangesize.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getRange())), (boolean)false);
                    }
                }
            }
            indent.add((BWidget)grid);
        }
        indent.unindent();
        indent.unindent();
        this.updateTcpIpCheckBox = new BCheckBox(Lexicon.make((String)"platDaemon").getText("DistInstaller.TcpIpStep.checkBox"));
        indent.add((BWidget)this.updateTcpIpCheckBox);
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 3.0, 3.0, 3.0, 3.0));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)scroll);
    }

    private String nvl(String value) {
        if (value == null || value.trim().length() == 0) {
            return Lexicon.make((String)"platDaemon").getText("DistInstaller.TcpIpStep.empty");
        }
        return value;
    }

    @Override
    public String getStepName() {
        return "TcpIpStep";
    }

    @Override
    public void enter() {
        this.updateTcpIpCheckBox.setSelected(this.getWizardModel().updateTcpIp());
    }

    @Override
    public boolean exit() {
        this.getWizardModel().setUpdateTcpIp(this.updateTcpIpCheckBox.isSelected());
        return true;
    }
}

