/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class FinishDistInstall
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private String lastText = null;
    private boolean mustReboot = false;
    private DistInstallWizardModel model;
    private TaskDetailPane.TaskItem stopAllAppsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.stopAllApps"));
    private TaskDetailPane.TaskItem installItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.install"));
    private TaskDetailPane.TaskItem installOsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.installOs"));
    private TaskDetailPane.TaskItem rebootItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.reboot"));
    private TaskDetailPane.TaskItem tcpItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.updateTcp"));
    private TaskDetailPane.TaskItem refreshDaemonItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.refreshDaemon"));
    private TaskDetailPane.TaskItem reconnectItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.reconnect"));
    private TaskDetailPane.TaskItem startAppsItem = new TaskDetailPane.TaskItem(lex.getText("DistInstaller.FinishDistInstall.item.startApp"));
    private Array<TaskDetailPane.TaskItem> items;

    public FinishDistInstall(DistInstallWizardModel model) throws Exception {
        this.model = model;
        this.items = new Array(TaskDetailPane.TaskItem.class);
        this.items.add((Object)this.stopAllAppsItem);
        this.items.add((Object)this.installItem);
        if (model.updateTcpIp()) {
            this.items.add((Object)this.tcpItem);
        }
        if ((model.getInstallScenario().getProcessingFlags() & 0x20000L) > 0L) {
            this.items.add((Object)this.installOsItem);
        }
        if ((model.getInstallScenario().getProcessingFlags() & 0x10000L) > 0L) {
            this.items.add((Object)this.rebootItem);
            this.mustReboot = true;
        } else if ((model.getInstallScenario().getProcessingFlags() & 0x40000L) > 0L) {
            this.items.add((Object)this.refreshDaemonItem);
            this.items.add((Object)this.reconnectItem);
        } else if (BAppSurrogate.isAnyAppRunning(null, (BDaemonSession)model.getSession())) {
            if (model.getSession().getHostProperties().getAllowStationRestart()) {
                this.items.add((Object)this.startAppsItem);
            } else {
                this.items.add((Object)this.rebootItem);
                this.mustReboot = true;
            }
        }
        this.init((BWidget)model.getWizard());
    }

    protected DistInstallWizardModel getWizardModel() {
        return this.model;
    }

    @Override
    public String getHeadingTitle() {
        return lex.getText("DistInstaller.FinishDistInstall.dialogHeading");
    }

    @Override
    public String getDialogTitle() {
        return lex.getText("DistInstaller.FinishDistInstall.dialogHeading");
    }

    @Override
    public BImage getHeadingIcon() {
        return DistInstallWizardModel.WIZ_IMAGE;
    }

    @Override
    public String getItemListHeading() {
        return lex.getText("DistInstaller.FinishDistInstall.itemHeading");
    }

    @Override
    public TaskDetailPane.TaskItem[] makeTaskItems() {
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block40: {
                boolean ignoreLink;
                BStationSurrogate[] allStations;
                BDaemonPlatform targetPlatform = this.getWizardModel().getPlatform();
                this.setCurrentItem(this.stopAllAppsItem, BJobState.running);
                BAppSurrogate[] stoppedApps = BAppSurrogate.stopAllApps((BDaemonSession)this.getWizardModel().getSession(), null, (ICancelHint)this, (DaemonSessionTaskListener)new DaemonSessionTaskHandler((BWidget)this.getDialog()));
                block12: for (BStationSurrogate station : allStations = BStationSurrogate.makeAll((BDaemonSession)this.getWizardModel().getSession())) {
                    BInstallable[] solutionInstallables;
                    if (station.getStationStatus() == BStationStatus.idle) continue;
                    for (BInstallable installable : solutionInstallables = this.getWizardModel().getInstallScenario().getToInstall()) {
                        BPart toInstall = installable.getPart();
                        if (toInstall == null || !(toInstall instanceof BNrePart)) continue;
                        DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)targetPlatform, (DaemonSessionTaskListener)this, (ICancelHint)this);
                        break block12;
                    }
                    break;
                }
                this.updateCurrentItemState(BJobState.success);
                this.setCurrentItem(this.installItem, BJobState.running);
                boolean ignoreDhcpd = !this.getWizardModel().getSession().getHostProperties().supportsServlet("dhcpd");
                boolean bl = ignoreLink = !this.getWizardModel().getSession().getHostProperties().supportsServlet("linkcfg");
                if (!this.getWizardModel().updateTcpIp()) {
                    ignoreDhcpd = true;
                    ignoreLink = true;
                }
                InstallScenario installScenario = this.getWizardModel().getInstallScenario();
                installScenario.setIgnoreDhcpdTransfer(ignoreDhcpd);
                installScenario.setIgnoreLinkTransfer(ignoreLink);
                boolean authReadonly = false;
                try {
                    XElem authInfo = XParser.make((InputStream)this.getWizardModel().getSession().getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
                    XElem authElem = authInfo.elem("auth");
                    if (authElem != null) {
                        authReadonly = authElem.getb("readonly", false);
                    }
                }
                catch (Exception authInfo) {
                    // empty catch block
                }
                installScenario.commit((DaemonSessionTaskListener)this, new StoreCache(), (ICancelHint)this, authReadonly, Optional.ofNullable(this.getWizardModel().makeMessageInitializer()));
                this.checkCanceled();
                this.updateCurrentItemState(BJobState.success);
                this.getWizardModel().getSession().getHostProperties().reset();
                targetPlatform.getModuleList().reset();
                if (this.getWizardModel().updateTcpIp()) {
                    this.setCurrentItem(this.tcpItem, BJobState.running);
                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.updateTcpMessage"));
                    this.getLog().append("\n");
                    TcpUtil.saveToSession((BTcpIpHostSettings)this.getWizardModel().getInstallScenario().getTcpIpChanges(), (BDaemonSession)this.getWizardModel().getSession(), (boolean)false);
                    this.updateCurrentItemState(BJobState.success);
                }
                if ((this.getWizardModel().getProcessingFlags() & 0x20000L) > 0L) {
                    this.setCurrentItem(this.installOsItem, BJobState.running);
                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.osInstallMessage"));
                    this.getLog().append("\n");
                    this.getWizardModel().getSession().sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
                    this.updateCurrentItemState(BJobState.success);
                }
                if (this.getWizardModel().getDistribution().getManifest().getPlatformUsersXml() != null && this.getWizardModel().getSession().getHostProperties().hasFullAccess() && this.getWizardModel().getSession().getHostProperties().supportsServlet("acctmgt")) {
                    BDaemonSession daemonSession = this.getWizardModel().getSession();
                    XElem authenticationInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage())).parse();
                    XElem authElem = authenticationInfo.elem("auth");
                    if (!authReadonly) {
                        XElem[] remoteGroups;
                        XElem adminGroupElement = authElem.elem("admingroup");
                        GroupAccount adminGroup = new GroupAccount(adminGroupElement.get("name"), adminGroupElement.get("id", null));
                        XElem accountInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                        ArrayList<UserAccount> usersToRemove = new ArrayList<UserAccount>();
                        for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                            if (!currentGroup.get("name").equals(adminGroup.getFullyQualifiedName())) continue;
                            XElem[] adminUsers = currentGroup.elems("user");
                            for (XElem adminUser : adminUsers) {
                                usersToRemove.add(new UserAccount(adminUser.get("name"), adminUser.get("id", null), adminUser.get("description"), null));
                            }
                        }
                        BUsernameAndPassword sessionCred = (BUsernameAndPassword)daemonSession.getCredentials();
                        String currentUserName = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
                        ArrayList<UserAccount> usersToAdd = new ArrayList<UserAccount>();
                        XElem platformUsers = this.getWizardModel().getDistribution().getManifest().getPlatformUsersXml();
                        XElem[] backupUsers = platformUsers.elems("user");
                        for (XElem backupUser : backupUsers) {
                            UserAccount userToAdd;
                            String passwordHashAttribute = backupUser.get("passwordHash");
                            if (!daemonSession.getHostProperties().getIsNpsdk()) {
                                boolean validBase64;
                                String[] hashSegments;
                                String passwordHash = null;
                                boolean validHash = false;
                                if (passwordHashAttribute != null && passwordHashAttribute.startsWith("@") && (hashSegments = TextUtil.split((String)passwordHashAttribute.substring(1), (char)'@')).length == 3) {
                                    passwordHash = hashSegments[1];
                                    validHash = true;
                                }
                                if (!validHash) {
                                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.canNotRestorePlatformUserHashInvalid", new Object[]{backupUser.get("name")}));
                                    this.getLog().append("\n");
                                    continue;
                                }
                                try {
                                    Base64.getDecoder().decode(passwordHash);
                                    validBase64 = true;
                                }
                                catch (Exception ignored) {
                                    validBase64 = false;
                                }
                                if (!validBase64) {
                                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.canNotRestorePlatformUserHashOldScheme", new Object[]{backupUser.get("name")}));
                                    this.getLog().append("\n");
                                    continue;
                                }
                            }
                            if ((userToAdd = new UserAccount(backupUser.get("name"), null, backupUser.get("description"), LegacyStorageUtil.encode((String)backupUser.get("passwordHash"), (int)0))).getAccountName().equals(currentUserName)) continue;
                            if (usersToAdd.size() >= 19) {
                                Object[] args = new Object[]{userToAdd.getAccountName(), 20};
                                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.canNotRestoreUserMax", args));
                                this.getLog().append("\n");
                                continue;
                            }
                            usersToAdd.add(userToAdd);
                        }
                        for (UserAccount userToRemove : usersToRemove) {
                            if (userToRemove.getAccountName().equals(currentUserName)) continue;
                            daemonSession.sendMessage((DaemonMessage)new DeleteMemberMessage(adminGroup, userToRemove));
                            daemonSession.sendMessage((DaemonMessage)new DeleteUserMessage(userToRemove));
                        }
                        for (UserAccount userToAdd : usersToAdd) {
                            AddUserMessage addUserMessage = new AddUserMessage(userToAdd, true);
                            addUserMessage.setSharedKey(daemonSession.generateSharedSecretKey("distInstall_addUser"));
                            daemonSession.sendMessage((DaemonMessage)addUserMessage);
                            daemonSession.sendMessage((DaemonMessage)new AddMemberMessage(adminGroup, userToAdd));
                        }
                    }
                }
                if (this.mustReboot) {
                    this.setCurrentItem(this.rebootItem, BJobState.running);
                    this.getWizardModel().getSession().sendRebootRequest();
                    this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.rebootMessage"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                } else {
                    if ((this.getWizardModel().getProcessingFlags() & 0x40000L) > 0L) {
                        String sessionTimestamp = this.getWizardModel().getSession().getHostProperties().getSessionTimestamp();
                        this.setCurrentItem(this.refreshDaemonItem, BJobState.running);
                        this.getWizardModel().getSession().sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                        this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.updateDaemonMessage"));
                        this.getLog().append("\n");
                        this.updateCurrentItemState(BJobState.success);
                        this.setCurrentItem(this.reconnectItem, BJobState.running);
                        this.setCancelEnabled(true);
                        this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.waitReconnect"));
                        this.getLog().append("\n");
                        Dots d = new Dots();
                        d.start();
                        try {
                            if (this.getWizardModel().getSession().reconnect(sessionTimestamp, (ICancelHint)this)) {
                                d.cancel();
                                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.reconnected"));
                                this.getLog().append("\n");
                                this.updateCurrentItemState(BJobState.success);
                                break block40;
                            }
                            throw new ICancelHint.CanceledException();
                        }
                        finally {
                            d.cancel();
                        }
                    }
                    if (stoppedApps.length > 0) {
                        if (!this.getWizardModel().getSession().getHostProperties().getAllowStationRestart()) {
                            this.setCurrentItem(this.rebootItem, BJobState.running);
                            this.getWizardModel().getSession().sendRebootRequest();
                            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.rebootMessage"));
                            this.getLog().append("\n");
                            this.updateCurrentItemState(BJobState.success);
                        } else {
                            this.getWizardModel().getSession().sendMessage((DaemonMessage)new UpdateStationMessage());
                            this.setCancelEnabled(true);
                            this.setCurrentItem(this.startAppsItem, BJobState.running);
                            for (BAppSurrogate app : stoppedApps) {
                                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.startApp", new Object[]{app.toString(null)}));
                                this.getLog().append("\n");
                                try {
                                    app.startAppAsync();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.updateCurrentItemState(BJobState.success);
                            targetPlatform.getModuleList().reset();
                        }
                    } else {
                        this.getWizardModel().getSession().sendMessage((DaemonMessage)new UpdateStationMessage());
                    }
                }
            }
            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.complete"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.complete"));
            if (this.mustReboot) {
                this.getLog().append("\n");
                this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.powerNotice"));
                this.getLog().append("\n");
            }
        }
        catch (ICancelHint.CanceledException ce) {
            this.cancel(false);
            this.getLog().append("\n");
            this.getLog().append(lex.getText("DistInstaller.FinishDistInstall.canceled"));
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.canceled"));
        }
        catch (Throwable t) {
            this.setCancelEnabled(true);
            this.updateCurrentItemState(BJobState.failed);
            this.setBottomLabelText(lex.getText("DistInstaller.FinishDistInstall.failed"));
            t.printStackTrace();
            this.getLog().append(t);
        }
    }

    public void taskStarted(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask task) {
        if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
            this.getLog().append(task.getMessage() + "\n");
            this.lastText = task.getMessage();
        }
        if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask task) {
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled;
        private boolean dotRunning;
        private int i;

        public Dots() {
            super("Ui:DotsThread");
            this.dotCanceled = false;
            this.dotRunning = true;
            this.i = 0;
        }

        @Override
        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    FinishDistInstall.this.getLog().append("\n");
                    this.i = 0;
                }
                FinishDistInstall.this.getLog().append(".");
            }
            FinishDistInstall.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

