/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.distinstall.DependenciesStep;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platDaemon.ui.distinstall.FinishDistInstall;
import com.tridium.platDaemon.ui.distinstall.PromptPassPhraseStep;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;

public class DistInstallWizardModel
extends WizardModel {
    private DistInstallWizardStep currentStep;
    private boolean dependenciesVerified = false;
    private BDaemonSession session;
    private BDistribution dist;
    private InstallScenario requiredScenario;
    private InstallScenario upgradeScenario;
    private BInstallable[] availableUpgrades;
    private boolean installUpgrades = false;
    private SessionSurrogates surrogates;
    private BWidget owner;
    private BDirectory distDir = null;
    private boolean useWorkbenchPaths = true;
    private DaemonSessionTaskHandler sessionTaskHandler;
    private boolean updateTcpIp = false;
    private boolean isCanceled = false;
    private SecretChars distFilePassPhrase = null;
    private boolean promptForPassPhrase = false;
    private static final Logger LOGGER = Logger.getLogger("platform.install");
    public static final FilePath DEFAULT_MODULE_PATH = new FilePath("!modules");
    public static final FilePath DEFAULT_DIST_PATH = new FilePath("!sw");
    public static final BImage WIZ_IMAGE = BImage.make((String)"module://icons/x32/modules.png");

    public DistInstallWizardModel(BWidget pOwner, BDistribution pDist, BDaemonSession pSession) throws Exception {
        this.owner = pOwner;
        this.session = pSession;
        this.surrogates = new SessionSurrogates(pSession);
        this.sessionTaskHandler = new DaemonSessionTaskHandler(this.owner);
        this.setDistribution(pDist);
        DependenciesStep depStep = new DependenciesStep(this);
        PromptPassPhraseStep promptPassPhraseStep = new PromptPassPhraseStep(this);
        boolean bl = this.promptForPassPhrase = this.getDistribution().getManifest().getPBEEncodingInfo() != null && !this.session.validateSystemPassPhrase((PBEValidator)this.getDistribution().getManifest().getPBEEncodingInfo());
        if (this.promptForPassPhrase) {
            promptPassPhraseStep.setNextStep(depStep);
            depStep.setPriorStep(promptPassPhraseStep);
            this.currentStep = promptPassPhraseStep;
        } else {
            this.currentStep = depStep;
        }
    }

    public String getTitle() {
        return BDaemonSessionView.lexicon.getText("DistInstallerWizard.title");
    }

    public boolean cancel() {
        this.isCanceled = BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("DistInstallerWizard.cancel.title"), (Object)BDaemonSessionView.lexicon.getText("DistInstallerWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
        return this.isCanceled;
    }

    public boolean hasNoSteps() {
        DistInstallWizardStep step;
        for (step = this.currentStep; step != null && step.isSkipped(); step = step.getNextStep()) {
        }
        return step == null;
    }

    public void init() {
        try {
            DistInstallWizardStep step;
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this.sessionTaskHandler);
            for (step = this.currentStep; step != null && step.isSkipped(); step = step.getNextStep()) {
            }
            if (step != null) {
                this.update(step);
                step.enter();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void back() {
        DistInstallWizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit()) {
            while (step != null && step.isSkipped()) {
                step = step.getPriorStep();
            }
            if (step != null) {
                this.update(step);
                step.enter();
            }
        }
    }

    public void next() {
        DistInstallWizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit()) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            if (step != null) {
                this.update(step);
                step.enter();
            }
        }
    }

    public boolean finish() {
        if (this.getCurrentStep().exit() && this.dependenciesVerified()) {
            try {
                new FinishDistInstall(this).open();
                return true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return false;
    }

    private DistInstallWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(DistInstallWizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(475.0, 300.0);
    }

    public void setWizard(BWizard wizard) {
        super.setWizard(wizard);
        this.sessionTaskHandler.setOwner((BWidget)wizard);
        this.owner = wizard;
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public DaemonSessionTaskHandler getTaskHandler() {
        return this.sessionTaskHandler;
    }

    public BDaemonSession getSession() {
        return this.session;
    }

    public BDaemonPlatform getPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.getTaskHandler());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BDirectory getDistDir() {
        return this.distDir;
    }

    public void setDistDir(BDirectory value) {
        this.distDir = value;
    }

    public boolean useWorkbenchPaths() {
        return this.useWorkbenchPaths;
    }

    public void setUseWorkbenchPaths(boolean value) {
        this.useWorkbenchPaths = value;
    }

    public BDistribution getDistribution() {
        return this.dist;
    }

    public void setDistribution(BDistribution value) {
        this.dist = value;
    }

    public void setRequiredScenario(InstallScenario value) {
        this.requiredScenario = value;
    }

    public InstallScenario getRequiredScenario() {
        return this.requiredScenario;
    }

    public void setUpgradeScenario(InstallScenario value) {
        this.upgradeScenario = value;
    }

    public void setAvailableUpgrades(BInstallable[] value) {
        this.availableUpgrades = value;
    }

    public BInstallable[] getAvailableUpgrades() {
        return this.availableUpgrades;
    }

    public InstallScenario getUpgradeScenario() {
        return this.upgradeScenario;
    }

    public InstallScenario getInstallScenario() {
        return this.installUpgrades() ? this.getUpgradeScenario() : this.getRequiredScenario();
    }

    public void setInstallUpgrades(boolean value) {
        this.installUpgrades = value;
    }

    public boolean installUpgrades() {
        return this.installUpgrades;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setUpdateTcpIp(boolean value) {
        this.updateTcpIp = value;
    }

    public boolean updateTcpIp() {
        return this.updateTcpIp;
    }

    public long getProcessingFlags() {
        return this.getInstallScenario().getProcessingFlags();
    }

    public void setDependenciesVerified(boolean value) {
        this.dependenciesVerified = value;
    }

    public boolean dependenciesVerified() {
        return this.dependenciesVerified;
    }

    public BAppSurrogate[] getAppSurrogates() throws AuthenticationException {
        try {
            return this.surrogates.getAll();
        }
        catch (ConnectException ce) {
            return null;
        }
    }

    public Consumer<FileTransferMessage> makeMessageInitializer() throws Exception {
        return DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)this.session, Optional.ofNullable(this.getDistribution().getManifest().getPBEEncodingInfo()), Optional.ofNullable(this.distFilePassPhrase));
    }

    public void setDistFilePassPhrase(SecretChars value) {
        this.distFilePassPhrase = value;
    }

    public boolean promptForPassPhrase() {
        return this.promptForPassPhrase;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

