/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BDateFE;
import java.net.ConnectException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BTimePrompt
extends BEdgePane {
    public static final Action handleModified = BTimePrompt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTimePrompt.class);
    private BWbFieldEditor timeFE;
    private BDateFE dateFE;
    private BListDropDown timeZoneChoice;
    private DialogCommand useLocalCommand;
    private DialogCommand saveCommand;
    private BDaemonSession daemonSession;
    private BWidget mainContent;
    private BTimeZone[] timeZones;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final BFacets HOUR_MINUTE = BFacets.make((String)"timeFormat", (String)"HH:mm");

    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BTimePrompt(BDaemonSession daemonSession, BTimeZone[] timeZones) throws ConnectException, AuthenticationException {
        this.daemonSession = daemonSession;
        this.timeZones = timeZones;
        BTimeZone currentTz = DaemonTimeUtil.getLocalTimeZone((BDaemonSession)daemonSession, (BTimeZone[])timeZones);
        BAbsTime currentDateTime = DaemonTimeUtil.getLocalTime((BDaemonSession)daemonSession, (BTimeZone)currentTz, (BTimeZone[])timeZones);
        BTime currentTime = BTime.make((BAbsTime)currentDateTime);
        BGridPane ledger = new BGridPane(2);
        ledger.setRowGap(5.0);
        ledger.setHalign(BHalign.left);
        ledger.setValign(BValign.top);
        this.dateFE = new BDateFE(currentDateTime);
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.dateLabel"), (BWidget)this.dateFE);
        this.timeFE = BWbFieldEditor.makeFor((BObject)currentTime, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.timeLabel"), (BWidget)this.timeFE);
        this.timeFE.loadValue((BObject)currentTime, (Context)HOUR_MINUTE);
        this.timeZoneChoice = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.dialog.timePrompt.tzLabel"), (BWidget)this.timeZoneChoice);
        this.timeZoneChoice.getList().setModel((ListModel)new TimeZoneListModel());
        this.timeZoneChoice.setSelectedItem((Object)currentTz);
        this.mainContent = new BBorderPane((BWidget)ledger, 10.0, 10.0, 10.0, 10.0);
        this.setCenter(this.mainContent);
        this.linkTo(null, (BComponent)this.dateFE, (Slot)BDateFE.pluginModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.timeFE, (Slot)BWbFieldEditor.pluginModified, (Slot)handleModified);
        this.linkTo(null, (BComponent)this.timeZoneChoice, (Slot)BListDropDown.listActionPerformed, (Slot)handleModified);
        this.mainContent.computePreferredSize();
        this.useLocalCommand = new UseLocalCommand();
        this.saveCommand = new SaveCommand();
    }

    public static BTimePrompt prompt(BWidget owner, BDaemonSession session, BTimeZone[] timeZones) throws ConnectException, AuthenticationException {
        BTimePrompt result = new BTimePrompt(session, timeZones);
        if (1 == BCommandDialog.open((BWidget)owner, (String)lex.getText("PlatformAdministration.dialog.timePrompt.title"), (Object)((Object)result), (DialogCommand[])new DialogCommand[]{result.useLocalCommand, result.saveCommand, DialogCommand.makeCancel((BWidget)result)})) {
            return result;
        }
        return null;
    }

    public BAbsTime getDateTime() {
        try {
            BAbsTime date = (BAbsTime)this.dateFE.saveValue();
            BTime time = (BTime)this.timeFE.saveValue();
            return BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)this.getSelectedTimeZone());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BTimeZone getSelectedTimeZone() {
        return (BTimeZone)this.timeZoneChoice.getSelectedItem();
    }

    public BTimeZone getTimeZone() {
        BDstSupportLevel supportLevel = this.getDaemonSession().getHostProperties().getTimezoneDayModeSupport();
        BTimeZone targetZone = this.getSelectedTimeZone();
        if (TimeZoneUtil.isSupported((BTimeZone)targetZone, (BDstSupportLevel)supportLevel)) {
            return TimeZoneUtil.makeCompatible((BTimeZone)targetZone, (BDstSupportLevel)supportLevel);
        }
        return BTimeZone.UTC;
    }

    public String getBajaTimeZoneId() {
        return this.getSelectedTimeZone().getId();
    }

    private BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    public void doHandleModified() {
        this.saveCommand.setEnabled(true);
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BTimePrompt.this, 1, UiLexicon.bajaui().getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }
    }

    private class UseLocalCommand
    extends DialogCommand {
        public UseLocalCommand() {
            super((BWidget)BTimePrompt.this, -1, lex.getText("PlatformAdministration.dialog.timePrompt.useLocal"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            try {
                BAbsTime now = BAbsTime.now();
                BTimePrompt.this.timeFE.loadValue((BObject)BTime.make((BAbsTime)now), (Context)HOUR_MINUTE);
                BTimePrompt.this.dateFE.loadValue((BObject)now);
                BTimeZone selectedTz = DaemonTimeUtil.getEquivalentTimeZone((BTimeZone)BTimeZone.getLocal(), (BTimeZone[])BTimePrompt.this.timeZones);
                if (selectedTz == null) {
                    boolean foundZone = false;
                    String localId = BTimeZone.getLocal().getId();
                    for (BTimeZone timeZone : BTimePrompt.this.timeZones) {
                        if (!timeZone.getId().equals(localId)) continue;
                        BTimePrompt.this.timeZoneChoice.setSelectedItem((Object)timeZone);
                        foundZone = true;
                        break;
                    }
                    if (!foundZone) {
                        now = BAbsTime.make((BAbsTime)now, (BTimeZone)((BTimeZone)BTimePrompt.this.timeZoneChoice.getSelectedItem()));
                        BTimePrompt.this.timeFE.loadValue((BObject)BTime.make((BAbsTime)now), (Context)HOUR_MINUTE);
                        BTimePrompt.this.dateFE.loadValue((BObject)now);
                    }
                } else {
                    BTimePrompt.this.timeZoneChoice.setSelectedItem((Object)selectedTz);
                }
                this.getDialog().repaint();
                BTimePrompt.this.saveCommand.setEnabled(true);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class TimeZoneListModel
    extends ListModel {
        public int getItemCount() {
            return BTimePrompt.this.timeZones.length;
        }

        public BTimeZone getTimeZone(int index) {
            return BTimePrompt.this.timeZones[index];
        }

        public Object getItem(int index) {
            return this.getTimeZone(index);
        }
    }
}

