/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetSystemLogMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BTextOutputPane;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BSystemLogDialog
extends BFrame {
    public static final Type TYPE = Sys.loadType(BSystemLogDialog.class);
    private final BTextOutputPane systemLogOutputPane;
    private final BTextOutputPane log1OutputPane;
    private final BTextOutputPane log2OutputPane;
    private final BDaemonSession daemonSession;
    private static final Lexicon lex = TYPE.getModule().getLexicon();

    public Type getType() {
        return TYPE;
    }

    public BSystemLogDialog() {
        throw new UnsupportedOperationException();
    }

    public BSystemLogDialog(BWidget owner, BDaemonSession session) throws ConnectException, AuthenticationException {
        super(lex.getText("SystemLogDialog.title", new Object[]{session.getRemoteAddressString()}));
        this.daemonSession = session;
        this.systemLogOutputPane = new BTextOutputPane();
        this.log1OutputPane = new BTextOutputPane();
        this.log2OutputPane = new BTextOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("SystemLogDialog.icon")));
        BButtonPane buttonPane = new BButtonPane();
        buttonPane.add((Command)new CloseCommand());
        RefreshCommand refreshCommand = new RefreshCommand();
        buttonPane.add((Command)refreshCommand);
        BTabbedPane logPanes = new BTabbedPane();
        logPanes.addPane(new BLabel(lex.get("SystemLogDialog.currentLogs")), (BWidget)this.systemLogOutputPane);
        logPanes.addPane(new BLabel(lex.get("SystemLogDialog.log1")), (BWidget)this.log1OutputPane);
        logPanes.addPane(new BLabel(lex.get("SystemLogDialog.log2")), (BWidget)this.log2OutputPane);
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)logPanes, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        try {
            refreshCommand.doInvoke();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadBounds() {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bounds = (BComponent)options.get("bounds");
            if (bounds == null) {
                Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * ss.getWidth()), (int)(0.9 * ss.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bounds.getInt(bounds.getProperty("x")), bounds.getInt(bounds.getProperty("y")), bounds.getInt(bounds.getProperty("width")), bounds.getInt(bounds.getProperty("height")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)sd.width, (double)sd.height));
    }

    public void setBoundsCenteredOn(RectGeom screenRect) {
        this.computePreferredSize();
        double w = this.getPreferredWidth() + 8.0;
        double h = this.getPreferredHeight() + 27.0;
        double x = screenRect.x + (screenRect.width - w) / 2.0;
        double y = screenRect.y + (screenRect.height - h) / 2.0;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        double sw = ss.width;
        double sh = ss.height;
        if (x + w > sw) {
            x = sw - w;
        }
        if (y + h > sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this.setScreenBounds(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.systemLogOutputPane.stop();
            this.log2OutputPane.stop();
            this.log1OutputPane.stop();
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bounds = new BFolder();
            IRectGeom screenBounds = this.getScreenBounds();
            bounds.add("x", (BValue)BInteger.make((int)((int)screenBounds.x())));
            bounds.add("y", (BValue)BInteger.make((int)((int)screenBounds.y())));
            bounds.add("width", (BValue)BInteger.make((int)((int)screenBounds.width())));
            bounds.add("height", (BValue)BInteger.make((int)((int)screenBounds.height())));
            if (options.get("bounds") == null) {
                options.add("bounds", (BValue)bounds);
            } else {
                options.set("bounds", (BValue)bounds);
            }
            options.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    private String refreshLog(String log) {
        StringBuilder logContents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.daemonSession.getInputStream((DaemonMessage)new GetSystemLogMessage(log))));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                logContents.append(line).append("\n");
            }
        }
        catch (Exception e) {
            logContents = new StringBuilder();
            logContents.append("Error reading log contents: ").append(e);
        }
        return logContents.toString();
    }

    private class RefreshCommand
    extends Command {
        public RefreshCommand() {
            super((BWidget)BSystemLogDialog.this, TYPE.getModule(), "SystemLogDialog.command.refresh");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSystemLogDialog.this.daemonSession.getHostProperties().getOsName().startsWith("tridium-qnx7")) {
                BSystemLogDialog.this.systemLogOutputPane.setText(BSystemLogDialog.this.refreshLog("viewlog"));
                BSystemLogDialog.this.log1OutputPane.setText(BSystemLogDialog.this.refreshLog("viewlog!log1"));
                BSystemLogDialog.this.log2OutputPane.setText(BSystemLogDialog.this.refreshLog("viewlog!log2"));
            } else {
                BSystemLogDialog.this.systemLogOutputPane.setText(BSystemLogDialog.this.refreshLog("sloginfo"));
                BSystemLogDialog.this.log1OutputPane.setText(BSystemLogDialog.this.refreshLog("sloginfo!/var/slog/log1"));
                BSystemLogDialog.this.log2OutputPane.setText(BSystemLogDialog.this.refreshLog("sloginfo!/var/slog/log2"));
            }
            BSystemLogDialog.this.systemLogOutputPane.getEditor().moveCaretPosition(BSystemLogDialog.this.systemLogOutputPane.getEditor().getModel().getEndPosition());
            BSystemLogDialog.this.log1OutputPane.getEditor().moveCaretPosition(BSystemLogDialog.this.log1OutputPane.getEditor().getModel().getEndPosition());
            BSystemLogDialog.this.log2OutputPane.getEditor().moveCaretPosition(BSystemLogDialog.this.log2OutputPane.getEditor().getModel().getEndPosition());
            BSystemLogDialog.this.systemLogOutputPane.repaint();
            BSystemLogDialog.this.log1OutputPane.repaint();
            BSystemLogDialog.this.log2OutputPane.repaint();
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BSystemLogDialog.this, TYPE.getModule(), "SystemLogDialog.command.close");
        }

        public CommandArtifact doInvoke() throws Exception {
            BSystemLogDialog.this.close();
            return null;
        }
    }
}

