/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.part.BOsPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.acctmgt.FileDomainPasswordController;
import com.tridium.platDaemon.ui.acctmgt.QnxUserNameController;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.AuthenticateUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateFileAuthenticationMessage;
import com.tridium.platform.daemon.message.UpdateNativeAuthenticationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AuthenticationWizardModel
extends WizardModel {
    private BDaemonSession session = null;
    private AuthWizardStep currentStep = null;
    private String authMethod = null;
    private String currentAuthMethod = null;
    private Set<String> authTypesSupported = null;
    private boolean authReadonly = false;
    private GroupAccount adminGroup = null;
    private String adminUser = "tridium";
    private BPassword adminPassword = BPassword.DEFAULT;
    private XElem authInfo = null;
    private boolean usingDefaultFileDomainCredentials = false;
    private String queryUsername = "";
    private BPassword queryPassword = BPassword.DEFAULT;
    private XmlResponseMessage initialAuthMessage = null;
    private static final BImage wizImage = BImage.make((String)"module://icons/x32/user.png");
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");

    public AuthenticationWizardModel(BDaemonSession session) throws Exception {
        this.session = session;
    }

    public String getTitle() {
        return lex.getText("AuthWizard.title");
    }

    public boolean cancel() {
        return this.getCurrentStep().getMode() == 0 || BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("AuthWizard.cancel.title"), (Object)lex.getText("AuthWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
    }

    public void init() {
        AuthWizardStep step;
        try {
            this.authInfo = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new AuthenticationInfoMessage())).parse();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        XElem authElem = this.authInfo.elem("auth");
        assert (authElem != null);
        this.setCurrentAuthMethod(authElem.get("type"));
        this.setAuthMethod(authElem.get("type"));
        this.setAuthReadonly(authElem.getb("readonly", false));
        HashSet<String> authTypesSupported = new HashSet<String>();
        Collections.addAll(authTypesSupported, authElem.get("authTypesSupported").split(","));
        this.setAuthTypesSupported(authTypesSupported);
        XElem elem = authElem.elem("admingroup");
        if (elem != null) {
            this.setAdminGroup(new GroupAccount(elem.get("name"), elem.get("id")));
        }
        if ((elem = authElem.elem("user")) != null && DaemonAuthUtil.isFileScheme((String)this.getAuthMethod())) {
            this.setAdminUser(elem.get("name"));
            this.setUsingDefaultFileDomainCredentials(elem.getb("default", false));
        }
        switch (this.getAuthMethod()) {
            case "digest/file": 
            case "scram-glibc-sha512/file": {
                try {
                    this.initialAuthMessage = new UpdateFileAuthenticationMessage(this.getAuthMethod(), this.getAdminUser(), this.getAdminPassword(), this.getDaemonSession().generateSharedSecretKey("authnWizard"));
                    break;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            case "basic/native": 
            case "scram-sha512/native": 
            case "scram-glibc-sha256/native": 
            case "scram-glibc-sha512/native": {
                this.initialAuthMessage = new UpdateNativeAuthenticationMessage(this.getAuthMethod(), this.getAdminGroup());
                break;
            }
            default: {
                throw new BajaRuntimeException(lex.getText("AuthWizard.error.scheme", new Object[]{this.getAuthMethod()}));
            }
        }
        for (step = new AuthMethodStep(); step != null && step.isSkipped(); step = step.getNextStep()) {
        }
        this.update(step);
        assert (step != null);
        step.enter();
    }

    public void back() {
        AuthWizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit(1)) {
            this.update(step);
            step.enter();
        }
    }

    public void next() {
        AuthWizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit(2)) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            assert (step != null);
            step.setPriorStep(this.getCurrentStep());
            this.update(step);
            step.enter();
        }
    }

    public boolean finish() {
        UpdateNativeAuthenticationMessage newAuthenticationMessage;
        if (!this.getCurrentStep().exit(4)) {
            return false;
        }
        switch (this.getAuthMethod()) {
            case "digest/file": 
            case "scram-glibc-sha512/file": {
                try {
                    newAuthenticationMessage = new UpdateFileAuthenticationMessage(this.getAuthMethod(), this.getAdminUser(), this.getAdminPassword(), this.getDaemonSession().generateSharedSecretKey("authnWizard"));
                    break;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            case "basic/native": 
            case "scram-sha512/native": 
            case "scram-glibc-sha256/native": 
            case "scram-glibc-sha512/native": {
                newAuthenticationMessage = new UpdateNativeAuthenticationMessage(this.getAuthMethod(), this.getAdminGroup());
                break;
            }
            default: {
                throw new BajaRuntimeException(lex.getText("AuthWizard.error.scheme", new Object[]{this.getAuthMethod()}));
            }
        }
        if (this.initialAuthMessage.getMessageString().equals(newAuthenticationMessage.getMessageString())) {
            return true;
        }
        try {
            this.getDaemonSession().sendMessage((DaemonMessage)newAuthenticationMessage);
            if (DaemonAuthUtil.isFileScheme((String)this.getAuthMethod())) {
                DaemonCredentialsManager.setCredentials(this.getDaemonSession(), (BICredentials)new BUsernameAndPassword(this.getAdminUser(), this.getAdminPassword()));
            } else {
                DaemonCredentialsManager.setCredentials(this.getDaemonSession(), (BICredentials)new BUsernameAndPassword(this.queryUsername, this.queryPassword));
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getWizard(), (String)lex.get("AuthWizard.error.finish"), (Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    private AuthWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(AuthWizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(650.0, 300.0);
    }

    public BDaemonPlatform getDaemonPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String value) {
        this.authMethod = value;
    }

    public boolean getAuthReadonly() {
        return this.authReadonly;
    }

    public void setAuthReadonly(boolean value) {
        this.authReadonly = value;
    }

    public void setCurrentAuthMethod(String value) {
        this.currentAuthMethod = value;
    }

    public String getCurrentAuthMethod() {
        return this.currentAuthMethod;
    }

    public NativeAccount getAdminGroup() {
        return this.adminGroup;
    }

    public void setAdminGroup(GroupAccount value) {
        this.adminGroup = value;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String value) {
        this.adminUser = value;
    }

    public boolean getUsingDefaultFileDomainCredentials() {
        return this.usingDefaultFileDomainCredentials;
    }

    public void setUsingDefaultFileDomainCredentials(boolean value) {
        this.usingDefaultFileDomainCredentials = value;
    }

    public BPassword getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(BPassword value) {
        this.adminPassword = value;
    }

    public Set<String> getAuthTypesSupported() {
        return this.authTypesSupported;
    }

    public void setAuthTypesSupported(Set<String> value) {
        this.authTypesSupported = value;
    }

    private XElem getAuthInfo() {
        return this.authInfo;
    }

    private String getPasswordFEText(BPasswordFE fe) {
        return ((BTextField)fe.getContent()).getText();
    }

    private static String makeFriendlyOsName(String osPart) {
        String osNameForLabel = null;
        osNameForLabel = osPart.toLowerCase().contains("win") ? "Windows" : (osPart.toLowerCase().contains("qnx") ? "QNX" : (osPart.toLowerCase().contains("linux") ? "Linux" : osPart));
        return osNameForLabel;
    }

    private static boolean passwordsMatch(String password, String confirm) {
        if (password != null && password.length() > 0 && confirm != null && confirm.length() > 0) {
            return password.equals(confirm);
        }
        return false;
    }

    static /* synthetic */ BImage access$100() {
        return wizImage;
    }

    private class NativeGroupStep
    extends AuthWizardStep {
        private BListDropDown adminList;

        public NativeGroupStep() {
            BIndentPane indent = new BIndentPane();
            String osNameForLabel = AuthenticationWizardModel.makeFriendlyOsName(AuthenticationWizardModel.this.getDaemonPlatform().getOsPart().getPartName());
            indent.add(lex.getText("AuthWizard.authNativeGroupStep.header", new Object[]{osNameForLabel}));
            indent.add((BWidget)new BBox(0.0, 5.0));
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.adminList = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authNativeGroupStep.adminList.label"), (BWidget)this.adminList);
            indent.add((BWidget)grid);
            this.setContent((BWidget)indent);
        }

        @Override
        public String getStepName() {
            return "authNativeGroupStep";
        }

        @Override
        public void enter() {
            this.adminList.getList().removeAllItems();
            for (XElem domain : AuthenticationWizardModel.this.getAuthInfo().elems("domain")) {
                for (XElem group : domain.elems("group")) {
                    this.adminList.getList().addItem((Object)new GroupAccount(group.get("name"), group.get("id")));
                }
            }
            if (this.adminList.getList().indexOfItem((Object)AuthenticationWizardModel.this.getAdminGroup()) >= 0) {
                this.adminList.getList().setSelectedItem((Object)AuthenticationWizardModel.this.getAdminGroup());
            } else {
                this.adminList.getList().getSelection().deselectAll();
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            if (this.adminList.getList().getSelectedIndex() < 0) {
                BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.nullAdminGroup"));
                return false;
            }
            AuthenticationWizardModel.this.setAdminGroup((GroupAccount)this.adminList.getList().getSelectedItem());
            return true;
        }

        @Override
        public int getMode() {
            return 5;
        }
    }

    private class NativeCredentialsStep
    extends AuthWizardStep
    implements ModeStep {
        private BTextField usernameTextField;
        private BPasswordFE passwordFE;

        public NativeCredentialsStep() {
            NativeGroupStep groupStep = new NativeGroupStep();
            this.setNextStep(groupStep);
            groupStep.setPriorStep(this);
            BIndentPane indent = new BIndentPane();
            indent.add(lex.getText("AuthWizard.authNativeCredentialsStep.header"));
            indent.add((BWidget)new BBox(0.0, 5.0));
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.usernameTextField = new BTextField("", 20);
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authNativeCredentialsStep.user.label"), (BWidget)this.usernameTextField);
            this.passwordFE = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authNativeCredentialsStep.pw.label"), (BWidget)this.passwordFE);
            this.usernameTextField.setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE.getContent()).setModel((TextModel)new ModeControlModel(this));
            indent.add((BWidget)grid);
            this.setContent((BWidget)indent);
        }

        @Override
        public String getStepName() {
            return "authNativeCredentialsStep";
        }

        @Override
        public int getMode() {
            int mode = this.getPriorStep() == null || this.getPriorStep().isSkipped() ? 0 : 1;
            if (this.usernameTextField.getText().trim().length() == 0 || AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE).trim().length() == 0) {
                return mode;
            }
            return mode | 2;
        }

        @Override
        public void enter() {
            this.usernameTextField.setText(AuthenticationWizardModel.this.queryUsername);
            if (AuthenticationWizardModel.this.queryPassword != null) {
                if (AccessController.doPrivileged(() -> ((BPassword)AuthenticationWizardModel.this.queryPassword).getValue()).length() > 0) {
                    this.passwordFE.loadValue((BObject)AuthenticationWizardModel.this.queryPassword);
                }
            }
        }

        @Override
        public boolean exit(int direction) {
            try {
                BPassword password;
                String username;
                block10: {
                    block9: {
                        boolean back;
                        boolean bl = back = direction == 1;
                        if (back) {
                            return true;
                        }
                        username = this.usernameTextField.getText();
                        password = (BPassword)this.passwordFE.saveValue();
                        if (username == null || username.trim().length() == 0 || password == null) break block9;
                        if (AccessController.doPrivileged(() -> ((BPassword)password).getValue()).trim().length() != 0) break block10;
                    }
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.fieldRequired"));
                    return false;
                }
                if (username.equals(AuthenticationWizardModel.this.queryUsername) && password.equals((Object)AuthenticationWizardModel.this.queryPassword)) {
                    return true;
                }
                AuthenticateUserMessage authUserMessage = new AuthenticateUserMessage(username, password, AuthenticationWizardModel.this.getDaemonSession().generateSharedSecretKey("authnWizard"));
                XElem userAuthInfo = XParser.make((InputStream)AuthenticationWizardModel.this.getDaemonSession().getInputStream((DaemonMessage)authUserMessage, "text/xml")).parse();
                if (userAuthInfo.elems("domain").length == 0) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.badCredentials"));
                    return false;
                }
                AuthenticationWizardModel.this.queryUsername = username;
                AuthenticationWizardModel.this.queryPassword = password;
                AuthenticationWizardModel.this.authInfo = userAuthInfo;
                return true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private class FileDomainUserStep
    extends AuthWizardStep
    implements ModeStep {
        private BTextField userNameField;
        private BPasswordFE passwordFE1;
        private BPasswordFE passwordFE2;
        private String authenticationScheme;

        public FileDomainUserStep(String authenticationScheme) {
            BIndentPane indent = new BIndentPane();
            indent.add(lex.getText("AuthWizard.authFileDomainUserStep.header"));
            indent.add((BWidget)new BBox(0.0, 5.0));
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.userNameField = new BTextField("", 20);
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authFileDomainUserStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE1 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authFileDomainUserStep.pw1.label"), (BWidget)this.passwordFE1);
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)lex.getText("AuthWizard.authFileDomainUserStep.pw1.label"), (BWidget)this.passwordFE2);
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            boolean QNX = AuthenticationWizardModel.this.getDaemonPlatform().getOsPart().getPartName().toLowerCase().contains("qnx");
            if (QNX) {
                ((BTextField)this.passwordFE1.getContent()).setController((TextController)new FileDomainPasswordController());
                ((BTextField)this.passwordFE2.getContent()).setController((TextController)new FileDomainPasswordController());
            }
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (QNX) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            indent.add((BWidget)grid);
            this.setContent((BWidget)indent);
        }

        @Override
        public String getStepName() {
            return "authFileDomainUserStep";
        }

        @Override
        public void enter() {
            this.userNameField.setText(AuthenticationWizardModel.this.getAdminUser());
            if (AuthenticationWizardModel.this.getAdminPassword() != null) {
                this.passwordFE1.loadValue((BObject)AuthenticationWizardModel.this.getAdminPassword());
                this.passwordFE2.loadValue((BObject)AuthenticationWizardModel.this.getAdminPassword());
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            try {
                BPassword pw2;
                BPassword pw1;
                block13: {
                    block12: {
                        pw1 = (BPassword)this.passwordFE1.saveValue();
                        pw2 = (BPassword)this.passwordFE2.saveValue();
                        if (pw1 == null) break block12;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()).trim().length() == 0 || pw2 == null) break block12;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()).trim().length() != 0) break block13;
                    }
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.passwordRequired"));
                    return false;
                }
                if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()))) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.passwordMismatch"));
                    return false;
                }
                if (!BNativeUserTable.validatePassword((BWidget)AuthenticationWizardModel.this.getWizard(), pw1, new BPasswordStrength(AuthenticationWizardModel.this.session.getPlatformPasswordStrengthRequirements()))) {
                    return false;
                }
                if (NativeAccount.isReservedName((String)this.userNameField.getText()) || this.userNameField.getText().contains("suNkiNg")) {
                    BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.userReserved", new Object[]{this.userNameField.getText()}));
                    return false;
                }
                if (AuthenticationWizardModel.this.getUsingDefaultFileDomainCredentials()) {
                    BUsernameAndPassword currentCred = (BUsernameAndPassword)AuthenticationWizardModel.this.session.getCredentials();
                    if (this.userNameField.getText().equalsIgnoreCase(currentCred.getUsername())) {
                        BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.defaultCredentials"));
                        return false;
                    }
                    if (SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)currentCred.getPassword()).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()))) {
                        BDialog.error((BWidget)AuthenticationWizardModel.this.getWizard(), (Object)lex.getText("AuthWizard.error.defaultCredentials"));
                        return false;
                    }
                }
                AuthenticationWizardModel.this.setAdminUser(this.userNameField.getText());
                AuthenticationWizardModel.this.setAdminPassword(pw1);
                return true;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public int getMode() {
            int mode = this.getPriorStep() == null || this.getPriorStep().isSkipped() ? 0 : 1;
            if (this.userNameField.getText().trim().length() > 0 && AuthenticationWizardModel.passwordsMatch(AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE1).trim(), AuthenticationWizardModel.this.getPasswordFEText(this.passwordFE2).trim())) {
                return mode | 4;
            }
            return mode;
        }
    }

    private class AuthMethodStep
    extends AuthWizardStep {
        private FileDomainUserStep userStep;
        private NativeCredentialsStep credentialsStep;
        private BRadioButton digestFileButton;
        private BRadioButton basicNativeButton;
        private BRadioButton scramNativeButton;
        private BRadioButton scramFileButton;

        public AuthMethodStep() {
            NextStepCommand cmd;
            this.digestFileButton = null;
            this.basicNativeButton = null;
            this.scramNativeButton = null;
            this.scramFileButton = null;
            BOsPart os = AuthenticationWizardModel.this.getDaemonPlatform().getOsPart();
            ToggleCommandGroup group = new ToggleCommandGroup();
            BGridPane grid = new BGridPane(1);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            String osNameForLabel = AuthenticationWizardModel.makeFriendlyOsName(os.getPartName());
            if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("basic/native")) {
                this.credentialsStep = new NativeCredentialsStep();
                cmd = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.credentialsStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{osNameForLabel});
                this.credentialsStep.setPriorStep(this);
                this.basicNativeButton = new BRadioButton((ToggleCommand)cmd, true, false);
                grid.add(null, (BValue)this.basicNativeButton);
                group.add((ToggleCommand)cmd);
            }
            if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("digest/file")) {
                this.userStep = new FileDomainUserStep("digest/file");
                cmd = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.userStep, "AuthWizard.authMethodStep.digestFile.label", null);
                this.userStep.setPriorStep(this);
                this.digestFileButton = new BRadioButton((ToggleCommand)cmd, true, false);
                grid.add(null, (BValue)this.digestFileButton);
                group.add((ToggleCommand)cmd);
            }
            if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-glibc-sha512/file")) {
                this.userStep = new FileDomainUserStep("scram-glibc-sha512/file");
                cmd = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.userStep, "AuthWizard.authMethodStep.scramFile.label", null);
                this.userStep.setPriorStep(this);
                this.scramFileButton = new BRadioButton((ToggleCommand)cmd, true, false);
                grid.add(null, (BValue)this.scramFileButton);
                group.add((ToggleCommand)cmd);
            }
            if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-sha512/native") || AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-glibc-sha256/native") || AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-glibc-sha512/native")) {
                this.credentialsStep = new NativeCredentialsStep();
                cmd = new NextStepCommand((BWidget)AuthenticationWizardModel.this.getWizard(), this, this.credentialsStep, "AuthWizard.authMethodStep.scramNative.label", new Object[]{osNameForLabel});
                this.credentialsStep.setPriorStep(this);
                this.scramNativeButton = new BRadioButton((ToggleCommand)cmd, true, false);
                grid.add(null, (BValue)this.scramNativeButton);
                group.add((ToggleCommand)cmd);
            }
            this.setContent((BWidget)new BEdgePane(null, null, null, null, (BWidget)grid));
            if (this.isSkipped()) {
                if (this.credentialsStep != null && AuthenticationWizardModel.this.getCurrentAuthMethod().equals("basic/native")) {
                    this.basicNativeButton.setSelected(true);
                    this.credentialsStep.setPriorStep(this);
                    this.setNextStep(this.credentialsStep);
                } else if (this.credentialsStep != null && (AuthenticationWizardModel.this.getCurrentAuthMethod().equals("scram-sha512/native") || AuthenticationWizardModel.this.getCurrentAuthMethod().equals("scram-glibc-sha256/native") || AuthenticationWizardModel.this.getCurrentAuthMethod().equals("scram-glibc-sha512/native"))) {
                    this.scramNativeButton.setSelected(true);
                    this.credentialsStep.setPriorStep(this);
                    this.setNextStep(this.credentialsStep);
                } else if (this.userStep != null && AuthenticationWizardModel.this.getCurrentAuthMethod().equals("digest/file")) {
                    this.digestFileButton.setSelected(true);
                    this.userStep.setPriorStep(this);
                    this.setNextStep(this.userStep);
                } else if (this.userStep != null && AuthenticationWizardModel.this.getCurrentAuthMethod().equals("scram-glibc-sha512/file")) {
                    this.scramFileButton.setSelected(true);
                    this.userStep.setPriorStep(this);
                    this.setNextStep(this.userStep);
                }
            }
        }

        @Override
        public String getStepName() {
            return "authMethodStep";
        }

        @Override
        public boolean isSkipped() {
            return AuthenticationWizardModel.this.getAuthTypesSupported().size() == 1;
        }

        @Override
        public int getMode() {
            return 2;
        }

        @Override
        public void enter() {
            switch (AuthenticationWizardModel.this.getAuthMethod()) {
                case "basic/native": {
                    this.basicNativeButton.setSelected(true);
                    this.setNextStep(this.credentialsStep);
                    break;
                }
                case "scram-sha512/native": 
                case "scram-glibc-sha256/native": 
                case "scram-glibc-sha512/native": {
                    this.scramNativeButton.setSelected(true);
                    this.setNextStep(this.credentialsStep);
                    break;
                }
                case "digest/file": {
                    this.digestFileButton.setSelected(true);
                    this.setNextStep(this.userStep);
                    break;
                }
                case "scram-glibc-sha512/file": {
                    this.scramFileButton.setSelected(true);
                    this.setNextStep(this.userStep);
                }
            }
        }

        @Override
        public boolean exit(int direction) {
            if (this.digestFileButton != null && this.digestFileButton.isSelected()) {
                AuthenticationWizardModel.this.setAuthMethod("digest/file");
            } else if (this.scramFileButton != null && this.scramFileButton.isSelected()) {
                AuthenticationWizardModel.this.setAuthMethod("scram-glibc-sha512/file");
            } else if (this.basicNativeButton != null && this.basicNativeButton.isSelected()) {
                AuthenticationWizardModel.this.setAuthMethod("basic/native");
            } else if (this.scramNativeButton != null && this.scramNativeButton.isSelected()) {
                if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-sha512/native")) {
                    AuthenticationWizardModel.this.setAuthMethod("scram-sha512/native");
                } else if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-glibc-sha256/native")) {
                    AuthenticationWizardModel.this.setAuthMethod("scram-glibc-sha256/native");
                } else if (AuthenticationWizardModel.this.getAuthTypesSupported().contains("scram-glibc-sha512/native")) {
                    AuthenticationWizardModel.this.setAuthMethod("scram-glibc-sha512/native");
                }
            }
            return true;
        }
    }

    public abstract class AuthWizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(AuthenticationWizardModel.access$100(), AuthenticationWizardModel.access$000().getText("AuthWizard.headerTitle"), AuthenticationWizardModel.access$000().getText("AuthWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private AuthWizardStep priorStep = null;
        private AuthWizardStep nextStep = null;

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget content) {
            this.contentPane.setCenter(content);
        }

        public int getMode() {
            return 0;
        }

        public AuthWizardStep getPriorStep() {
            return this.priorStep;
        }

        public AuthWizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(AuthWizardStep step) {
            this.nextStep = step;
        }

        public void enter() {
        }

        public boolean exit(int direction) {
            return true;
        }

        public void setPriorStep(AuthWizardStep step) {
            this.priorStep = step;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }

    private class NextStepCommand
    extends ToggleCommand {
        private AuthWizardStep fromStep;
        private AuthWizardStep toStep;

        public NextStepCommand(BWidget owner, AuthWizardStep pFromStep, AuthWizardStep pToStep, String lexKey, Object[] lexiconArguments) {
            super(owner, lex.getText(lexKey, lexiconArguments));
            this.fromStep = pFromStep;
            this.toStep = pToStep;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                this.fromStep.setNextStep(this.toStep);
                this.toStep.setPriorStep(this.fromStep);
            }
            return null;
        }
    }

    private class ModeControlModel
    extends TextModel {
        private ModeStep step;

        public ModeControlModel(ModeStep pStep) {
            this.step = pStep;
        }

        protected void textModified() {
            AuthenticationWizardModel.this.update(this.step.getMode());
        }
    }

    private static interface ModeStep {
        public int getMode();
    }
}

