/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.BInsets;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;

public class FirstStep
extends CommissioningWizardStep {
    private List<Check> checks = new ArrayList<Check>();
    private BCheckBox installModules;
    private BCheckBox installDistFiles;
    private BCheckBox configTcp;
    private BCheckBox configAuth;
    private BCheckBox removeDefaultUser;
    private BCheckBox configUsers;
    private BCheckBox configSystemPassword;
    private BCheckBox copyStation;
    private BCheckBox configRuntimeProfiles;
    private BCheckBox installLexicon;
    private BCheckBox installLicense;
    private BCheckBox syncDateTime;
    private BCheckBox fipsMode;

    public FirstStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        BIndentPane indent = new BIndentPane();
        indent.add(this.getLexiconText("CommissioningWizard.first.header1"));
        indent.indent();
        indent.add((BWidget)new BBox(0.0, 3.0));
        if (FipsOptionsHelper.getInstance().showFipsOption(wizardModel.daemonSession)) {
            this.fipsMode = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.fips"));
            indent.add((BWidget)this.fipsMode);
            this.fipsMode.setSelected(FipsOptionsHelper.getInstance().checkFipsOption(wizardModel.daemonSession));
            this.fipsMode.setEnabled(!FipsOptionsHelper.getInstance().fipsOptionReadOnly(wizardModel.daemonSession));
        }
        this.installLicense = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.licenseItem"));
        indent.add((BWidget)this.installLicense);
        this.configRuntimeProfiles = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.runtimeProfileItem"));
        indent.add((BWidget)this.configRuntimeProfiles);
        if (Boolean.valueOf(BrandProps.getLocalInstance().get("platform.disableStationCopy", "false")).booleanValue()) {
            this.copyStation = null;
        } else {
            this.copyStation = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.stationItem"));
            indent.add((BWidget)this.copyStation);
        }
        this.installLexicon = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.lexItem"));
        indent.add((BWidget)this.installLexicon);
        this.installModules = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.moduleItem"));
        indent.add((BWidget)this.installModules);
        this.installDistFiles = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.distItem"));
        indent.add((BWidget)this.installDistFiles);
        this.syncDateTime = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.dateTimeItem"));
        indent.add((BWidget)this.syncDateTime);
        this.configTcp = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.tcpItem"));
        indent.add((BWidget)this.configTcp);
        if (wizardModel.daemonSession.getHostProperties().supportsServlet("systempw")) {
            this.configSystemPassword = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.systemPasswordItem"));
            indent.add((BWidget)this.configSystemPassword);
        }
        if (wizardModel.authTypesSupported.size() > 1 || !wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
            this.configAuth = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.authItem"));
            indent.add((BWidget)this.configAuth);
        }
        if (wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
            if (wizardModel.defaultAccountPresent) {
                this.removeDefaultUser = new BCheckBox(LEX.getText("CommissioningWizard.first.removeDefaultItem"));
                indent.add((BWidget)this.removeDefaultUser);
                if (wizardModel.authReadonly) {
                    this.removeDefaultUser.setSelected(false);
                    this.removeDefaultUser.setEnabled(false);
                } else {
                    this.removeDefaultUser.setSelected(true);
                    this.removeDefaultUser.setEnabled(false);
                }
            }
            this.configUsers = new BCheckBox((ToggleCommand)new Check("CommissioningWizard.first.usersItem"));
            indent.add((BWidget)this.configUsers);
        }
        indent.add((BWidget)new BBox(0.0, 6.0));
        BButtonPane buttons = new BButtonPane();
        BButton button = new BButton((Command)new ClearAll());
        buttons.add((BWidget)button);
        button.setFont(Theme.widget().getTextFont());
        button.setPadding(BInsets.make((double)4.0, (double)8.0, (double)4.0, (double)8.0));
        button = new BButton((Command)new CheckAll());
        buttons.add((BWidget)button);
        button.setFont(Theme.widget().getTextFont());
        button.setPadding(BInsets.make((double)4.0, (double)8.0, (double)4.0, (double)8.0));
        indent.add((BWidget)buttons);
        this.setContent((BWidget)indent);
    }

    @Override
    public String getStepName() {
        return "first";
    }

    @Override
    public String getSectionName() {
        return "wizard";
    }

    @Override
    public void enter() {
        if (this.wizardModel.requireModules) {
            this.wizardModel.skipModules = false;
            this.installModules.getCommand().setEnabled(false);
        } else {
            this.installModules.getCommand().setEnabled(this.wizardModel.enableModules);
        }
        this.installModules.setSelected(!this.wizardModel.skipModules);
        if (this.wizardModel.requireDist) {
            this.wizardModel.skipDist = false;
            this.installDistFiles.getCommand().setEnabled(false);
        } else {
            this.installDistFiles.getCommand().setEnabled(this.wizardModel.enableDist);
        }
        this.installDistFiles.setSelected(!this.wizardModel.skipDist);
        if (this.wizardModel.requireDist) {
            this.wizardModel.skipRuntimeProfiles = false;
            this.configRuntimeProfiles.getCommand().setEnabled(false);
        } else {
            this.configRuntimeProfiles.getCommand().setEnabled(this.wizardModel.enableRuntimeProfiles);
        }
        this.configRuntimeProfiles.setSelected(!this.wizardModel.skipRuntimeProfiles);
        this.configTcp.setSelected(!this.wizardModel.skipTcp);
        this.configTcp.getCommand().setEnabled(this.wizardModel.enableTcp);
        if (this.wizardModel.requireAuth) {
            this.wizardModel.skipAuth = false;
        }
        if (this.configAuth != null) {
            this.configAuth.setSelected(!this.wizardModel.skipAuth);
            this.configAuth.getCommand().setEnabled(this.wizardModel.enableAuth);
        }
        if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
            this.configUsers.setSelected(!this.wizardModel.skipConfigUsers);
            this.configUsers.getCommand().setEnabled(this.wizardModel.enableConfigUsers);
        }
        if (this.configSystemPassword != null) {
            if (this.wizardModel.requireSystemPassword) {
                this.wizardModel.skipSystemPassword = false;
            }
            this.configSystemPassword.setSelected(!this.wizardModel.skipSystemPassword);
            this.configSystemPassword.getCommand().setEnabled(this.wizardModel.enableSystemPassword);
        }
        if (this.copyStation != null) {
            this.copyStation.setSelected(!this.wizardModel.skipStation);
        }
        this.installLexicon.setSelected(!this.wizardModel.skipLexicon);
        if (this.wizardModel.requireLicense) {
            this.wizardModel.skipLicense = false;
        }
        this.installLicense.setSelected(!this.wizardModel.skipLicense);
        this.installLicense.getCommand().setEnabled(this.wizardModel.enableLicense);
        if (this.wizardModel.requireSyncLocalTime) {
            this.wizardModel.skipSyncLocalTime = false;
        }
        this.syncDateTime.setSelected(!this.wizardModel.skipSyncLocalTime);
        this.syncDateTime.getCommand().setEnabled(this.wizardModel.enableSyncLocalTime);
    }

    @Override
    public boolean exit(int direction) {
        this.wizardModel.isFips = this.fipsMode != null && this.fipsMode.getSelected();
        this.wizardModel.skipDist = !this.installDistFiles.isSelected();
        this.wizardModel.skipModules = !this.installModules.isSelected();
        boolean bl = this.wizardModel.skipTcp = !this.configTcp.isSelected();
        if (this.configAuth != null) {
            boolean bl2 = this.wizardModel.skipAuth = !this.configAuth.isSelected();
        }
        if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
            if (this.wizardModel.defaultAccountPresent && !this.wizardModel.authReadonly) {
                this.wizardModel.skipAuth = false;
            }
            boolean bl3 = this.wizardModel.skipConfigUsers = !this.configUsers.isSelected();
            if (!this.wizardModel.skipConfigUsers) {
                this.wizardModel.skipAuth = false;
            }
        }
        this.wizardModel.skipSystemPassword = this.configSystemPassword == null || !this.configSystemPassword.isSelected();
        this.wizardModel.skipStation = this.copyStation == null || !this.copyStation.isSelected();
        this.wizardModel.skipRuntimeProfiles = !this.configRuntimeProfiles.isSelected();
        this.wizardModel.skipLexicon = !this.installLexicon.isSelected();
        this.wizardModel.skipLicense = !this.installLicense.isSelected();
        this.wizardModel.skipSyncLocalTime = !this.syncDateTime.isSelected();
        this.wizardModel.syncLocalTime = this.syncDateTime.isSelected();
        if (this.wizardModel.skipStation) {
            this.wizardModel.stationDir = null;
        }
        return true;
    }

    @Override
    public int getMode() {
        return 2;
    }

    private class ClearAll
    extends Command {
        public ClearAll() {
            super(FirstStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.first.clearAll"));
        }

        public CommandArtifact doInvoke() {
            FirstStep.this.checks.stream().filter(Command::isEnabled).forEach(check -> check.setSelected(false));
            return null;
        }
    }

    private class CheckAll
    extends Command {
        public CheckAll() {
            super(FirstStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.first.checkAll"));
        }

        public CommandArtifact doInvoke() {
            FirstStep.this.checks.stream().filter(Command::isEnabled).forEach(check -> check.setSelected(true));
            return null;
        }
    }

    private class Check
    extends ToggleCommand {
        public Check(String lexTag) {
            super(FirstStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText(lexTag));
            FirstStep.this.checks.add(this);
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }
}

