/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyUtil;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BFlowPane;

public class DistStep
extends CommissioningWizardStep
implements DaemonSessionTaskListener {
    private BCheckBox reinstallCheckBox = null;
    private InstallScenario solution;
    private BDistribution unacceptedDist = null;
    private boolean hasCommitPrivileges;
    private static final BIcon WARN_ICON = BIcon.std((String)"warning.png");
    private static final int WORD_WRAP_LABEL_BUFFER = 45;
    private int mode = 0;
    private CancelableDaemonSessionTask cancelable = null;

    public DistStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getStepName() {
        return "dist";
    }

    @Override
    public String getSectionName() {
        return "dist";
    }

    @Override
    public void enter() {
        this.wizardModel.sessionTaskHandler.waitAllTasks();
        this.cancelable = null;
        this.solution = null;
        this.unacceptedDist = null;
        SignedDistFilter.resetVerificationCache();
        try {
            this.solution = DistStep.getDistScenario(this.wizardModel.moduleScenario, this.wizardModel.moduleScenarioHasDists, (BDaemonPlatform)this.wizardModel.getPlatform(), this.wizardModel, this);
            if (this.solution == null) {
                this.setContent(this.getNoDistsContent(this.unacceptedDist));
                if (!this.wizardModel.requireDist) {
                    this.setMode(3);
                } else {
                    this.setMode(1);
                }
            } else if (this.solution.canCommit()) {
                long flags = this.solution.getProcessingFlags();
                if (!(this.wizardModel.isAdmin || (flags & 0x10000L) <= 0L && (flags & 0x80000L) <= 0L && (flags & 0x20000L) <= 0L)) {
                    this.setContent(this.getInsufficientPrivilegesContent());
                    this.hasCommitPrivileges = false;
                    if (this.wizardModel.requireDist) {
                        this.setMode(1);
                    } else {
                        this.setMode(3);
                    }
                } else {
                    this.setContent(this.getSummaryContent(this.unacceptedDist));
                    this.hasCommitPrivileges = true;
                    this.setMode(3);
                }
            } else {
                this.setContent(this.getUnmetDependenciesContent(this.unacceptedDist));
                if (this.wizardModel.requireDist) {
                    this.setMode(1);
                } else {
                    this.setMode(3);
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static InstallScenario getDistScenario(InstallScenario moduleScenario, boolean moduleScenarioHasDists, BDaemonPlatform platform, CommissioningWizardModel wizardModel, DistStep distStep) throws Exception {
        InstallScenario solution = null;
        if (moduleScenarioHasDists && wizardModel.skipDist) {
            solution = moduleScenario;
        } else {
            InstallScenario initialDistScenario = moduleScenario;
            if (moduleScenarioHasDists) {
                ArrayList<BInstallable> toInstallArray = new ArrayList<BInstallable>();
                Collections.addAll(toInstallArray, initialDistScenario.getToInstall());
                toInstallArray.removeIf(obj -> !(obj instanceof BModuleInstallable));
                initialDistScenario = new InstallScenario(initialDistScenario.getTargetPlatform(), null, initialDistScenario.getUnmetDependencies(), toInstallArray.toArray(new BInstallable[toInstallArray.size()]), null, null, initialDistScenario.getNewModuleContent(), initialDistScenario.getNewEnabledRuntimeProfiles(), initialDistScenario.getSolutionParameters(), (InstallableRegistry)LocalInstallableRegistry.getInstance(), initialDistScenario.getCertValidator());
                if (initialDistScenario.getExcludedInstallables().length > 0) {
                    solution = moduleScenario;
                }
            }
            if (initialDistScenario.getExcludedInstallables().length == 0) {
                try (LocalInstallableRegistry.InstallableCursor c = (LocalInstallableRegistry.InstallableCursor)LocalInstallableRegistry.getInstance().getInstallables(true, (DaemonSessionTaskListener)wizardModel.sessionTaskHandler, platform.getConfigDistFileName());){
                    while (c.next(BDistribution.class)) {
                        BDistribution d = (BDistribution)c.get();
                        boolean acceptedDist = wizardModel.acceptInstallable((BInstallable)d);
                        InstallScenario s = initialDistScenario.solve((DaemonSessionTaskListener)wizardModel.sessionTaskHandler, null, null, new BInstallable[]{d}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                        if (s.canCommit()) {
                            s = s.solve((DaemonSessionTaskListener)wizardModel.sessionTaskHandler, null, DependencyUtil.getPlatformModuleDependencies((BDaemonPlatform)platform, (BDistribution)d, (Set)s.getNewEnabledRuntimeProfiles()), null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                        }
                        if (s.canCommit()) {
                            solution = s;
                            break;
                        }
                        if (s.getExcludedInstallables().length != 0 || solution != null && s.getUnmeetableDependencies().length >= solution.getUnmeetableDependencies().length) continue;
                        boolean wrongPlatform = false;
                        for (UnmeetableDependency dep : s.getUnmeetableDependencies()) {
                            if (!dep.dependency.isPlatformDependency(platform)) continue;
                            wrongPlatform = true;
                            break;
                        }
                        if (wrongPlatform) continue;
                        if (acceptedDist) {
                            solution = s;
                            continue;
                        }
                        if (distStep == null || distStep.unacceptedDist != null) continue;
                        distStep.unacceptedDist = d;
                    }
                }
            }
        }
        return solution;
    }

    private BWidget getSummaryContent(BDistribution unacceptedDist) throws Exception {
        BLabel label;
        BIndentPane indent = new BIndentPane();
        BInstallable[] installables = this.solution.getToInstall();
        boolean anyUpdates = false;
        for (BInstallable installable : installables) {
            if (!(installable instanceof BDistribution) || !((BDistribution)installable).hasFileUpdates((BDaemonPlatform)this.wizardModel.getPlatform(), new StoreCache(), null, (DaemonSessionTaskListener)this)) continue;
            anyUpdates = true;
            break;
        }
        if (!anyUpdates) {
            indent.add(this.getLexiconText("CommissioningWizard.dist.summary.reinstall.head"));
        } else {
            indent.add(this.getLexiconText("CommissioningWizard.dist.summary.head"));
        }
        indent.add((BWidget)new BBox(0.0, 3.0));
        indent.indent();
        for (BInstallable installable : installables) {
            if (!(installable instanceof BDistribution)) continue;
            indent.add((BWidget)new BLabel(BImage.make((BIcon)installable.getIcon()), installable.toString()));
        }
        indent.unindent();
        indent.add((BWidget)new BBox(0.0, 6.0));
        if (!anyUpdates) {
            this.reinstallCheckBox = new BCheckBox(LEX.getText("CommissioningWizard.dist.summary.reinstall.checkbox"));
            indent.add((BWidget)this.reinstallCheckBox);
            if (unacceptedDist != null) {
                indent.add((BWidget)new BBox(0.0, 6.0));
                label = new BLabel(BImage.make((BIcon)WARN_ICON), LEX.getText("CommissioningWizard.dist.summary.reinstall.unlicensed", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                label.setHalign(BHalign.left);
                indent.add((BWidget)label);
                indent.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane flow = new BFlowPane(BHalign.left);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.summary.reinstall.unlicensed.foot.part1")));
                BButton button = new BButton((Command)new LicenseCommand(), true, false);
                button.setFont(Theme.widget().getTextFont());
                button.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                flow.add(null, (BValue)button);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.summary.reinstall.unlicensed.foot.part2")));
                indent.add((BWidget)flow);
            }
        } else {
            this.reinstallCheckBox = null;
            if (unacceptedDist == null) {
                indent.add(this.getLexiconText("CommissioningWizard.dist.summary.foot"));
            } else {
                label = new BLabel(BImage.make((BIcon)WARN_ICON), LEX.getText("CommissioningWizard.dist.summary.unlicensed", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                label.setHalign(BHalign.left);
                indent.add((BWidget)label);
                indent.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane flow = new BFlowPane(BHalign.left);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.summary.unlicensed.foot.part1")));
                BButton button = new BButton((Command)new LicenseCommand(), true, false);
                button.setFont(Theme.widget().getTextFont());
                button.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                flow.add(null, (BValue)button);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.summary.unlicensed.foot.part2")));
                indent.add((BWidget)flow);
            }
        }
        return indent;
    }

    private BWidget getInsufficientPrivilegesContent() throws Exception {
        BIndentPane indent = new BIndentPane();
        BInstallable[] installables = this.solution.getToInstall();
        indent.add((BWidget)new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), LEX.getText("CommissioningWizard.dist.noPrivs.head")));
        indent.add((BWidget)new BBox(0.0, 3.0));
        indent.indent();
        for (BInstallable installable : installables) {
            indent.add((BWidget)new BLabel(BImage.make((BIcon)installable.getIcon()), installable.toString()));
        }
        indent.unindent();
        indent.add((BWidget)new BBox(0.0, 6.0));
        if (this.wizardModel.requireDist) {
            indent.add(this.getLexiconText("CommissioningWizard.dist.noPrivs.foot.required"));
        } else {
            indent.add(this.getLexiconText("CommissioningWizard.dist.noPrivs.foot"));
        }
        return indent;
    }

    private BWidget getNoDistsContent(BDistribution unacceptedDist) throws Exception {
        String footerText;
        String headerText;
        BIndentPane indent = new BIndentPane();
        String footerText2 = null;
        if (unacceptedDist == null) {
            if (this.wizardModel.requireDist) {
                headerText = LEX.getText("CommissioningWizard.dist.noDists.head.required");
                footerText = LEX.getText("CommissioningWizard.dist.noDists.foot.required");
            } else {
                headerText = LEX.getText("CommissioningWizard.dist.noDists.head");
                footerText = LEX.getText("CommissioningWizard.dist.noDists.foot");
            }
        } else if (this.wizardModel.requireDist) {
            headerText = LEX.getText("CommissioningWizard.dist.noLicensedDists.head.required", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()});
            footerText = LEX.getText("CommissioningWizard.dist.noLicensedDists.foot.required.part1");
            footerText2 = LEX.getText("CommissioningWizard.dist.noLicensedDists.foot.required.part2");
        } else {
            headerText = LEX.getText("CommissioningWizard.dist.noLicensedDists.head", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()});
            footerText = LEX.getText("CommissioningWizard.dist.noLicensedDists.foot.part1");
            footerText2 = LEX.getText("CommissioningWizard.dist.noLicensedDists.foot.part2");
        }
        BLabel label = new BLabel(BImage.make((BIcon)WARN_ICON), headerText);
        label.setHalign(BHalign.left);
        indent.add((BWidget)label);
        indent.add((BWidget)new BBox(0.0, 3.0));
        if (footerText2 == null) {
            indent.add(footerText);
        } else {
            BFlowPane flow = new BFlowPane(BHalign.left);
            flow.add(null, (BValue)new BLabel(footerText));
            BButton button = new BButton((Command)new LicenseCommand(), true, false);
            button.setFont(Theme.widget().getTextFont());
            button.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
            flow.add(null, (BValue)button);
            flow.add(null, (BValue)new BLabel(footerText2));
            indent.add((BWidget)flow);
        }
        return indent;
    }

    private BWidget getUnmetDependenciesContent(BDistribution unacceptedDist) throws Exception {
        BLabel label;
        BIndentPane indent = new BIndentPane();
        indent.add((BWidget)new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), LEX.getText("CommissioningWizard.dist.unmetDeps.head")));
        indent.add((BWidget)new BBox(0.0, 3.0));
        indent.indent();
        UnmeetableDependency[] unmeetable = this.solution.getUnmeetableDependencies();
        if (unmeetable != null && unmeetable.length > 0) {
            ArrayList<InstallableFilter> failedFilters = new ArrayList<InstallableFilter>();
            UnmeetableDependency[] unmeetableDependencyArray = unmeetable;
            int n = unmeetableDependencyArray.length;
            for (int i = 0; i < n; ++i) {
                UnmeetableDependency anUnmeetable = unmeetableDependencyArray[i];
                InstallableFilter failedFilter = anUnmeetable.failedFilter;
                StringBuilder text = new StringBuilder(anUnmeetable.toString(null));
                if (failedFilter instanceof SignedDistFilter || failedFilter instanceof DistLicenseFeatureFilter) {
                    int index = failedFilters.indexOf(failedFilter);
                    if (index < 0) {
                        failedFilters.add(failedFilter);
                        index = failedFilters.indexOf(failedFilter);
                    }
                    text.append(' ');
                    for (int i2 = 0; i2 <= index; ++i2) {
                        text.append('*');
                    }
                }
                indent.add((BWidget)new BLabel(BImage.make((BIcon)anUnmeetable.getIcon()), text.toString()));
            }
            StringBuilder prefix = new StringBuilder();
            for (InstallableFilter filter : failedFilters) {
                if (filter instanceof SignedDistFilter) {
                    prefix.append('*');
                    indent.add((BWidget)new BBox(0.0, 3.0));
                    indent.add("(" + prefix + ") " + this.getLexiconText("CommissioningWizard.dist.failedSignature").getText(null));
                    continue;
                }
                if (!(filter instanceof DistLicenseFeatureFilter)) continue;
                prefix.append('*');
                indent.add((BWidget)new BBox(0.0, 3.0));
                String features = String.join((CharSequence)", ", ((DistLicenseFeatureFilter)filter).getSatisfyingFeatures());
                BLabel missingFeatureLabel = new BLabel("(" + prefix + ") " + this.getLexiconText("CommissioningWizard.unavailableModules.missingFeature").getText(null, new Object[]{features}));
                int targetWidth = (int)this.wizardModel.getWizard().getPreferredWidth() - 45;
                missingFeatureLabel.setWordWrapEnabled(true, (double)targetWidth);
                missingFeatureLabel.setHalign(BHalign.left);
                indent.add((BWidget)missingFeatureLabel);
            }
        }
        if (unmeetable == null || unmeetable.length == 0) {
            BDependency[] unmet = this.solution.getUnmetDependencies();
            for (BDependency anUnmet : unmet) {
                indent.add((BWidget)new BLabel(BImage.make((BIcon)anUnmet.getIcon()), anUnmet.toString(null)));
            }
        }
        indent.unindent();
        indent.add((BWidget)new BBox(0.0, 6.0));
        if (this.wizardModel.requireDist) {
            if (unacceptedDist == null) {
                indent.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.foot.required"));
            } else {
                label = new BLabel(BImage.make((BIcon)WARN_ICON), LEX.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
                label.setHalign(BHalign.left);
                indent.add((BWidget)label);
                indent.add((BWidget)new BBox(0.0, 6.0));
                BFlowPane flow = new BFlowPane(BHalign.left);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed.foot.part1")));
                BButton button = new BButton((Command)new LicenseCommand(), true, false);
                button.setFont(Theme.widget().getTextFont());
                button.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                flow.add(null, (BValue)button);
                flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.dist.unmetDeps.requiredUnlicensed.foot.part2")));
                indent.add((BWidget)flow);
            }
        } else if (unacceptedDist == null) {
            indent.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.foot"));
        } else {
            label = new BLabel(BImage.make((BIcon)WARN_ICON), LEX.getText("CommissioningWizard.dist.unmetDeps.unlicensed", new Object[]{unacceptedDist.getVersion().getVendorVersionString(), this.wizardModel.getNewLicenseVersion()}));
            label.setHalign(BHalign.left);
            indent.add((BWidget)label);
            indent.add((BWidget)new BBox(0.0, 6.0));
            indent.add(this.getLexiconText("CommissioningWizard.dist.unmetDeps.unlicensed.foot"));
            BButton button = new BButton((Command)new LicenseCommand(), true, false);
            button.setFont(Theme.widget().getTextFont());
            button.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
            indent.add((BWidget)button);
        }
        return indent;
    }

    @Override
    public boolean exit(int direction) {
        try {
            if (this.cancelable != null) {
                this.cancelable.cancel();
            }
            this.wizardModel.distSolution = (this.reinstallCheckBox == null || this.reinstallCheckBox.isSelected()) && this.hasCommitPrivileges ? this.solution : null;
        }
        finally {
            SignedDistFilter.resetVerificationCache();
        }
        return true;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipDist && !this.wizardModel.moduleScenarioHasDists;
    }

    @Override
    public boolean cancel() {
        try {
            if (this.cancelable != null) {
                this.cancelable.cancel();
            }
        }
        finally {
            SignedDistFilter.resetVerificationCache();
        }
        return true;
    }

    public void abort() {
        this.setMode(1);
    }

    @Override
    public void setStepAfterSection(CommissioningWizardStep value) {
        this.stepAfterSection = value;
        this.lastStep.nextStep = value;
        if (value != null) {
            value.priorStep = this;
        }
    }

    private void setMode(int value) {
        if (this.mode != value) {
            this.mode = value;
            if (this.wizardModel.getCurrentStep() == this) {
                this.wizardModel.update(this.mode);
            }
        }
    }

    public void taskStarted(DaemonSessionTask task) {
        if (task instanceof CancelableDaemonSessionTask) {
            this.cancelable = (CancelableDaemonSessionTask)task;
        }
    }

    public void taskUpdated(DaemonSessionTask task) {
    }

    public void taskFinished(DaemonSessionTask task) {
        if (task == this.cancelable) {
            this.cancelable = null;
        }
    }

    public boolean isCancelEnabled() {
        return true;
    }

    private class LicenseCommand
    extends Command {
        public LicenseCommand() {
            super(DistStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.dist.goLicense"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            if (DistStep.this.exit(1)) {
                DistStep.this.wizardModel.licenseStep.enter();
                DistStep.this.wizardModel.update(DistStep.this.wizardModel.licenseStep);
            }
            return null;
        }
    }
}

