/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.appsurrogate;

import com.tridium.platDaemon.ui.BOutputPane;
import com.tridium.platDaemon.ui.IDaemonSessionView;
import com.tridium.platDaemon.ui.appsurrogate.ClearOutputCommand;
import com.tridium.platDaemon.ui.appsurrogate.DumpThreadCommand;
import com.tridium.platDaemon.ui.appsurrogate.KillCommand;
import com.tridium.platDaemon.ui.appsurrogate.OutputDialogCommand;
import com.tridium.platDaemon.ui.appsurrogate.OutputSettingsCommand;
import com.tridium.platDaemon.ui.appsurrogate.RebootCommand;
import com.tridium.platDaemon.ui.appsurrogate.RestartCommand;
import com.tridium.platDaemon.ui.appsurrogate.SaveCommand;
import com.tridium.platDaemon.ui.appsurrogate.StartCommand;
import com.tridium.platDaemon.ui.appsurrogate.StopCommand;
import com.tridium.platDaemon.ui.appsurrogate.StreamOutputCommand;
import com.tridium.platDaemon.ui.appsurrogate.VerifyCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BAppSurrogateView
extends BWbComponentView
implements IDaemonSessionView {
    public static final Action sendUpdate = BAppSurrogateView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAppSurrogateView.class);
    static BModule myModule = Sys.getModuleForClass(BAppSurrogateView.class);
    protected BOutputPane outputPane;
    public StartCommand startCommand;
    public StopCommand stopCommand;
    public RestartCommand restartCommand;
    public RebootCommand rebootCommand;
    public KillCommand killCommand;
    public ClearOutputCommand clearOutputCommand;
    public DumpThreadCommand dumpThreadCommand;
    public OutputDialogCommand outputDialogCommand;
    public StreamOutputCommand streamCommand;
    public OutputSettingsCommand outputSettingsCommand;
    public PauseOutputCommand pauseOutputCommand;
    public ToggleCommand toggleAutoStartCommand;
    public ToggleCommand toggleAutoRestartCommand;
    public VerifyCommand verifyCommand;
    public SaveCommand saveCommand;
    protected BDaemonSession session = null;
    protected BObject navNode = null;
    protected BAppSurrogate app = null;
    protected boolean loading = false;
    protected DaemonSessionTaskListener taskListener;
    protected int minHeight;
    protected static final LexiconText NOT_APPLICABLE_TEXT = LexiconText.make((String)"platDaemon", (String)"ApplicationDirector.cell.notApplicable");

    public void sendUpdate() {
        this.invoke(sendUpdate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAppSurrogateView() {
        throw new UnsupportedOperationException();
    }

    public BAppSurrogateView(DaemonSessionTaskListener pTaskListener) {
        BScrollPane scroll = new BScrollPane();
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BEdgePane contentPane = new BEdgePane();
        this.taskListener = pTaskListener;
        this.outputPane = new BOutputPane(1, 1);
        contentPane.setCenter((BWidget)this.outputPane);
        this.setTransferWidget((BTransferWidget)this.outputPane.getEditor());
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setValign(BValign.top);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setRowGap(4.0);
        this.initCommands(this.outputPane);
        this.populateButtonPane(buttonPane);
        buttonPane.computePreferredSize();
        this.minHeight = (int)buttonPane.getPreferredHeight();
        contentPane.setRight((BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 0.0, 0.0, 3.0));
        scroll.setContent((BWidget)contentPane);
        this.setContent((BWidget)scroll);
    }

    protected void initCommands(BOutputPane outputPane) {
        this.toggleAutoStartCommand = new ToggleAutoStartCommand();
        this.toggleAutoRestartCommand = new ToggleAutoRestartCommand();
        this.startCommand = new StartCommand((BWidget)this, outputPane);
        this.stopCommand = new StopCommand((BWidget)this);
        this.restartCommand = new RestartCommand((BWidget)this, outputPane);
        this.rebootCommand = new RebootCommand(this);
        this.killCommand = new KillCommand((BWidget)this);
        this.clearOutputCommand = new ClearOutputCommand((BWidget)this, outputPane);
        this.outputDialogCommand = new OutputDialogCommand((BWidget)this);
        this.streamCommand = new StreamOutputCommand((BWidget)this);
        this.outputSettingsCommand = new OutputSettingsCommand((BWidget)this);
        this.pauseOutputCommand = new PauseOutputCommand();
        this.toggleAutoStartCommand.setEnabled(false);
        this.toggleAutoRestartCommand.setEnabled(false);
        this.restartCommand.setEnabled(false);
        this.rebootCommand.checkEnabled();
        this.pauseOutputCommand.setEnabled(false);
    }

    protected void populateButtonPane(BGridPane buttonPane) {
        buttonPane.add(null, (BValue)new BCheckBox(this.toggleAutoStartCommand));
        buttonPane.add(null, (BValue)new BCheckBox(this.toggleAutoRestartCommand));
        BButton button = new BButton((Command)this.startCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.stopCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.restartCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.rebootCommand, true, false);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.killCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        buttonPane.add(null, (BValue)new BBox(0.0, 10.0));
        button = new BButton((Command)this.clearOutputCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BToggleButton();
        buttonPane.add(null, (BValue)button);
        button.setCommand((Command)this.pauseOutputCommand, true, false);
        this.pauseOutputCommand.setButton((BAbstractButton)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.outputDialogCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.streamCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        buttonPane.add(null, (BValue)new BBox(0.0, 10.0));
        button = new BButton((Command)this.outputSettingsCommand);
        buttonPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void clearValue() {
        this.outputPane.clearValue();
        this.toggleAutoStartCommand.setEnabled(false);
        this.toggleAutoRestartCommand.setEnabled(false);
        this.rebootCommand.setEnabled(false);
        this.startCommand.setApp(null);
        this.stopCommand.setApp(null);
        this.restartCommand.setApp(null);
        this.killCommand.setApp(null);
        this.clearOutputCommand.setEnabled(false);
        this.pauseOutputCommand.setEnabled(false);
        this.outputDialogCommand.clear();
        this.outputSettingsCommand.setEnabled(false);
        this.streamCommand.setEnabled(false);
        this.app = null;
    }

    public BAppSurrogate getAppSurrogate() {
        return this.app;
    }

    public String getExtraDetails(BAppSurrogate app, Context cx) {
        return "";
    }

    public void init(BDaemonSession session, BObject navNode) {
        this.session = session;
        this.navNode = navNode;
        this.outputPane.setSession(session);
        this.outputDialogCommand.setSession(session);
        this.streamCommand.setSession(session);
    }

    @Override
    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    @Override
    public BAppSurrogate[] getAppSurrogates() {
        return null;
    }

    public boolean isCanceled() {
        return false;
    }

    public void cancel() {
    }

    public void taskStarted(DaemonSessionTask task) {
        this.taskListener.taskStarted(task);
    }

    public void taskUpdated(DaemonSessionTask task) {
        this.taskListener.taskUpdated(task);
    }

    public void taskFinished(DaemonSessionTask task) {
        this.taskListener.taskFinished(task);
    }

    public boolean isCancelEnabled() {
        return false;
    }

    public void doSendUpdate() throws Exception {
        if (this.loading || this.app == null) {
            return;
        }
        this.app.updateSettings(this.toggleAutoStartCommand.isSelected(), this.toggleAutoRestartCommand.isSelected());
    }

    public void deactivated() {
        super.deactivated();
        this.outputPane.deactivated();
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.loading = true;
        this.rebootCommand.checkEnabled();
        this.app = (BAppSurrogate)value;
        this.toggleAutoStartCommand.setSelected(this.app.getIsAutoStart());
        this.toggleAutoRestartCommand.setSelected(this.app.getIsAutoRestart());
        this.outputPane.loadApp(this.app);
        this.outputDialogCommand.loadApp(this.app);
        this.streamCommand.loadApp(this.app);
        this.stopCommand.setApp(this.app);
        this.killCommand.setApp(this.app);
        this.restartCommand.setApp(this.app);
        this.startCommand.setApp(this.app);
        this.outputSettingsCommand.loadApp(this.app);
        this.loading = false;
        this.toggleAutoRestartCommand.setEnabled(true);
        this.toggleAutoStartCommand.setEnabled(true);
        this.clearOutputCommand.setEnabled(true);
        this.pauseOutputCommand.setEnabled(true);
    }

    public String getOutputText() {
        return this.outputPane.getText();
    }

    public void setOutputBufferSize(int size) {
        this.outputPane.setOutputBufferSize(size);
    }

    protected String getPortText(int port, Context cx) {
        return port == -1 ? NOT_APPLICABLE_TEXT.getText(cx) : String.valueOf(port);
    }

    protected class ToggleAutoRestartCommand
    extends ToggleCommand {
        public ToggleAutoRestartCommand() {
            super((BWidget)BAppSurrogateView.this, myModule, "AppSurrogateView.command.toggleAutoRestart");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BAppSurrogateView.this.sendUpdate();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    protected class ToggleAutoStartCommand
    extends ToggleCommand {
        public ToggleAutoStartCommand() {
            super((BWidget)BAppSurrogateView.this, myModule, "AppSurrogateView.command.toggleAutoStart");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BAppSurrogateView.this.sendUpdate();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    protected class PauseOutputCommand
    extends ToggleCommand {
        private BAbstractButton button;

        public PauseOutputCommand() {
            super((BWidget)BAppSurrogateView.this, myModule, "AppSurrogateView.command.pauseOutput");
            this.setEnabled(false);
        }

        public String getLabel() {
            if (this.isSelected()) {
                return BAppSurrogateView.this.getLexicon().getText("AppSurrogateView.command.loadOutput.label");
            }
            return BAppSurrogateView.this.getLexicon().getText("AppSurrogateView.command.pauseOutput.label");
        }

        public String getDescription() {
            if (this.isSelected()) {
                return BAppSurrogateView.this.getLexicon().getText("AppSurrogateView.command.loadOutput.description");
            }
            return BAppSurrogateView.this.getLexicon().getText("AppSurrogateView.command.pauseOutput.description");
        }

        public CommandArtifact doInvoke() {
            try {
                this.button.setText(this.getLabel());
                if (this.isSelected()) {
                    BAppSurrogateView.this.outputPane.pauseUpdates();
                } else {
                    BAppSurrogateView.this.outputPane.resumeUpdates();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }

        public void setButton(BAbstractButton value) {
            this.button = value;
        }
    }
}

