/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BAddUserDialog;
import com.tridium.platDaemon.ui.acctmgt.BChangePasswordDialog;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.ChangePasswordMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BNativeUserTable
extends BTable {
    public static final Type TYPE = Sys.loadType(BNativeUserTable.class);
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private BButtonPane buttons;
    private Command addUserCommand;
    private Command deleteUserCommand;
    private Command changePasswordCommand;
    private BCheckBox fipsModeCheckBox;
    private boolean forceChangeUsers = false;
    private List<String> forceChangeUserList;
    BDaemonSession session = null;
    GroupAccount group;
    protected boolean commitChanges = true;
    public static final int MAX_USERS = 20;
    public static String replacementAccountUserName = null;
    public static String defaultAccountUserName = null;
    public static boolean defaultUserPresent = false;
    public static boolean authReadonly = false;

    public Type getType() {
        return TYPE;
    }

    public BNativeUserTable() {
        this.setModel(new UserModel());
        this.setController(new UserController());
        this.setCellRenderer(new UserCellRenderer());
        this.buttons = new BButtonPane();
        this.addUserCommand = new AddUserCommand();
        this.buttons.add(this.addUserCommand);
        this.deleteUserCommand = new DeleteUserCommand();
        this.buttons.add(this.deleteUserCommand);
        this.changePasswordCommand = new ChangePasswordCommand();
        this.buttons.add(this.changePasswordCommand);
        this.initFipsModeCheckBox();
    }

    public BNativeUserTable(boolean commitChanges) {
        this();
        this.commitChanges = commitChanges;
    }

    public BButtonPane getButtonPane() {
        return this.buttons;
    }

    public BCheckBox getFipsCheckBox() {
        return this.fipsModeCheckBox;
    }

    public boolean fipsModeSelected() {
        return this.fipsModeCheckBox != null && this.fipsModeCheckBox.isSelected();
    }

    private void initFipsModeCheckBox() {
        if (FipsOptionsHelper.getInstance().showFipsOption(this.session)) {
            this.fipsModeCheckBox = new BCheckBox(lex.getText("UserManager.fipsModeBox"));
            this.fipsModeCheckBox.setSelected(FipsOptionsHelper.getInstance().checkFipsOption(this.session));
            this.fipsModeCheckBox.setEnabled(!FipsOptionsHelper.getInstance().fipsOptionReadOnly(this.session));
        } else {
            this.fipsModeCheckBox = null;
        }
    }

    public void loadSession(BDaemonSession value) throws Exception {
        this.session = value;
        this.getUserModel().load();
        this.initFipsModeCheckBox();
    }

    public HashMap<String, UserAccount> getUsers() {
        HashMap<String, UserAccount> users = new HashMap<String, UserAccount>();
        for (int i = 0; i < this.getUserModel().getRowCount(); ++i) {
            UserAccount current = this.getUserModel().getUser(i);
            users.put(current.getFullyQualifiedName(), current);
        }
        return users;
    }

    public GroupAccount getGroup() {
        return this.group;
    }

    UserModel getUserModel() {
        return (UserModel)this.getModel();
    }

    public static boolean checkStatus(BWidget owner, BDaemonSession session, XmlResponseMessage msg) throws Exception {
        return session.sendMessage(errorMessage -> {
            if (owner != null) {
                BDialog.error((BWidget)owner, (Object)errorMessage.toString(null));
            }
        }, msg);
    }

    public static boolean validatePassword(BWidget owner, BPassword password, BPasswordStrength desiredStrength) {
        char[] passwordChars;
        if (password == null) {
            BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.passwordRequired"));
            return false;
        }
        if (AccessController.doPrivileged(() -> ((BPassword)password).getValue()).length() < 1) {
            BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.passwordTooShort"));
            return false;
        }
        for (char passwordChar : passwordChars = AccessController.doPrivileged(() -> ((BPassword)password).getValue()).toCharArray()) {
            if (passwordChar >= '!' && passwordChar <= '~') continue;
            BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.invalidPasswordCharacter", new Object[]{String.valueOf(passwordChar)}));
            return false;
        }
        if (passwordChars.length > 64) {
            BDialog.error((BWidget)owner, (Object)lex.getText("UserManager.error.passwordTooLong"));
            return false;
        }
        if (desiredStrength != null) {
            try {
                desiredStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
            }
            catch (Exception strengthException) {
                BDialog.error((BWidget)owner, (Object)strengthException.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean isReserved(String username) {
        return NativeAccount.isReservedName((String)username) || username.equalsIgnoreCase(defaultAccountUserName) || username.contains("suNkiNg");
    }

    public void setForceChangeUsers(boolean forceChangeUsers, List<String> forceChangeUserList) {
        this.forceChangeUsers = forceChangeUsers;
        this.forceChangeUserList = forceChangeUserList;
    }

    private class ChangePasswordCommand
    extends Command {
        public ChangePasswordCommand() {
            super((BWidget)BNativeUserTable.this, lex, "UserManager.ChangePasswordCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                if (BNativeUserTable.this.getSelection().isEmpty()) {
                    BDialog.error((BWidget)BNativeUserTable.this, (Object)lex.getText("UserManager.ChangePasswordCommand.canNotChangeNoUser"));
                    BNativeUserTable.this.getUserModel().getSelection().deselectAll();
                    return null;
                }
                UserAccount account = BNativeUserTable.this.getUserModel().getUser(BNativeUserTable.this.getSelection().getRow());
                if ((account = BChangePasswordDialog.open(BNativeUserTable.this, account, lex.getText("UserManager.ChangePasswordCommand.dlgTitle", new Object[]{account.getAccountName()}))) != null) {
                    if (BNativeUserTable.this.forceChangeUserList != null) {
                        BNativeUserTable.this.forceChangeUserList.remove(account.getAccountName());
                    }
                    if (BNativeUserTable.this.commitChanges) {
                        BUsernameAndPassword sessionCred = (BUsernameAndPassword)BNativeUserTable.this.session.getCredentials();
                        String currentUserName = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
                        boolean changingCurrentUser = currentUserName.equals(account.getAccountName());
                        ChangePasswordMessage changePasswordMessage = new ChangePasswordMessage(account, account.getOldPassword(), account.getPassword(), changingCurrentUser);
                        changePasswordMessage.setSharedKey(BNativeUserTable.this.session.generateSharedSecretKey("NativeUserTable_check"));
                        if (BNativeUserTable.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.session, (XmlResponseMessage)changePasswordMessage)) {
                            BDialog.info((BWidget)BNativeUserTable.this, (Object)lex.getText("UserManager.success.passwordChangedUser", new Object[]{account.getAccountName()}));
                            if (changingCurrentUser) {
                                BUsernameAndPassword newCredentials = new BUsernameAndPassword(currentUserName, LegacyStorageUtil.decode((String)account.getPassword()));
                                DaemonCredentialsManager.setCredentials(BNativeUserTable.this.session, (BICredentials)newCredentials);
                            }
                            boolean isFips = BNativeUserTable.this.fipsModeCheckBox != null && BNativeUserTable.this.fipsModeCheckBox.getSelected();
                            FipsOptionsHelper.getInstance().updateUserCookie(account.getAccountName(), isFips, BNativeUserTable.this.session);
                        }
                        account.setOldPassword(null);
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class DeleteUserCommand
    extends Command {
        public DeleteUserCommand() {
            super((BWidget)BNativeUserTable.this, lex, "UserManager.DeleteUserCommand");
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BNativeUserTable.this, (String)lex.getText("UserManager.DeleteUserCommand.confirmTitle"), (Object)lex.getText("UserManager.DeleteUserCommand.confirmMessage"))) {
                    if (BNativeUserTable.this.getSelection().isEmpty()) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)lex.getText("UserManager.DeleteUserCommand.canNotDeleteNoUser"));
                        BNativeUserTable.this.getUserModel().getSelection().deselectAll();
                        CommandArtifact commandArtifact = null;
                        return commandArtifact;
                    }
                    int[] selRows = BNativeUserTable.this.getSelection().getRows();
                    BUsernameAndPassword sessionCred = (BUsernameAndPassword)BNativeUserTable.this.session.getCredentials();
                    String userName = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
                    for (int selRow = selRows.length - 1; selRow >= 0; --selRow) {
                        String selectedName = BNativeUserTable.this.getUserModel().getUser(selRows[selRow]).getAccountName();
                        if (selectedName.equals(userName) || selectedName.equals(replacementAccountUserName)) {
                            String lexText = selectedName.equals(userName) ? "UserManager.DeleteUserCommand.canNotDeleteCurrentUser" : "UserManager.DeleteUserCommand.canNotDeleteReplacementUser";
                            BDialog.error((BWidget)BNativeUserTable.this, (Object)lex.getText(lexText, new Object[]{userName}));
                            CommandArtifact commandArtifact = null;
                            return commandArtifact;
                        }
                        if (BNativeUserTable.this.forceChangeUserList != null) {
                            BNativeUserTable.this.forceChangeUserList.remove(selectedName);
                        }
                        if (!BNativeUserTable.this.commitChanges) {
                            BNativeUserTable.this.getUserModel().remove(selRows[selRow]);
                            BNativeUserTable.this.getUserModel().updateTable(true);
                            continue;
                        }
                        UserAccount user = BNativeUserTable.this.getUserModel().getUser(selRows[selRow]);
                        DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(BNativeUserTable.this.group, user);
                        DeleteUserMessage deleteUserMessage = new DeleteUserMessage(user);
                        if (!BNativeUserTable.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.session, (XmlResponseMessage)deleteMemberMessage) || !BNativeUserTable.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.session, (XmlResponseMessage)deleteUserMessage)) continue;
                        FipsOptionsHelper.getInstance().updateUserCookie(user.getAccountName(), false, BNativeUserTable.this.session);
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                if (BNativeUserTable.this.commitChanges) {
                    try {
                        BNativeUserTable.this.getUserModel().load();
                    }
                    catch (Exception exception) {}
                }
                BNativeUserTable.this.getUserModel().getSelection().deselectAll();
            }
            return null;
        }
    }

    private class AddUserCommand
    extends Command {
        public AddUserCommand() {
            super((BWidget)BNativeUserTable.this, lex, "UserManager.AddUserCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            try {
                if (BNativeUserTable.this.getModel().getRowCount() >= 20) {
                    BDialog.error((BWidget)BNativeUserTable.this, (Object)lex.getText("UserManager.error.tooManyUsers", new Object[]{20}));
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                UserAccount accountToAdd = BAddUserDialog.open(BNativeUserTable.this, lex.getText("UserManager.AddUserCommand.dlgTitle"));
                if (accountToAdd != null) {
                    if (!BNativeUserTable.this.commitChanges) {
                        BNativeUserTable.this.getUserModel().add(accountToAdd);
                        BNativeUserTable.this.getUserModel().updateTable(true);
                    } else {
                        AddUserMessage addUserMessage = new AddUserMessage(accountToAdd);
                        addUserMessage.setSharedKey(BNativeUserTable.this.session.generateSharedSecretKey("nativeUserTable_add"));
                        if (BNativeUserTable.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.session, (XmlResponseMessage)addUserMessage)) {
                            accountToAdd.setPlatformIdentifier(addUserMessage.getResponse().get("id"));
                            AddMemberMessage addMemberMessage = new AddMemberMessage(BNativeUserTable.this.group, accountToAdd);
                            if (BNativeUserTable.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.session, (XmlResponseMessage)addMemberMessage)) {
                                boolean isFips = BNativeUserTable.this.fipsModeCheckBox != null && BNativeUserTable.this.fipsModeCheckBox.getSelected();
                                FipsOptionsHelper.getInstance().updateUserCookie(accountToAdd.getAccountName(), isFips, BNativeUserTable.this.session);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                if (BNativeUserTable.this.commitChanges) {
                    try {
                        BNativeUserTable.this.getUserModel().load();
                    }
                    catch (Exception exception) {}
                }
                BNativeUserTable.this.getUserModel().getSelection().deselectAll();
            }
            return null;
        }
    }

    private class UserController
    extends TableController {
        private UserController() {
        }

        public void focusGained(BFocusEvent event) {
        }

        protected final void backgroundPressed(BMouseEvent event) {
            super.backgroundPressed(event);
            BNativeUserTable.this.deleteUserCommand.setEnabled(false);
            BNativeUserTable.this.changePasswordCommand.setEnabled(false);
        }

        protected void checkSelection(BMouseEvent event, int row) {
            super.checkSelection(event, row);
            BNativeUserTable.this.addUserCommand.setEnabled(BNativeUserTable.this.getUserModel().canModify && this.getTable().getModel().getRowCount() < 20);
            BNativeUserTable.this.changePasswordCommand.setEnabled(BNativeUserTable.this.getUserModel().canModify && this.getTable().getSelection().getRowCount() == 1 && !BNativeUserTable.this.getUserModel().getUser(this.getTable().getSelection().getAnchor()).getAccountName().equalsIgnoreCase(defaultAccountUserName));
            if (!BNativeUserTable.this.getUserModel().canModify || this.getTable().getModel().getRowCount() <= 1) {
                BNativeUserTable.this.deleteUserCommand.setEnabled(false);
            } else {
                int[] selectedRows = this.getTable().getSelection().getRows();
                boolean enable = true;
                BUsernameAndPassword sessionCred = (BUsernameAndPassword)BNativeUserTable.this.session.getCredentials();
                String activeUserName = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
                for (int selectedRow : selectedRows) {
                    String tableName = BNativeUserTable.this.getUserModel().getUser(selectedRow).getAccountName();
                    if (tableName.equals(activeUserName)) {
                        enable = false;
                        break;
                    }
                    if (!tableName.equals(replacementAccountUserName)) continue;
                    enable = false;
                    break;
                }
                BNativeUserTable.this.deleteUserCommand.setEnabled(enable);
            }
        }
    }

    public class UserModel
    extends TableModel {
        private final List<UserAccount> rows = new ArrayList<UserAccount>();
        public boolean canModify = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() throws Exception {
            XElem[] remoteGroups;
            XElem authenticationInfo = XParser.make((InputStream)BNativeUserTable.this.session.getInputStream((DaemonMessage)new AuthenticationInfoMessage())).parse();
            XElem authElement = authenticationInfo.elem("auth");
            authReadonly = authElement.getb("readonly", false);
            assert (authElement != null);
            XElem adminGroupElement = authElement.elem("admingroup");
            assert (adminGroupElement != null);
            BNativeUserTable.this.group = new GroupAccount(adminGroupElement.get("name"), adminGroupElement.get("id", null));
            XElem userElement = authElement.elem("user");
            if (userElement != null) {
                defaultAccountUserName = userElement.get("name", null);
                defaultUserPresent = userElement.getb("default", false);
            }
            this.canModify = BNativeUserTable.this.session.getHostProperties().hasFullAccess() && !authReadonly;
            XElem accountInfo = XParser.make((InputStream)BNativeUserTable.this.session.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
            for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                if (!currentGroup.get("name").equals(BNativeUserTable.this.group.getFullyQualifiedName())) continue;
                this.canModify &= currentGroup.getb("canModify", true);
                XElem[] adminUsers = currentGroup.elems("user");
                List<UserAccount> list = this.rows;
                synchronized (list) {
                    this.rows.clear();
                    for (XElem adminUser : adminUsers) {
                        this.rows.add(new UserAccount(adminUser.get("name"), adminUser.get("id", null), adminUser.get("description"), null));
                    }
                }
                this.updateTable(true);
                break;
            }
            BNativeUserTable.this.addUserCommand.setEnabled(this.canModify && this.getRowCount() < 20);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            List<UserAccount> list = this.rows;
            synchronized (list) {
                return this.rows.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserAccount getUser(int idx) {
            List<UserAccount> list = this.rows;
            synchronized (list) {
                return this.rows.get(idx);
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("UserManager.utable.col.name");
                }
                case 1: {
                    return lex.getText("UserManager.utable.col.comment");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getUser(row).getAccountName();
                }
                case 1: {
                    return this.getUser(row).getComment();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int row) {
            List<UserAccount> list = this.rows;
            synchronized (list) {
                return this.rows.remove(row);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, UserAccount user) {
            List<UserAccount> list = this.rows;
            synchronized (list) {
                this.rows.add(index, user);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(UserAccount user) {
            List<UserAccount> list = this.rows;
            synchronized (list) {
                this.rows.add(user);
            }
        }
    }

    public class UserCellRenderer
    extends TableCellRenderer {
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (defaultUserPresent && ((String)this.getModel().getRowValues(cell.row)[0]).equalsIgnoreCase(defaultAccountUserName)) {
                return BBrush.makeSolid((BColor)BColor.red);
            }
            if (BNativeUserTable.this.forceChangeUsers && BNativeUserTable.this.forceChangeUserList.contains((String)this.getModel().getRowValues(cell.row)[0])) {
                return BBrush.makeSolid((BColor)BColor.orange);
            }
            return super.getBackground(cell);
        }
    }
}

