/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platform.daemon.message.AuthenticateUserMessage;
import com.tridium.platform.daemon.message.CheckUserMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.ui.util.LabelUtil;
import java.io.InputStream;
import java.security.AccessController;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BChangePasswordDialog
extends BDialog {
    public static final Action okButtonPressed = BChangePasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BChangePasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BChangePasswordDialog.class);
    BNativeUserTable userTable;
    UserAccount userAccount;
    BWbFieldEditor oldPasswordFE;
    BWbFieldEditor newPasswordFE1;
    BWbFieldEditor newPasswordFE2;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    protected BButton okButton;
    protected BButton cancelButton;
    private UserAccount response = null;

    public void okButtonPressed(BWidgetEvent event) {
        this.invoke(okButtonPressed, (BValue)event, null);
    }

    public void cancelButtonPressed(BWidgetEvent event) {
        this.invoke(cancelButtonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static UserAccount open(BNativeUserTable table, UserAccount account, String title) {
        BChangePasswordDialog dialog = new BChangePasswordDialog(table, account, title);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getUserAccount();
    }

    private BChangePasswordDialog(BNativeUserTable table, UserAccount account, String title) {
        super((BWidget)table, title, true);
        this.userTable = table;
        this.userAccount = account;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        this.okButton.setEnabled(true);
    }

    private BWidget buildDialog() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane);
    }

    private BWidget buildBody() {
        BGridPane grid = new BGridPane(2);
        this.oldPasswordFE = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
        this.newPasswordFE1 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
        this.newPasswordFE2 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.name"), (BWidget)new BLabel(this.userAccount.getAccountName()));
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.oldpassword"), (BWidget)this.oldPasswordFE);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.newpassword"), (BWidget)this.newPasswordFE1);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.newpassword2"), (BWidget)this.newPasswordFE2);
        return grid;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.okButton.setPreferredSize(50.0, this.okButton.getPreferredHeight());
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.cancelButton.setPreferredSize(50.0, this.cancelButton.getPreferredHeight());
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public UserAccount getUserAccount() {
        return this.response;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        boolean passwordValid;
        BPassword npw2;
        BPassword npw1;
        BPassword opw;
        block11: {
            block10: {
                opw = (BPassword)this.oldPasswordFE.saveValue();
                npw1 = (BPassword)this.newPasswordFE1.saveValue();
                npw2 = (BPassword)this.newPasswordFE2.saveValue();
                if (opw == null) break block10;
                if (AccessController.doPrivileged(() -> ((BPassword)opw).getValue()).trim().length() == 0 || npw1 == null) break block10;
                if (AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()).trim().length() == 0 || npw2 == null) break block10;
                if (AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()).trim().length() != 0) break block11;
            }
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.fieldRequired"));
            return;
        }
        BPasswordStrength passwordStrength = FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.userTable.fipsModeSelected(), this.userTable.session);
        if (!BNativeUserTable.validatePassword((BWidget)this, npw1, passwordStrength)) {
            return;
        }
        if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()))) {
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.passwordMismatch"));
            return;
        }
        if (this.userAccount.getPassword() != null) {
            passwordValid = SecurityUtil.equals((String)LegacyStorageUtil.decode((String)this.userAccount.getPassword()), (String)AccessController.doPrivileged(() -> ((BPassword)opw).getValue()));
        } else {
            AuthenticateUserMessage authUserMessage = new AuthenticateUserMessage(this.userAccount.getFullyQualifiedName(), opw, this.userTable.session.generateSharedSecretKey("changePass_authn"));
            XElem userAuthInfo = XParser.make((InputStream)this.userTable.session.getInputStream((DaemonMessage)authUserMessage, "text/xml")).parse();
            boolean bl = passwordValid = userAuthInfo.elems("domain").length != 0;
        }
        if (!passwordValid) {
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.badCredentials"));
            return;
        }
        UserAccount checkUser = new UserAccount(this.userAccount.getFullyQualifiedName(), null, null, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (int)0));
        if (!BNativeUserTable.checkStatus(null, this.userTable.session, (XmlResponseMessage)new CheckUserMessage(checkUser, this.userTable.session.generateSharedSecretKey("changePassword_check")))) {
            BDialog.error((BWidget)this, (Object)lex.getText("UserManager.error.invalidUserPasswordDefault"));
            return;
        }
        this.userAccount.setPassword(LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (int)0));
        if (this.userAccount.getOldPassword() == null) {
            this.userAccount.setOldPassword(LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)opw).getValue()), (int)0));
        }
        this.response = this.userAccount;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.response = null;
        this.close();
    }
}

