/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.nre.auth.UserAccount;
import com.tridium.platDaemon.ui.HostNotFipsReadyItem;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.ui.options.BFipsOptions;
import javax.baja.user.BPasswordStrength;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class FipsOptionsHelper {
    private static final byte[] COOKIE_CONTENT = new byte[0];
    private static final long COOKIE_LENGTH = 0L;
    private static final String USER_COOKIE_PREFIX = "user_";
    private static final String SYSTEM_PASSPHRASE_COOKIE_NAME = "system_passphrase";
    private static final Logger log = Logger.getLogger("platDaemon.fipshelper");
    private static BFipsOptions fipsOptions = BFipsOptions.getOptions();
    private static final FipsOptionsHelper fipsOptionsHelper = new FipsOptionsHelper();

    protected FipsOptionsHelper() {
    }

    public static FipsOptionsHelper getInstance() {
        return fipsOptionsHelper;
    }

    public boolean showFipsOption(BDaemonSession daemonSession) {
        boolean isHostFips = false;
        boolean isHostNpsdk = false;
        if (daemonSession != null) {
            isHostFips = daemonSession.getHostProperties().isFips();
            isHostNpsdk = daemonSession.getHostProperties().getIsNpsdk();
        }
        return isHostFips || fipsOptions.getShowFipsOptions() && !isHostNpsdk;
    }

    public boolean checkFipsOption(BDaemonSession daemonSession) {
        boolean isHostFips = false;
        if (daemonSession != null) {
            isHostFips = daemonSession.getHostProperties().isFips();
        }
        return isHostFips || fipsOptions.getCheckFipsOptionsByDefault();
    }

    public boolean fipsOptionReadOnly(BDaemonSession daemonSession) {
        return daemonSession != null && daemonSession.getHostProperties().isFips();
    }

    public BPasswordStrength getPasswordStrengthRequirements(boolean fipsModeSelected, BDaemonSession daemonSession) {
        if (fipsModeSelected) {
            return BPasswordStrength.FIPS_1;
        }
        return new BPasswordStrength(daemonSession.getPlatformPasswordStrengthRequirements());
    }

    public void updateUserCookie(String username, boolean isFipsSelected, BDaemonSession daemonSession) throws ConnectException {
        this.updateCookie(USER_COOKIE_PREFIX + username, isFipsSelected, daemonSession);
    }

    public void updateSystemPassphraseCookie(boolean isFipsSelected, BDaemonSession daemonSession) throws ConnectException {
        this.updateCookie(SYSTEM_PASSPHRASE_COOKIE_NAME, isFipsSelected, daemonSession);
    }

    private void updateCookie(String cookieName, boolean isFipsSelected, BDaemonSession daemonSession) throws ConnectException {
        BDefaultDaemonFileSpace fileSpace = daemonSession.getFileSpace();
        FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)fileSpace);
        FilePath path = SystemFilePaths.getFipsCookieDirPath().merge(new FilePath(cookieName));
        Object element = isFipsSelected ? new FileTransferMessageElement(path, (InputStream)new ByteArrayInputStream(COOKIE_CONTENT), 0L, (BDaemonFileSpace)fileSpace) : new DeleteFileTransferMessageElement(path, (BDaemonFileSpace)fileSpace);
        message.addElement((FileTransferMessageElement)element);
        DaemonFileUtil.transfer((BDaemonSession)daemonSession, (FileTransferMessage)message, null);
    }

    public boolean isHostFipsReady(BDaemonSession daemonSession, Consumer<HostNotFipsReadyItem> errorConsumer) {
        if (daemonSession.getHostProperties().isFips()) {
            return true;
        }
        if (daemonSession.getHostProperties().getIsNpsdk()) {
            errorConsumer.accept(new HostNotFipsReadyItem.NPSDKNotFipsReady());
            return false;
        }
        boolean hostIsFipsReady = true;
        try {
            HashSet<String> cookies = new HashSet<String>();
            InputStream cookieStream = daemonSession.getInputStream((DaemonMessage)new GetDirectoryMessage(SystemFilePaths.getFipsCookieDirPath(), (BDaemonFileSpace)daemonSession.getFileSpace()));
            if (cookieStream != null) {
                XElem cookieInfo = XParser.make((InputStream)cookieStream).parse();
                for (XElem cookie : cookieInfo.elems("file")) {
                    cookies.add(cookie.get("name"));
                }
            }
            if (!cookies.contains(SYSTEM_PASSPHRASE_COOKIE_NAME)) {
                hostIsFipsReady = false;
                errorConsumer.accept(new HostNotFipsReadyItem.SystemPassphraseNotFipsReady());
            }
            if (daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                XElem[] remoteGroups;
                ArrayList<String> userList = new ArrayList<String>();
                XElem accountInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                    XElem[] users;
                    for (XElem user : users = currentGroup.elems("user")) {
                        String username = user.get("name");
                        UserAccount account = new UserAccount(username, null);
                        String cookieName = USER_COOKIE_PREFIX + account.getAccountName();
                        if (cookies.contains(cookieName)) continue;
                        userList.add(account.getAccountName());
                    }
                }
                if (!userList.isEmpty()) {
                    hostIsFipsReady = false;
                    errorConsumer.accept(new HostNotFipsReadyItem.UsersNotFipsReady(userList));
                }
            } else {
                hostIsFipsReady = false;
                errorConsumer.accept(new HostNotFipsReadyItem.NativeAccountManagementNotSupported());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred when determining FIPS support state", e);
            hostIsFipsReady = false;
            errorConsumer.accept(new HostNotFipsReadyItem.HostNotFipsReadyExceptionItem(e));
        }
        return hostIsFipsReady;
    }
}

