/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.BModuleView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.theme.Theme;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platDaemon:ModuleInfo"})})
public class BModuleInfoView
extends BWbView
implements BIExportableTableView {
    public static final Type TYPE = Sys.loadType(BModuleInfoView.class);
    private BTable table;
    private static final int COL_NAME = 0;
    private static final int COL_VERSION = 1;
    private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
    private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
    private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");
    private static final BImage UNKNOWN = BImage.make((String)"module://icons/x16/questionMark.png");
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");

    public Type getType() {
        return TYPE;
    }

    public BTable getExportTable() {
        return this.table;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        ModuleInfoTableModel model = new ModuleInfoTableModel();
        model.load();
        this.table = new BTable((TableModel)model, (TableController)new ModuleInfoTableController());
        this.table.setCellRenderer((TableCellRenderer)new ModuleInfoCellRenderer());
        this.setContent((BWidget)BTitlePane.makePane((String)UiLexicon.bajaui().getText("modules"), (BTable)this.table));
    }

    private static class ModuleInfoRowComparator
    implements Comparator<ModuleInfoTableRow> {
        private final int sortCol;
        private final boolean ascending;

        public ModuleInfoRowComparator(int sortCol, boolean ascending) {
            this.sortCol = sortCol;
            this.ascending = ascending;
        }

        @Override
        public int compare(ModuleInfoTableRow o1, ModuleInfoTableRow o2) {
            int result = o1.getValueAt(this.sortCol).toString().compareToIgnoreCase(o2.getValueAt(this.sortCol).toString());
            if (result == 0 && this.sortCol != 0) {
                result = o1.getValueAt(0).toString().compareToIgnoreCase(o2.getValueAt(0).toString());
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }
    }

    private static class ModuleInfoCellRenderer
    extends TableCellRenderer {
        private ModuleInfoCellRenderer() {
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String s = this.getCellText(cell);
            double w = Theme.table().getCellFont().width(s) + 12.0;
            if (((ModuleInfoTableModel)this.getTable().getModel()).getCellIcon(cell.row, cell.column) != null) {
                w += 20.0;
            }
            return w;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            ModuleInfoTableModel model = (ModuleInfoTableModel)this.getTable().getModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            BImage icon = model.getCellIcon(cell.row, cell.column);
            if (icon != null) {
                g.drawImage(icon, x, y);
                x += 20.0;
            }
            String s = this.getCellText(cell);
            BFont font = Theme.table().getCellFont();
            switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(font);
            g.drawString(s, x, font.getAscent() + 2.0);
        }
    }

    private static class ModuleInfoTableRow {
        private final ModuleInfoTableModel model;
        private final BModuleInstallable installable;
        private BImage statusIcon = null;

        private ModuleInfoTableRow(BModuleInstallable installable, ModuleInfoTableModel model) {
            this.installable = installable;
            this.model = model;
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.installable.getInstallableName();
                }
                case 1: {
                    return this.installable.getVersion();
                }
            }
            return "?";
        }

        public BModuleInstallable getInstallable() {
            return this.installable;
        }

        public BImage getStatusIcon() {
            if (this.statusIcon != null) {
                return this.statusIcon;
            }
            BModulePart part = this.installable.getModulePart();
            List statuses = part.getSignatureStatus(this.model.getCertValidator());
            if (statuses.contains(ModuleSignatureStatusEnum.UNKNOWN)) {
                this.statusIcon = UNKNOWN;
            } else if (statuses.contains(ModuleSignatureStatusEnum.OK)) {
                this.statusIcon = SECURITY_HIGH;
            } else {
                this.statusIcon = SECURITY_MEDIUM;
                for (ModuleSignatureStatusEnum status : statuses) {
                    if (status.isAcceptable(Nre.getModuleVerificationMode())) continue;
                    this.statusIcon = SECURITY_LOW;
                }
            }
            return this.statusIcon;
        }
    }

    private static class ModuleInfoTableModel
    extends TableModel {
        private ModuleInfoTableRow[] rows;
        private CertificateChainValidator certValidator;

        private ModuleInfoTableModel() {
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEX.getText("ModuleInfoView.column.name");
                }
                case 1: {
                    return LEX.getText("ModuleInfoView.column.version");
                }
            }
            return "?";
        }

        public Object getSubject(int row) {
            return this.rows[row];
        }

        public Object getValueAt(int row, int col) {
            return this.rows[row].getValueAt(col);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            ModuleInfoRowComparator comparator = new ModuleInfoRowComparator(col, ascending);
            Arrays.sort(this.rows, comparator);
        }

        public ModuleInfoTableRow getRowAt(int row) {
            return this.rows[row];
        }

        public BImage getCellIcon(int row, int col) {
            ModuleInfoTableRow tableRow = this.rows[row];
            if (col == 1) {
                return tableRow.getStatusIcon();
            }
            return null;
        }

        public CertificateChainValidator getCertValidator() {
            return this.certValidator;
        }

        public void load() {
            ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
            CoreCryptoManager cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)provider);
            this.certValidator = CertificateChainValidator.make((ICoreCryptoManager)cryptoManager);
            JarSignatureRegistry registry = Nre.getJarSignatureRegistry();
            registry.checkReload();
            ModuleInfo[] modules = Nre.getRegistryManager().getModules();
            this.rows = new ModuleInfoTableRow[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                BModuleInstallable inst = BModuleInstallable.make((NModuleInfo)((NModuleInfo)modules[i]));
                inst.getModulePart().initCodeSigners(registry);
                this.rows[i] = new ModuleInfoTableRow(inst, this);
            }
            registry.save();
        }
    }

    private static class DetailCommand
    extends Command {
        private final ModuleInfoTableRow row;
        private final CertificateChainValidator certValidator;
        private static final int DIALOG_WIDTH = 500;
        private static final int DIALOG_HEIGHT = 350;

        public DetailCommand(ModuleInfoTableRow row, CertificateChainValidator certValidator, BWidget owner) {
            super(owner, TYPE.getModule(), "ModuleInfoView.command.details");
            this.row = row;
            this.certValidator = certValidator;
        }

        public CommandArtifact doInvoke() {
            try {
                BModuleInstallable installable = this.row.getInstallable();
                BModuleView view = new BModuleView(this.certValidator, Nre.getModuleVerificationMode());
                view.loadValue((BObject)installable);
                BConstrainedPane dlgContent = new BConstrainedPane((BWidget)view);
                dlgContent.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("ModuleInfoView.command.details.dlgTitle"), (Object)dlgContent);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private static class ModuleInfoTableController
    extends TableController {
        private ModuleInfoTableController() {
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            ModuleInfoTableModel model = (ModuleInfoTableModel)this.getTable().getModel();
            new DetailCommand(model.getRowAt(row), model.getCertValidator(), (BWidget)this.getTable()).invoke();
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            ModuleInfoTableModel model = (ModuleInfoTableModel)this.getTable().getModel();
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand(model.getRowAt(row), model.getCertValidator(), (BWidget)this.getTable())), null);
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }
}

