/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallableFilter;
import com.tridium.install.PartSpec;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.LabelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import javax.baja.gx.BImage;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbView;

public class BDistributionView
extends BWbView {
    public static final Type TYPE = Sys.loadType(BDistributionView.class);
    private BDistribution dist;
    private boolean deactivating = false;
    private BLabel fileNameLabel;
    private BLabel fileSizeLabel;
    private BLabel distNameLabel;
    private BLabel descLabel;
    private BLabel versionLabel;
    private BGridPane depsGrid;
    private BGridPane exclGrid;
    private BGridPane partsGrid;
    private BScrollPane topScroll;
    private BLabel notesLabel;
    private BLabel releaseDateLabel;
    private Map<PartSpec, UnmeetableDependency> unmeetableDepByPartSpec = new HashMap<PartSpec, UnmeetableDependency>();
    private ArrayList<BDependency> failedExclusionsList = new ArrayList();
    private static final int WORD_WRAP_WIDTH = 500;

    public Type getType() {
        return TYPE;
    }

    public BDistributionView() {
        this(null, null);
    }

    public BDistributionView(UnmeetableDependency[] unmeetableDeps, Map<BDependency, BPart> failedExclusions) {
        if (unmeetableDeps != null) {
            for (UnmeetableDependency unmeetableDep : unmeetableDeps) {
                this.unmeetableDepByPartSpec.put(unmeetableDep.dependency.getPartSpec(), unmeetableDep);
            }
        }
        if (failedExclusions != null) {
            this.failedExclusionsList.addAll(failedExclusions.keySet());
        }
        BGridPane outerGrid = new BGridPane(1);
        outerGrid.setStretchColumn(0);
        outerGrid.setColumnAlign(BHalign.fill);
        outerGrid.setValign(BValign.top);
        BGridPane ledger = new BGridPane(2);
        ledger.setStretchColumn(1);
        ledger.setValign(BValign.top);
        this.fileNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.fileName"), (BWidget)this.fileNameLabel);
        this.fileSizeLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.fileSize"), (BWidget)this.fileSizeLabel);
        this.distNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.distName"), (BWidget)this.distNameLabel);
        this.descLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.desc"), (BWidget)this.descLabel);
        this.versionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.version"), (BWidget)this.versionLabel);
        this.releaseDateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.releaseDate"), (BWidget)this.releaseDateLabel);
        outerGrid.add(null, (BValue)ledger);
        this.partsGrid = new BGridPane(1);
        outerGrid.add(null, (BValue)new BBorderPane((BWidget)this.partsGrid, LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.partsHeader"), (boolean)true)));
        this.partsGrid.setHalign(BHalign.left);
        this.depsGrid = new BGridPane(1);
        outerGrid.add(null, (BValue)new BBorderPane((BWidget)this.depsGrid, LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.depsHeader"), (boolean)true)));
        this.depsGrid.setHalign(BHalign.left);
        this.exclGrid = new BGridPane(1);
        outerGrid.add(null, (BValue)new BBorderPane((BWidget)this.exclGrid, LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.exclHeader"), (boolean)true)));
        this.exclGrid.setHalign(BHalign.left);
        this.notesLabel = new BLabel();
        this.notesLabel.setHalign(BHalign.left);
        this.topScroll = new BScrollPane((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)this.notesLabel, null, null, (BWidget)outerGrid), 4.0, 4.0, 4.0, 4.0));
        this.topScroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.topScroll.setViewportBackground(Theme.scrollPane().getControlBackground());
    }

    protected void doLoadValue(BObject value, Context contextIn) throws Exception {
        this.dist = value instanceof BDistributionFile ? ((BDistributionFile)value).makeDistribution(false) : (BDistribution)value;
        this.fileNameLabel.setText(this.dist.getInstallableFileName());
        this.fileSizeLabel.setText(DaemonFileUtil.fileSize((long)this.dist.getInstallableFileSize()));
        this.distNameLabel.setText(this.dist.getInstallableName());
        this.descLabel.setText(this.dist.getDescription());
        this.versionLabel.setText(this.dist.getVersion().toString());
        Optional releaseDateLong = this.dist.getReleaseDate();
        if (releaseDateLong.isPresent()) {
            this.releaseDateLabel.setText(LicenseUtil.formatDate((long)((Long)releaseDateLong.get())));
        } else {
            this.releaseDateLabel.setText(LexiconText.make((String)"platDaemon", (String)"DistributionFileView.releaseDate.none").get(contextIn, "none"));
        }
        HashMap<PartSpec, BDependency> exclusionByPartSpec = new HashMap<PartSpec, BDependency>();
        for (BDependency excl : this.dist.getAllExclusions()) {
            exclusionByPartSpec.put(excl.getPartSpec(), excl);
        }
        this.depsGrid.removeAll();
        UnaryOperator highlight = label -> {
            StyleUtils.addStyleClass((IStylable)label, (String)"error");
            return label;
        };
        TreeMap<String, Object> depLabels = new TreeMap<String, Object>();
        boolean anyUnmeetable = false;
        ArrayList<InstallableFilter> failedFilters = new ArrayList<InstallableFilter>();
        for (BDependency dep : this.dist.getAllDependencies()) {
            int index;
            StringBuilder dependencyText;
            Context cx;
            UnmeetableDependency unmeetable = this.unmeetableDepByPartSpec.get(dep.getPartSpec());
            BDependency exclusion = (BDependency)exclusionByPartSpec.get(dep.getPartSpec());
            if (exclusion == null && dep.getPartType().equals(BNrePart.TYPE) && dep.getPartName().startsWith("nre-core")) {
                PartSpec patternPartSpec = new PartSpec("nre-core-*", dep.getPartTypeSpec());
                exclusion = (BDependency)exclusionByPartSpec.get(patternPartSpec);
            }
            Object object = cx = exclusion == null ? contextIn : new BasicContext(contextIn, BFacets.make((String)"exclusion", (String)exclusion.encodeToString()));
            if (unmeetable == null) {
                dependencyText = new StringBuilder(dep.toString(cx));
                depLabels.put(dep.getPartName(), new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)dep.getPartType())), dependencyText.toString()));
                continue;
            }
            InstallableFilter filter = null;
            if (unmeetable.failedFilter != null) {
                filter = unmeetable.failedFilter;
            }
            if ((index = failedFilters.indexOf(filter)) < 0) {
                failedFilters.add(filter);
                index = failedFilters.indexOf(filter);
            }
            dependencyText = new StringBuilder(unmeetable.toString(cx));
            for (int i = 0; i <= index; ++i) {
                dependencyText.append("*");
            }
            depLabels.put(dep.getPartName(), highlight.apply(new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)dep.getPartType())), dependencyText.toString())));
            anyUnmeetable = true;
        }
        depLabels.values().forEach(label -> this.depsGrid.add(null, (BValue)label));
        if (anyUnmeetable) {
            StringBuilder prefix = new StringBuilder();
            for (InstallableFilter filter : failedFilters) {
                prefix.append("*");
                if (filter instanceof SignedDistFilter) {
                    this.depsGrid.add(null, (BValue)highlight.apply(new BLabel(prefix + " " + this.getLexicon().getText("CommissioningWizard.dist.failedSignature"))));
                    continue;
                }
                if (filter instanceof DistLicenseFeatureFilter) {
                    String features = String.join((CharSequence)", ", ((DistLicenseFeatureFilter)filter).getSatisfyingFeatures());
                    BLabel missingFeatureLabel = new BLabel(prefix + " " + this.getLexicon().getText("CommissioningWizard.unavailableModules.missingFeature", new Object[]{features}));
                    missingFeatureLabel.setWordWrapEnabled(true, 500.0);
                    missingFeatureLabel.setHalign(BHalign.left);
                    this.depsGrid.add(null, (BValue)highlight.apply(missingFeatureLabel));
                    continue;
                }
                this.depsGrid.add(null, (BValue)highlight.apply(new BLabel(prefix + " " + this.getLexicon().getText("DistributionView.unmeetable.footer"))));
            }
        }
        this.exclGrid.removeAll();
        boolean platformExcluded = false;
        for (BDependency exclusion : exclusionByPartSpec.values()) {
            if (this.failedExclusionsList.contains(exclusion)) {
                platformExcluded = true;
                this.exclGrid.add(null, (BValue)highlight.apply(new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)exclusion.getPartType())), exclusion.toString() + "*")));
                continue;
            }
            this.exclGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)exclusion.getPartType())), exclusion.toString()));
        }
        if (platformExcluded) {
            this.exclGrid.add(null, (BValue)highlight.apply(new BLabel(this.getLexicon().getText("DistributionView.excl.footer"))));
        }
        this.partsGrid.removeAll();
        boolean hasParts = false;
        SlotCursor c = this.dist.getParts().getProperties();
        while (c.next()) {
            BPart part = (BPart)c.get();
            this.partsGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BPart.getPartTypeIcon((Type)part.getType())), BVersion.formatNameVersion((BPart)part, (Context)contextIn)));
            hasParts = true;
        }
        if (hasParts) {
            this.notesLabel.setText(this.getLexicon().getText("DistributionView.notInstallableMessage"));
        } else {
            this.notesLabel.setText("");
        }
        this.setContent((BWidget)this.topScroll);
    }

    public void deactivated() {
        if (this.dist == null) {
            return;
        }
        if (this.deactivating) {
            return;
        }
        this.deactivating = true;
        super.deactivated();
        try {
            this.dist.close();
            this.dist = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deactivating = false;
    }
}

