/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BDaemonPlatformView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BDaemonPlatformView.class);
    private BGridPane grid;
    private BLabel hostNameLabel;
    private BLabel portLabel;
    private BLabel hostIdLabel;
    private BLabel osLabel;
    private BLabel archLabel;
    private BLabel moduleContentLabel;
    private BLabel vmLabel;
    private BGridPane modulesGrid;
    private BGridPane otherGrid;

    public Type getType() {
        return TYPE;
    }

    public BDaemonPlatformView() {
        this(new BGridPane(2));
        this.grid.setRowAlign(BValign.top);
        this.grid.setHalign(BHalign.left);
    }

    public BDaemonPlatformView(BGridPane grid) {
        this.grid = grid;
        this.hostNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.hostName"), (BWidget)this.hostNameLabel);
        this.portLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.port"), (BWidget)this.portLabel);
        this.hostIdLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.hostId"), (BWidget)this.hostIdLabel);
        this.osLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.os"), (BWidget)this.osLabel);
        this.archLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.arch"), (BWidget)this.archLabel);
        this.moduleContentLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.moduleContent"), (BWidget)this.moduleContentLabel);
        this.vmLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.vm"), (BWidget)this.vmLabel);
        this.modulesGrid = new BGridPane(1);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.modules"), (BWidget)this.modulesGrid);
        this.otherGrid = new BGridPane(1);
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonPlatformView.other"), (BWidget)this.otherGrid);
        BScrollPane scroll = new BScrollPane((BWidget)grid);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.never);
        this.setContent((BWidget)new BEdgePane(null, null, null, null, (BWidget)scroll));
    }

    protected void doLoadValue(BObject value, Context cx) {
        BDaemonPlatform platform = (BDaemonPlatform)value;
        platform.lease(7);
        BOsPart osPart = platform.getOsPart();
        String osText = osPart.getDescription();
        if (osText == null || osText.trim().length() == 0) {
            osText = osPart.getPartName();
        }
        this.hostNameLabel.setText(platform.getHostName());
        this.portLabel.setText("" + platform.getPort());
        this.hostIdLabel.setText(platform.getHostId());
        this.osLabel.setText(BVersion.formatNameVersion((String)osText, (BVersion)osPart.getVersion(), (Context)cx));
        this.archLabel.setText(platform.getArchPart().getPartName());
        this.moduleContentLabel.setText(String.valueOf(platform.getModuleContent()));
        BVmPart vmPart = platform.getVmPart();
        String vmText = vmPart == null ? this.getLexicon().getText("DaemonPlatformView.noneValue") : (vmPart.getUnspecified() ? this.getLexicon().getText("DaemonPlatformView.unspecifiedVm.label") : BVersion.formatNameVersion((String)vmPart.getPartName(), (BVersion)vmPart.getVersion(), (Context)cx));
        this.vmLabel.setText(vmText);
        platform.getModuleList().init();
        this.modulesGrid.removeAll();
        SlotCursor c = platform.getModuleList().getModules().getProperties();
        while (c.next()) {
            BModulePart mod = ((BModuleInstallable)c.get()).getModulePart();
            this.modulesGrid.add(null, (BValue)new BLabel(BVersion.formatNameVersion((BPart)mod, (Context)cx)));
        }
        Property[] otherProps = platform.getOtherParts().getPropertiesArray();
        this.otherGrid.removeAll();
        if (otherProps.length == 0) {
            this.otherGrid.add(null, (BValue)new BLabel(this.getLexicon().getText("DaemonPlatformView.noneValue")));
        } else {
            for (Property otherProp : otherProps) {
                BGenericPart part = (BGenericPart)platform.getOtherParts().get(otherProp);
                this.otherGrid.add(null, (BValue)new BLabel(BVersion.formatNameVersion((BPart)part, (Context)cx)));
            }
        }
    }

    public BGridPane getGridPane() {
        return this.grid;
    }
}

