/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonLogLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SaveLogLevelMessage;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.util.logging.Level;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraAction(name="handleListSelectionModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public class BDaemonLogSettingsView
extends BDaemonSessionView {
    public static final Action handleListSelectionModified = BDaemonLogSettingsView.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BDaemonLogSettingsView.class);
    public static BIcon ICON = BIcon.std((String)"daemon.png");
    private boolean isActivated = false;
    private BDaemonSurrogate surrogate;
    private final BGridPane logValueGrid;
    private final BLabel noticeLabel;
    private final BConstrainedPane constrainedPane;
    public static final double MIN_HEIGHT = 325.0;
    public static final double MAX_HEIGHT = 505.0;

    public void handleListSelectionModified(BWidgetEvent parameter) {
        this.invoke(handleListSelectionModified, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDaemonLogSettingsView() {
        this.autoRegisterForComponentEvents = false;
        this.logValueGrid = new BGridPane(2);
        this.logValueGrid.setHalign(BHalign.center);
        this.logValueGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonLogSettingsView.log"), (boolean)true));
        this.logValueGrid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonLogSettingsView.value"), (boolean)true));
        this.noticeLabel = new BLabel("", BHalign.center);
        this.noticeLabel.setFont(Theme.widget().getBoldText());
        this.noticeLabel.setForeground(BColor.red.toBrush());
        this.noticeLabel.setPadding(BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0));
        this.noticeLabel.setVisible(false);
        BGridPane viewPane = new BGridPane(1);
        viewPane.setHalign(BHalign.center);
        viewPane.add(null, (BValue)this.noticeLabel);
        viewPane.add(null, (BValue)this.logValueGrid);
        BScrollPane scrollPane = new BScrollPane((BWidget)viewPane);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.constrainedPane = new BConstrainedPane((BWidget)scrollPane);
        this.setContent((BWidget)this.constrainedPane);
    }

    public void activated() {
        super.activated();
        if (this.isRunning() && this.getCurrentValue() != null) {
            this.startRefreshTimer();
        }
        this.isActivated = true;
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
        this.isActivated = false;
    }

    @Override
    protected void doLoadSession(BDaemonSession value, Context cx) throws AuthenticationException {
        this.surrogate = this.getDaemonSurrogate(true);
        this.registerForComponentEvents((BComponent)this.surrogate, 3);
        if (this.surrogate.getLogForceLevel() != null) {
            String forceLevel = this.surrogate.getLogForceLevel();
            try {
                int intValue = Integer.parseInt(forceLevel);
                forceLevel = BDaemonLogLevel.make((int)intValue).getTag();
            }
            catch (NumberFormatException intValue) {
                // empty catch block
            }
            this.noticeLabel.setText(this.getLexicon().getText("DaemonLogSettingsView.forceLevel.notice", new Object[]{forceLevel}));
            this.noticeLabel.setVisible(true);
        }
        SlotCursor c = this.surrogate.getLogLevels().getProperties();
        while (c.next()) {
            String propName = c.property().getName();
            this.logValueGrid.add(propName + "lbl", (BValue)new BLabel(SlotPath.unescape((String)propName)));
            this.logValueGrid.add(propName, (BValue)this.makeDaemonLogLevelWidget((BObject)c.get()));
        }
        this.logValueGrid.computePreferredSize();
        double preferredWidth = this.logValueGrid.getPreferredWidth();
        if (this.logValueGrid.getPreferredHeight() > 505.0) {
            preferredWidth += 15.0;
        }
        this.constrainedPane.setMinSize(preferredWidth, 325.0);
        this.constrainedPane.setMaxSize(preferredWidth, 505.0);
        this.startRefreshTimer();
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.surrogate.getLogForceLevel() != null) {
            return value;
        }
        this.getDaemonSession().sendMessage((DaemonMessage)SaveLogLevelMessage.getInstance());
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleComponentEvent(BComponentEvent event) {
        if (this.loading) {
            return;
        }
        if (event.getSourceComponent() != this.surrogate.getLogLevels()) return;
        if (event.getId() == 0) {
            BListDropDown widget = (BListDropDown)this.logValueGrid.get(event.getSlotName());
            if (event.getValue() instanceof BDaemonLogLevel) {
                widget.setSelectedItem((Object)event.getValue());
                return;
            } else {
                if (!(event.getValue() instanceof BString)) throw new IllegalArgumentException("Unknown event value in logfilter handleComponentEvent:  " + event.getValue());
                widget.setSelectedItem((Object)Level.parse(((BString)event.getValue()).getString()));
            }
            return;
        } else if (event.getId() == 2) {
            this.logValueGrid.remove(event.getSlotName() + "lbl");
            this.logValueGrid.remove(event.getSlotName());
            return;
        } else {
            if (event.getId() != 1) return;
            this.logValueGrid.add(event.getSlotName() + "lbl", (BValue)new BLabel(SlotPath.unescape((String)event.getSlotName())));
            this.logValueGrid.add(event.getSlotName(), (BValue)this.makeDaemonLogLevelWidget((BObject)event.getValue()));
        }
    }

    @Override
    public void doRefresh() throws Exception {
        this.surrogate.poll();
    }

    public void doHandleListSelectionModified(BWidgetEvent evt) throws Exception {
        BListDropDown list = (BListDropDown)evt.getWidget();
        Object selectedValue = list.getSelectedItem();
        if (selectedValue instanceof BDaemonLogLevel) {
            this.surrogate.setLogLevel(SlotPath.unescape((String)list.getPropertyInParent().getName()), (BDaemonLogLevel)selectedValue, false);
        } else if (selectedValue instanceof Level) {
            this.surrogate.setLogLevel(SlotPath.unescape((String)list.getPropertyInParent().getName()), (Level)selectedValue, false);
        } else {
            throw new IllegalArgumentException("Unknown type in logfilter widget:  " + selectedValue);
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.isActivated && this.getCurrentValue() != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopRefreshTimer();
    }

    public BIcon getIcon() {
        return ICON;
    }

    private BListDropDown makeDaemonLogLevelWidget(BObject level) {
        BListDropDown result = new BListDropDown();
        DefaultListModel model = (DefaultListModel)result.getList().getModel();
        if (level instanceof BDaemonLogLevel) {
            int[] ordinals;
            for (int ordinal : ordinals = BDaemonLogLevel.make((int)0).getRange().getOrdinals()) {
                model.addItem(null, (Object)BDaemonLogLevel.make((int)ordinal));
            }
            result.getList().setSelectedItem((Object)level);
        } else if (level instanceof BString) {
            model.addItem(null, (Object)Level.ALL);
            model.addItem(null, (Object)Level.FINEST);
            model.addItem(null, (Object)Level.FINER);
            model.addItem(null, (Object)Level.FINE);
            model.addItem(null, (Object)Level.CONFIG);
            model.addItem(null, (Object)Level.INFO);
            model.addItem(null, (Object)Level.WARNING);
            model.addItem(null, (Object)Level.SEVERE);
            model.addItem(null, (Object)Level.OFF);
            result.getList().setSelectedItem((Object)Level.parse(((BString)level).getString()));
        }
        this.linkTo((BComponent)result, (Slot)BDropDown.valueModified, (Slot)handleListSelectionModified);
        this.linkTo((BComponent)result, (Slot)BDropDown.valueModified, (Slot)setModified);
        return result;
    }
}

