/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.file;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.fox.sys.file.FoxFileException;
import com.tridium.sys.transfer.RemoteTransferSpace;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BFoxFileSpace
extends BFileSpace
implements BIDirectory,
BIFoxProxySpace,
RemoteTransferSpace {
    public static final Type TYPE = Sys.loadType(BFoxFileSpace.class);
    private final BOrd ordInSession = BOrd.make((String)"file:");
    private BIFile[] roots;
    private BIFile stationHome;
    private BFileChannel channel;

    public Type getType() {
        return TYPE;
    }

    public BFoxFileSpace() {
        super("file", LexiconText.make((String)"fox", (String)"nav.fileSystem"));
    }

    protected BFoxFileSpace(String name, BFileChannel channel) {
        super(name);
        this.channel = channel;
    }

    public BFoxFileSpace(BFileChannel channel) {
        this();
        this.channel = channel;
    }

    @Override
    public void init(BFoxSession foxSession) {
    }

    @Override
    public void cleanup(BFoxSession foxSession) {
    }

    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        try {
            BFoxFileStore store = this.channel().makeDir(this, path);
            return new BDirectory((BIFileStore)store);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxFileException(path.toString(), e);
        }
    }

    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        try {
            BFoxFileStore store = this.channel().makeFile(this, path);
            return this.makeFile((BIFileStore)store);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxFileException(path.toString(), e);
        }
    }

    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        try {
            this.channel().move(this, from, to);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxFileException("" + from + "->" + to, e);
        }
    }

    public void delete(FilePath path, Context cx) throws IOException {
        try {
            this.channel().delete(this, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxFileException(path.toString(), e);
        }
    }

    public BIFile[] listFiles() {
        if (this.roots == null) {
            BFoxFileStore sysStore = new BFoxFileStore(this, new FilePath("!"));
            BDirectory sysHome = new BDirectory((BIFileStore)sysStore, LexiconText.make((String)"baja", (String)"nav.sysHome"));
            sysHome.setIcon(BIcon.std((String)"home.png"));
            BFoxFileStore userStore = new BFoxFileStore(this, new FilePath("~"));
            BDirectory userHome = new BDirectory((BIFileStore)sysStore, LexiconText.make((String)"baja", (String)"nav.userHome"));
            userHome.setIcon(BIcon.std((String)"home.png"));
            BFoxFileStore stationStore = new BFoxFileStore(this, new FilePath("^"));
            BDirectory stationHome = new BDirectory((BIFileStore)stationStore, LexiconText.make((String)"baja", (String)"nav.stationHome"));
            stationHome.setIcon(BIcon.std((String)"database.png"));
            ArrayList<BIFile> v = new ArrayList<BIFile>();
            this.addRoot(v, "~", "nav.userHome", "home.png");
            this.addRoot(v, "!", "nav.sysHome", "home.png");
            this.addRoot(v, "^", "nav.stationHome", "database.png");
            return v.toArray(new BIFile[v.size()]);
        }
        return this.roots;
    }

    private void addRoot(ArrayList<BIFile> v, String filePathStr, String lexKey, String icon) {
        try {
            FilePath filePath = new FilePath(filePathStr);
            BFoxFileStore store = this.channel().head(this, filePath);
            BDirectory dir = new BDirectory((BIFileStore)store, LexiconText.make((String)"baja", (String)lexKey));
            dir.setIcon(BIcon.std((String)icon));
            v.add((BIFile)dir);
        }
        catch (Exception e) {
            System.out.println("FoxFileSpace \"" + filePathStr + "\" unsupported");
        }
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    public BIFileStore findStore(FilePath path) {
        try {
            if (this.channel().getConnection().isConnected()) {
                return this.channel().head(this, path);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxFileException(path.toString(), e);
        }
    }

    public BIFile getChild(BIFile dir, String name) {
        return this.findFile(dir.getFilePath().merge(name));
    }

    public BIFile[] getChildren(BIFile dir) {
        return this.list(dir.getFilePath());
    }

    protected BIFile[] list(FilePath path) {
        try {
            BFoxFileStore[] stores = this.channel().list(this, path);
            BIFile[] files = new BIFile[stores.length];
            for (int i = 0; i < files.length; ++i) {
                files[i] = this.makeFile((BIFileStore)stores[i]);
            }
            return files;
        }
        catch (Exception e) {
            throw new FoxFileException(path.toString(), e);
        }
    }

    public TransferResult transfer(TransferStrategy strategy) throws Exception {
        return this.channel().transfer(strategy);
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BOrd getNavOrd() {
        BOrd navOrd = super.getNavOrd();
        return navOrd != null ? BOrd.make((String)(navOrd.toString() + "^")) : null;
    }

    public BINavNode getNavChild(String navName) {
        return this.getStationHome().getNavChild(navName);
    }

    public BINavNode[] getNavChildren() {
        return this.getStationHome().getNavChildren();
    }

    public BIFile getStationHome() {
        if (this.stationHome == null) {
            this.stationHome = this.findFile(new FilePath("^"));
        }
        return this.stationHome;
    }

    public BFoxSession getFoxSession() {
        if (this.channel != null) {
            return null;
        }
        for (BINavNode session = this.getNavParent(); session != null; session = session.getNavParent()) {
            if (!(session instanceof BFoxSession)) continue;
            return (BFoxSession)session;
        }
        return null;
    }

    public BFileChannel channel() {
        if (this.channel != null) {
            return this.channel;
        }
        return (BFileChannel)this.getFoxSession().getConnection().getChannels().get("file");
    }
}

