/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustAnchorConsumer;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BServerConnections;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BISecurityService;
import com.tridium.security.BSecurityInfo;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.engine.NClockTicket;
import com.tridium.sys.license.Brand;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CertAliasCasePropertyValidator;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BServerPort;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ServerTlsParameters;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.security.AuthenticationException;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.net.ServerSocketFactory;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="foxPort", type="BServerPort", defaultValue="new BServerPort(1911, IpProtocol.TCP)"), @NiagaraProperty(name="foxEnabled", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsPort", type="BServerPort", defaultValue="new BServerPort(4911, IpProtocol.TCP)"), @NiagaraProperty(name="foxsEnabled", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsOnly", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="cipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsCert", type="String", defaultValue="tridium", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="requestTimeout", type="BRelTime", defaultValue="BRelTime.make(Fox.requestTimeout)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1))")}), @NiagaraProperty(name="socketOptionTimeout", type="BRelTime", defaultValue="BRelTime.make(Fox.soTimeout)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1))")}), @NiagaraProperty(name="socketTcpNoDelay", type="boolean", defaultValue="true"), @NiagaraProperty(name="keepAliveInterval", type="BRelTime", defaultValue="BRelTime.make(Fox.keepAliveInterval)"), @NiagaraProperty(name="maxServerSessions", type="int", defaultValue="Fox.maxServerSessions"), @NiagaraProperty(name="multicastEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="enableAnnouncement", type="boolean", defaultValue="true"), @NiagaraProperty(name="multicastTimeToLive", type="int", defaultValue="Fox.multicastTimeToLive"), @NiagaraProperty(name="serverConnections", type="BServerConnections", defaultValue="new BServerConnections()"), @NiagaraProperty(name="traceSessionStates", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceReadFrame", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceWriteFrame", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceMulticast", type="boolean", defaultValue="false"), @NiagaraProperty(name="auditStationLoginEvents", type="boolean", defaultValue="false"), @NiagaraProperty(name="supportLegacyClients", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0, GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE)", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:FrozenEnumFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:FrozenEnumEditor\"), BFacets.SECURITY, BBoolean.TRUE)")})})
@NiagaraActions(value={@NiagaraAction(name="resetAllConnections", flags=128), @NiagaraAction(name="delayStationStarted", flags=4)})
public class BFoxService
extends BComponent
implements BIService,
BIRestrictedComponent,
BISecurityInfoSource,
TrustAnchorConsumer {
    public static final boolean SUPPORT_LEGACY_CLIENTS_BY_DEFAULT = true;
    private static final BFacets LEXICON_FACET = BFacets.make((String)"lexicon", (String)"fox");
    private static final BEnumRange GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{SlotPath.escape((String)"Use Default On Installed Platform"), SlotPath.escape((String)"No (Recommended)"), SlotPath.escape((String)"Yes")}, (int)3, (BFacets)LEXICON_FACET);
    private static final BEnumRange LOCAL_SUPPORT_LEGACY_CLIENTS_RANGE = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{SlotPath.escape((String)"Default: Yes (may change in future version)"), SlotPath.escape((String)"No (Recommended)"), SlotPath.escape((String)"Yes")}, (int)3, (BFacets)LEXICON_FACET);
    public static final Property foxPort = BFoxService.newProperty((int)0, (BValue)new BServerPort(1911, IpProtocol.TCP), null);
    public static final Property foxEnabled = BFoxService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property foxsPort = BFoxService.newProperty((int)0, (BValue)new BServerPort(4911, IpProtocol.TCP), null);
    public static final Property foxsEnabled = BFoxService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property foxsOnly = BFoxService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property foxsMinProtocol = BFoxService.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property cipherSuiteGroup = BFoxService.newProperty((int)0, (BValue)BTlsCipherSuiteGroup.recommended, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property foxsCert = BFoxService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Property requestTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.requestTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property socketOptionTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.soTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property socketTcpNoDelay = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property keepAliveInterval = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.keepAliveInterval), null);
    public static final Property maxServerSessions = BFoxService.newProperty((int)0, (int)Fox.maxServerSessions, null);
    public static final Property multicastEnabled = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property enableAnnouncement = BFoxService.newProperty((int)0, (boolean)true, null);
    public static final Property multicastTimeToLive = BFoxService.newProperty((int)0, (int)Fox.multicastTimeToLive, null);
    public static final Property serverConnections = BFoxService.newProperty((int)0, (BValue)new BServerConnections(), null);
    public static final Property traceSessionStates = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceReadFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceWriteFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property traceMulticast = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property auditStationLoginEvents = BFoxService.newProperty((int)0, (boolean)false, null);
    public static final Property supportLegacyClients = BFoxService.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:FrozenEnumFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:FrozenEnumEditor"), (String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Action resetAllConnections = BFoxService.newAction((int)128, null);
    public static final Action delayStationStarted = BFoxService.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BFoxService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private final ServiceListener serviceListener = new ServiceListener(){

        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BISecurityService.TYPE) && event.getId() == 0) {
                ((BISecurityService)event.getService().as(BISecurityService.class)).register((BISecurityInfoSource)BFoxService.this);
            }
        }
    };
    public static final Logger LOG = Logger.getLogger("fox");
    private static final BIcon ICON = BIcon.std((String)"fox.png");
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private final List<FoxServerConnectionListener> serverConnectionListeners = new ArrayList<FoxServerConnectionListener>();
    private Daemon daemon;
    private Clock.Ticket restartTicket;
    private String trustAnchorConsumerId;
    private CertAliasCasePropertyValidator validator = new CertAliasCasePropertyValidator(foxsCert.getName());

    public BServerPort getFoxPort() {
        return (BServerPort)this.get(foxPort);
    }

    public void setFoxPort(BServerPort v) {
        this.set(foxPort, (BValue)v, null);
    }

    public boolean getFoxEnabled() {
        return this.getBoolean(foxEnabled);
    }

    public void setFoxEnabled(boolean v) {
        this.setBoolean(foxEnabled, v, null);
    }

    public BServerPort getFoxsPort() {
        return (BServerPort)this.get(foxsPort);
    }

    public void setFoxsPort(BServerPort v) {
        this.set(foxsPort, (BValue)v, null);
    }

    public boolean getFoxsEnabled() {
        return this.getBoolean(foxsEnabled);
    }

    public void setFoxsEnabled(boolean v) {
        this.setBoolean(foxsEnabled, v, null);
    }

    public boolean getFoxsOnly() {
        return this.getBoolean(foxsOnly);
    }

    public void setFoxsOnly(boolean v) {
        this.setBoolean(foxsOnly, v, null);
    }

    public BSslTlsEnum getFoxsMinProtocol() {
        return (BSslTlsEnum)this.get(foxsMinProtocol);
    }

    public void setFoxsMinProtocol(BSslTlsEnum v) {
        this.set(foxsMinProtocol, (BValue)v, null);
    }

    public BTlsCipherSuiteGroup getCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(cipherSuiteGroup);
    }

    public void setCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(cipherSuiteGroup, (BValue)v, null);
    }

    public String getFoxsCert() {
        return this.getString(foxsCert);
    }

    public void setFoxsCert(String v) {
        this.setString(foxsCert, v, null);
    }

    public BRelTime getRequestTimeout() {
        return (BRelTime)this.get(requestTimeout);
    }

    public void setRequestTimeout(BRelTime v) {
        this.set(requestTimeout, (BValue)v, null);
    }

    public BRelTime getSocketOptionTimeout() {
        return (BRelTime)this.get(socketOptionTimeout);
    }

    public void setSocketOptionTimeout(BRelTime v) {
        this.set(socketOptionTimeout, (BValue)v, null);
    }

    public boolean getSocketTcpNoDelay() {
        return this.getBoolean(socketTcpNoDelay);
    }

    public void setSocketTcpNoDelay(boolean v) {
        this.setBoolean(socketTcpNoDelay, v, null);
    }

    public BRelTime getKeepAliveInterval() {
        return (BRelTime)this.get(keepAliveInterval);
    }

    public void setKeepAliveInterval(BRelTime v) {
        this.set(keepAliveInterval, (BValue)v, null);
    }

    public int getMaxServerSessions() {
        return this.getInt(maxServerSessions);
    }

    public void setMaxServerSessions(int v) {
        this.setInt(maxServerSessions, v, null);
    }

    public boolean getMulticastEnabled() {
        return this.getBoolean(multicastEnabled);
    }

    public void setMulticastEnabled(boolean v) {
        this.setBoolean(multicastEnabled, v, null);
    }

    public boolean getEnableAnnouncement() {
        return this.getBoolean(enableAnnouncement);
    }

    public void setEnableAnnouncement(boolean v) {
        this.setBoolean(enableAnnouncement, v, null);
    }

    public int getMulticastTimeToLive() {
        return this.getInt(multicastTimeToLive);
    }

    public void setMulticastTimeToLive(int v) {
        this.setInt(multicastTimeToLive, v, null);
    }

    public BServerConnections getServerConnections() {
        return (BServerConnections)this.get(serverConnections);
    }

    public void setServerConnections(BServerConnections v) {
        this.set(serverConnections, (BValue)v, null);
    }

    public boolean getTraceSessionStates() {
        return this.getBoolean(traceSessionStates);
    }

    public void setTraceSessionStates(boolean v) {
        this.setBoolean(traceSessionStates, v, null);
    }

    public boolean getTraceReadFrame() {
        return this.getBoolean(traceReadFrame);
    }

    public void setTraceReadFrame(boolean v) {
        this.setBoolean(traceReadFrame, v, null);
    }

    public boolean getTraceWriteFrame() {
        return this.getBoolean(traceWriteFrame);
    }

    public void setTraceWriteFrame(boolean v) {
        this.setBoolean(traceWriteFrame, v, null);
    }

    public boolean getTraceMulticast() {
        return this.getBoolean(traceMulticast);
    }

    public void setTraceMulticast(boolean v) {
        this.setBoolean(traceMulticast, v, null);
    }

    public boolean getAuditStationLoginEvents() {
        return this.getBoolean(auditStationLoginEvents);
    }

    public void setAuditStationLoginEvents(boolean v) {
        this.setBoolean(auditStationLoginEvents, v, null);
    }

    public BDynamicEnum getSupportLegacyClients() {
        return (BDynamicEnum)this.get(supportLegacyClients);
    }

    public void setSupportLegacyClients(BDynamicEnum v) {
        this.set(supportLegacyClients, (BValue)v, null);
    }

    public void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    public void delayStationStarted() {
        this.invoke(delayStationStarted, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public boolean isServing() {
        Daemon daemon = this.daemon;
        return daemon != null && daemon.isServing();
    }

    public void stationStarted() {
        BServerPort tfoxPort = null;
        BServerPort tfoxsPort = null;
        try {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            this.serviceStopped();
            this.initOptions();
            if (this.getFoxEnabled()) {
                tfoxPort = this.getFoxPort();
            }
            if (this.getFoxsEnabled()) {
                tfoxsPort = this.getFoxsPort();
            }
            this.daemon = new Daemon(this, tfoxPort, tfoxsPort);
            this.daemon.run();
            keys.add("foxport");
            if (tfoxPort != null) {
                values.add(String.valueOf(tfoxPort.getPublicServerPort()));
            } else {
                values.add("-1");
            }
            keys.add("foxsport");
            if (tfoxsPort != null) {
                values.add(String.valueOf(tfoxsPort.getPublicServerPort()));
            } else {
                values.add("-1");
            }
            Nre.getPlatform().reportSummaryFields(keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot start", e);
        }
        Optional securityService = Sys.findService((Type)BISecurityService.TYPE);
        if (securityService.isPresent()) {
            ((BISecurityService)((BIService)securityService.get()).as(BISecurityService.class)).register((BISecurityInfoSource)this);
        } else {
            AccessController.doPrivileged(() -> {
                Nre.getServiceManager().addServiceListener(this.serviceListener);
                return null;
            });
        }
        this.trustAnchorConsumerId = AccessController.doPrivileged(() -> CoreCryptoManager.get().registerTrustAnchorConsumer((TrustAnchorConsumer)this));
    }

    public void serviceStarted() {
        try {
            AccessController.doPrivileged(() -> Nre.getServiceManager()).getService("platCrypto:CertManagerService");
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsCert, this.getFlags((Slot)foxsCert) & 0xFFFFFFFA);
        }
        catch (Exception e) {
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) | 1 | 4);
            this.setFoxsEnabled(false);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) | 1 | 4);
            this.setFoxsOnly(false);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) | 1 | 4);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) | 1 | 4);
            this.setFlags((Slot)foxsCert, this.getFlags((Slot)foxsCert) | 1 | 4);
        }
        finally {
            this.setSupportLegacyClients(BDynamicEnum.make((int)this.getSupportLegacyClients().getOrdinal(), (BEnumRange)LOCAL_SUPPORT_LEGACY_CLIENTS_RANGE));
        }
    }

    public void serviceStopped() {
        if (this.daemon != null) {
            LOG.info("Service stopped");
            this.daemon.stop();
        }
        this.daemon = null;
        Sys.findService((Type)BISecurityService.TYPE).ifPresent(s -> ((BISecurityService)s.as(BISecurityService.class)).unregister((BISecurityInfoSource)this));
        AccessController.doPrivileged(() -> {
            Nre.getServiceManager().removeServiceListener(this.serviceListener);
            return null;
        });
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().unregisterTrustAnchorConsumer(this.trustAnchorConsumerId);
            return null;
        });
    }

    private void initOptions() {
        Fox.appName = "Station";
        Fox.appVersion = String.valueOf(Sys.getBajaVersion());
        Fox.hostName = Sys.getHostName();
        Fox.hostAddress = Sys.getLocalHost(null).getHostAddress();
        Fox.ipv4Enabled = !NreLib.getLocalHost((boolean)false).isLoopbackAddress();
        Fox.ipv6Enabled = Fox.ipv6Enabled && !NreLib.getLocalHost((boolean)true).isLoopbackAddress();
        Fox.requestTimeout = (int)this.getRequestTimeout().getMillis();
        Fox.keepAliveInterval = (int)this.getKeepAliveInterval().getMillis();
        Fox.soTimeout = (int)this.getSocketOptionTimeout().getMillis();
        Fox.tcpNoDelay = this.getSocketTcpNoDelay();
        Fox.multicastEnabled = this.getMulticastEnabled();
        Fox.multicastTimeToLive = this.getMulticastTimeToLive();
        Fox.maxServerSessions = this.getMaxServerSessions();
        Fox.traceSessionStates = this.getTraceSessionStates();
        Fox.traceReadFrame = this.getTraceReadFrame();
        Fox.traceWriteFrame = this.getTraceWriteFrame();
        Fox.traceMulticast = this.getTraceMulticast();
    }

    public static BFoxService waitUntilPortOpen(long timeout) {
        try {
            BFoxService service = (BFoxService)Sys.getService((Type)TYPE);
            long start = Clock.ticks();
            while (!service.isServing()) {
                if (Clock.ticks() - start > timeout) {
                    throw new BajaRuntimeException("BFoxService.waitUntilPortOpen timed out");
                }
                Thread.sleep(100L);
            }
            return service;
        }
        catch (BajaRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("ERROR: BFoxService.waitUntilPortOpen failed");
            e.printStackTrace();
            throw new BajaRuntimeException("FoxService.waitUntilPortOpen", (Throwable)e);
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BSecurityInfo getSecurityInfo() {
        BSecurityInfo info = new BSecurityInfo();
        info.setSourceName(this.getDisplayName(null));
        if (this.isMounted()) {
            info.setHyperlink(this.getSlotPathOrd());
        }
        info.add("alias", (BValue)BString.make((String)this.getFoxsCert()));
        return info;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop == foxPort || prop == foxsPort) {
            this.triggerDelayedStationStarted();
        } else if (prop == foxsCert || prop == foxsMinProtocol || prop == foxsOnly || prop == cipherSuiteGroup) {
            if (this.getFoxsEnabled()) {
                this.triggerDelayedStationStarted();
            }
        } else if (prop == foxEnabled || prop == foxsEnabled || prop == multicastEnabled) {
            this.triggerDelayedStationStarted();
        } else {
            this.initOptions();
        }
    }

    private synchronized void triggerDelayedStationStarted() {
        this.triggerDelayedStationStarted(500L);
    }

    private synchronized void triggerDelayedStationStarted(long waitMillis) {
        if (this.restartTicket == null) {
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)waitMillis), (Action)delayStationStarted, null);
        }
        if (this.restartTicket instanceof NClockTicket && waitMillis < ((NClockTicket)this.restartTicket).millisLeft()) {
            this.restartTicket.cancel();
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)waitMillis), (Action)delayStationStarted, null);
        }
    }

    public void doResetAllConnections() {
        new Thread(){

            @Override
            public void run() {
                for (BFoxServerConnection connection : (BFoxServerConnection[])BFoxService.this.getServerConnections().getChildren(BFoxServerConnection.class)) {
                    try {
                        connection.forceDisconnect();
                    }
                    catch (Exception e) {
                        Logger.getLogger("fox").log(Level.WARNING, "Error resetting connections", e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelayStationStarted() {
        BFoxService bFoxService = this;
        synchronized (bFoxService) {
            this.restartTicket = null;
        }
        this.stationStarted();
    }

    public void updateTrustAnchors() {
        this.triggerDelayedStationStarted(120000L);
    }

    public BFoxServerConnection makePersistentServerConnection(String name) {
        Property p = this.getServerConnections().getProperty(name);
        if (p != null) {
            this.getServerConnections().remove(p);
        }
        p = this.getServerConnections().add(name, (BValue)new BFoxServerConnection(), 3);
        BFoxServerConnection result = (BFoxServerConnection)this.get(p);
        result.setPersistent(true);
        return result;
    }

    public BFoxServerConnection makeServerConnection(FoxSession session, FoxMessage remoteHello) throws Exception {
        FoxServerConnectionListener listener2;
        BFoxServerConnection conn = null;
        Iterator<FoxServerConnectionListener> iterator = this.serverConnectionListeners.iterator();
        while (iterator.hasNext() && (conn = (listener2 = iterator.next()).getPersistentConnection(session, remoteHello)) == null) {
        }
        if (conn == null) {
            Property p = this.getServerConnections().add("Session?", (BValue)new BFoxServerConnection(), 3);
            conn = (BFoxServerConnection)this.get(p);
        }
        for (FoxServerConnectionListener listener2 : this.serverConnectionListeners) {
            listener2.serverConnectionCreated(conn, session, remoteHello);
        }
        return conn;
    }

    public void registerServerConnectionListener(FoxServerConnectionListener listener) {
        this.serverConnectionListeners.add(listener);
    }

    public void unregisterServerConnectionListener(FoxServerConnectionListener listener) {
        this.serverConnectionListeners.remove(listener);
    }

    public void notifyServerConnectionClosed(BFoxServerConnection connection, Throwable cause) {
        this.serverConnectionListeners.forEach(listener -> {
            try {
                listener.serverConnectionClosed(connection, cause);
            }
            catch (Throwable t) {
                Logger.getLogger("fox").log(Level.SEVERE, "Error notifying connection closed", t);
            }
        });
        if (!connection.isPersistent()) {
            this.getServerConnections().remove(connection.getPropertyInParent());
        }
    }

    public FoxServer getFoxServer() {
        return this.daemon;
    }

    public static NiagaraNetwork getNiagaraNetwork() {
        try {
            return (NiagaraNetwork)Sys.getService((Type)Sys.getType((String)"niagaraDriver:NiagaraNetwork"));
        }
        catch (ServiceNotFoundException snfe) {
            return null;
        }
    }

    public static int getHttpPort() {
        try {
            Type type = Sys.getType((String)"web:WebService");
            BComponent webService = Sys.getService((Type)type);
            BInteger port = (BInteger)webService.get("httpPort");
            return port.getInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean auditConnection(String operation, FoxSession session) {
        String appName = session.getRemoteHello().getString("app.name", "Station");
        if (appName.equals("Station")) {
            switch (operation) {
                case "Login": 
                case "Logout": 
                case "Logout (Timeout)": {
                    BFoxService svc = (BFoxService)Sys.getService((Type)TYPE);
                    return svc.getAuditStationLoginEvents();
                }
            }
            return true;
        }
        return true;
    }

    public final boolean allowLegacyClients() {
        int ordinal = this.getSupportLegacyClients().getOrdinal();
        switch (ordinal) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)foxsCert) > -1) {
            return this.validator;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (foxsCert.equals(property)) {
            return this.validator;
        }
        return super.getPropertyValidator(property, context);
    }

    public BIcon getIcon() {
        return ICON;
    }

    class Daemon
    extends FoxServer {
        private final BFoxService service;

        public Daemon(BFoxService service, BServerPort foxPort, BServerPort foxsPort) {
            super(foxPort, foxsPort);
            this.service = service;
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public ServerSocket getFoxsServerSocket() throws IOException {
            try {
                return AccessController.doPrivileged(() -> {
                    CoreCryptoManager ccm;
                    ICryptoManager cryptoService;
                    try {
                        cryptoService = (ICryptoManager)Nre.getServiceManager().getService("platCrypto:CertManagerService");
                        ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                    }
                    catch (Exception e) {
                        throw new IOException("unable to get crypto services references", e);
                    }
                    try {
                        String alias = ccm.checkServerCertificateStatus(this.service.getFoxsCert(), null, LOG);
                        TlsCipherSuiteGroup cipherSuiteGroup = this.service.getCipherSuiteGroup().getCipherSuiteGroup();
                        boolean wantClientAuth = !ccm.getTrustAnchors().isEmpty();
                        ServerTlsParameters tlsParams = new ServerTlsParameters(this.service.getFoxsMinProtocol().getTag(), alias, cipherSuiteGroup, wantClientAuth);
                        if (cipherSuiteGroup != TlsCipherSuiteGroup.recommended) {
                            LOG.warning("not using recommended tls cipher suite group, using " + tlsParams);
                        } else {
                            LOG.fine("using " + tlsParams);
                        }
                        ServerSocketFactory fact = cryptoService.getServerSocketFactory(tlsParams);
                        if (this.foxsPort.getBindToLoopback()) {
                            return fact.createServerSocket(BFoxService.this.getFoxsPort().getBindingPort(), 10, InetAddress.getByName(null));
                        }
                        return fact.createServerSocket(BFoxService.this.getFoxsPort().getBindingPort(), 10);
                    }
                    catch (BindException be) {
                        throw be;
                    }
                    catch (Exception x) {
                        throw new IOException("unable to create socket for foxs", x);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }

        @Override
        public FoxConnection makeConnection(FoxSession session, FoxMessage remoteHello) throws Exception {
            return BFoxService.this.makeServerConnection(session, remoteHello);
        }

        @Override
        public FoxMessage getAnnouncement(FoxMessage message) {
            InetAddress announcementAddressV6;
            InetAddress announcementAddressV4;
            if (!BFoxService.this.getEnableAnnouncement()) {
                return null;
            }
            FoxMessage msg = new FoxMessage();
            msg.add("station", Sys.getStation().getStationName());
            if (Fox.ipv4Enabled && !(announcementAddressV4 = NreLib.getLocalHost((boolean)false)).isLoopbackAddress()) {
                msg.add("hostName", announcementAddressV4.getHostName());
                msg.add("hostAddress", announcementAddressV4.getHostAddress());
            }
            if (Fox.ipv6Enabled && !(announcementAddressV6 = NreLib.getLocalHost((boolean)true)).isLoopbackAddress()) {
                msg.add("hostNameIPv6", announcementAddressV6.getHostName());
                msg.add("hostAddressIPv6", announcementAddressV6.getHostAddress());
            }
            if (BFoxService.this.getFoxEnabled()) {
                msg.add("foxPort", BFoxService.this.getFoxPort().getPublicServerPort());
            }
            if (BFoxService.this.getFoxsEnabled()) {
                msg.add("foxsPort", BFoxService.this.getFoxsPort().getPublicServerPort());
            }
            msg.add("httpPort", BFoxService.getHttpPort());
            msg.add("version", Sys.getBajaVersion().toString());
            msg.add("hostId", Nre.getHostId());
            msg.add("hostModel", Nre.getHostModel());
            msg.add("brandId", Brand.getBrandId());
            msg.add("vmName", Fox.vmName);
            msg.add("vmVersion", Fox.vmVersion);
            msg.add("osName", Fox.osName);
            msg.add("osVersion", Fox.osVersion);
            return msg;
        }

        @Override
        public boolean authenticateBasic(FoxSession session, String username, String password) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateBasic in BFoxService. This call should be handled by an Authentication Agent.");
        }

        @Override
        public boolean authenticateDigest(FoxSession session, String username, byte[] nonce, byte[] digest) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateDigest in BFoxService. This call should be handled by an Authentication Agent.");
        }
    }

    public static interface FoxServerConnectionListener {
        default public BFoxServerConnection getPersistentConnection(FoxSession session, FoxMessage remoteHello) {
            return null;
        }

        default public void serverConnectionCreated(BFoxServerConnection connection, FoxSession session, FoxMessage remoteHello) {
        }

        default public void serverConnectionClosed(BFoxServerConnection connection, Throwable cause) {
        }
    }
}

