/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.spy.BSpyChannel;
import com.tridium.fox.sys.user.BUserChannel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFoxChannelRegistry
extends BComponent {
    public static final Type TYPE = Sys.loadType(BFoxChannelRegistry.class);
    private static BFoxChannelRegistry prototype = new BFoxChannelRegistry();
    private static final BIcon icon;

    public Type getType() {
        return TYPE;
    }

    public final BSysChannel getSysChannel() {
        return (BSysChannel)this.get("sys");
    }

    public final BFileChannel getFileChannel() {
        return (BFileChannel)this.get("file");
    }

    public final BUserChannel getUserChannel() {
        return (BUserChannel)this.get("user");
    }

    public final BFoxChannel get(String name, Type channelType) {
        BFoxChannel channel = (BFoxChannel)this.get(name);
        if (channel != null) {
            if (channel.getType() != channelType) {
                throw new ClassCastException("Type mismatch: " + channel.getType() + " != " + channelType);
            }
        } else {
            channel = (BFoxChannel)channelType.getInstance();
            this.add(name, (BValue)channel, 2);
            if (((BFoxConnection)this.getParent()).isConnected()) {
                this.sessionOpened(channel);
            }
        }
        return channel;
    }

    public static BFoxChannelRegistry getPrototype() {
        return prototype;
    }

    public void sessionOpened() {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            this.sessionOpened((BFoxChannel)c.get());
        }
    }

    public void sessionClosed(Throwable cause) {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            this.sessionClosed((BFoxChannel)c.get(), cause);
        }
    }

    private void sessionOpened(BFoxChannel channel) {
        try {
            FoxSession session = ((BFoxConnection)this.getParent()).session();
            channel.log.setSession(session);
            channel.fwSessionOpened();
            channel.sessionOpened();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void sessionClosed(BFoxChannel channel, Throwable cause) {
        try {
            channel.sessionClosed(cause);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        channel.fwSessionClosed(cause);
        channel.log.setSession(null);
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        prototype.add("data", (BValue)new BDataChannel());
        prototype.add("file", (BValue)new BFileChannel());
        prototype.add("spy", (BValue)new BSpyChannel());
        prototype.add("sys", (BValue)new BSysChannel());
        prototype.add("user", (BValue)new BUserChannel());
        try {
            prototype.add("alarmui", (BValue)((BFoxChannel)((Object)Sys.newInstance((String)"alarm", (String)"com.tridium.alarm.BAlarmConsoleChannel"))));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        icon = BIcon.std((String)"book.png");
    }
}

