/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.authn.BLegacyDigestAuthenticationScheme;
import com.tridium.authn.BSessionIdAuthenticationScheme;
import com.tridium.authn.LoginFailureCause;
import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.crypto.core.exchange.KeyExchange;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxUserLockoutException;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.KeyDerivationAlgorithmBundle;
import com.tridium.nre.security.NullAlgorithmBundle;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.util.ValueByteBuffer;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIExtraAttributesCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class Tuner
extends Thread {
    private static final String FOX_LOGIN_UNSUPPORTED = "foxUnsupported";
    private static final Logger LOGGER = Logger.getLogger("fox");
    private FoxServer server;
    private FoxSession session;
    private String scheme;

    static FoxSession openClient(FoxConnection conn, Socket socket, String user, String password, FoxSession.IFoxSessionListener[] listeners) throws Exception {
        BUsernameAndPassword credentials = new BUsernameAndPassword(user, password);
        return Tuner.openClient(conn, socket, (BICredentials)credentials, listeners);
    }

    static FoxSession openClient(FoxConnection conn, Socket socket, BICredentials credentials, FoxSession.IFoxSessionListener[] listeners) throws Exception {
        byte[] encoded = ValueByteBuffer.marshal((BObject)((BObject)credentials));
        FoxSession session = new FoxSession(socket, conn, listeners);
        session.setState("client.tune open credentials.len=" + encoded.length);
        Fox.register(session);
        BFoxClientAuthnHandler handler = null;
        try {
            AuthenticationClient authenticationClient;
            session.setState("client.tune sendHello");
            if (credentials instanceof BHttpFoxCredentials) {
                session.sendHello(null, ((BHttpFoxCredentials)credentials).getSessionId(), true);
            } else {
                session.sendHello(null, true);
            }
            session.setState("client.tune receiveHello");
            session.receiveHello();
            BFoxClientConnection foxClientConnection = (BFoxClientConnection)conn;
            BFoxSession bFoxSession = ((BFoxClientConnection)conn).getFoxSession();
            if (bFoxSession != null) {
                FoxMessage hello = session.getRemoteHello();
                String availableSchemes = hello.getString("availableSchemes", null);
                if (availableSchemes != null) {
                    bFoxSession.setAvailableAuthenticationSchemes(availableSchemes.split(","));
                    bFoxSession.setDefaultAuthenticationScheme(hello.getString("defaultScheme", null));
                } else {
                    bFoxSession.setAvailableAuthenticationSchemes(null);
                    bFoxSession.setDefaultAuthenticationScheme(null);
                }
            }
            if ((authenticationClient = foxClientConnection.getAuthenticationClient()) == null) {
                throw new FoxAuthenticationException("Rejected", null, null, session);
            }
            BUsernameCredential usernameCredential = new BUsernameCredential();
            if (!session.isLegacyConnection()) {
                session.setState("client.tune receiveKerberos");
                FoxMessage kerberos = session.receiveTuning("kerberos");
                boolean useKerberos = kerberos.getBoolean("useKerberos");
                if (useKerberos && bFoxSession != null) {
                    bFoxSession.setAuthenticationScheme("n4Kerberos");
                }
                if ((usernameCredential = authenticationClient.requestUsername((AuthenticationRealm)bFoxSession)) == null) {
                    throw new FoxAuthenticationException("Cancelled", null, null, session);
                }
                if (bFoxSession != null) {
                    bFoxSession.setUsernameCredential((BIUserCredentials)usernameCredential);
                }
                Boolean kerbKey = false;
                if (usernameCredential instanceof BKerberosCredentials) {
                    kerbKey = true;
                }
                String requestedUsername = usernameCredential.getUsername();
                FoxMessage usernameMessage = new FoxMessage();
                usernameMessage.add("username", requestedUsername);
                usernameMessage.add("kerbKey", kerbKey);
                Tuner.addExtraAttributes((BICredentials)usernameCredential, usernameMessage, session);
                session.setState("client.tune sendUsername");
                session.sendTuning("username", usernameMessage);
            }
            boolean retry = false;
            do {
                BAuthenticationScheme authenticationScheme;
                session.setState("client.tune receiveChallenge");
                FoxMessage challenge = session.receiveTuning("challenge");
                String method = challenge.getString("method");
                if (method.equals(FOX_LOGIN_UNSUPPORTED)) {
                    throw new AuthenticationException((AuthenticationRealm)bFoxSession, LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED);
                }
                String keyExchangeMethods = challenge.getString("keyExchangeMethods", null);
                String keyExchangeCiphers = challenge.getString("keyExchangeCiphers", null);
                if (keyExchangeMethods != null) {
                    String[] methods;
                    FoxMessage exchangeResponse = new FoxMessage();
                    KeyDerivationAlgorithmBundle keyDerivationAlgorithmBundle = null;
                    EncryptionAlgorithmBundle encryptionAlgorithmBundle = null;
                    for (String m : methods = keyExchangeMethods.split(":")) {
                        CryptographicAlgorithmBundle bundle = CryptographicAlgorithmBundle.getInstance((String)m);
                        if (!(bundle instanceof KeyDerivationAlgorithmBundle)) continue;
                        keyDerivationAlgorithmBundle = (KeyDerivationAlgorithmBundle)bundle;
                        break;
                    }
                    if (keyExchangeCiphers != null) {
                        String[] ciphers;
                        for (String c : ciphers = keyExchangeCiphers.split(":")) {
                            CryptographicAlgorithmBundle bundle = CryptographicAlgorithmBundle.getInstance((String)c);
                            if (!(bundle instanceof EncryptionAlgorithmBundle)) continue;
                            encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)bundle;
                            break;
                        }
                    }
                    if (keyDerivationAlgorithmBundle != null && encryptionAlgorithmBundle != null) {
                        String exchangeMethod = keyDerivationAlgorithmBundle.getAlgorithmName();
                        exchangeResponse.add("keyExchangeMethod", exchangeMethod);
                        exchangeResponse.add("keyExchangeCipher", encryptionAlgorithmBundle.getAlgorithmName());
                        session.setKeyExchangeAlgorithmBundle(keyDerivationAlgorithmBundle);
                        session.setEncryptionAlgorithmBundle(encryptionAlgorithmBundle);
                    } else {
                        exchangeResponse.add("keyExchangeMethod", NullAlgorithmBundle.getInstance().getAlgorithmName());
                    }
                    String keyExchangeMethodName = session.getKeyExchangeAlgorithmBundle().getAlgorithmName();
                    String keyExchangeCipherName = session.getEncryptionAlgorithmBundle() == null ? "null" : session.getEncryptionAlgorithmBundle().getAlgorithmName();
                    session.setState("client.tune sendKeyExchangeMethod method=" + keyExchangeMethodName + '/' + keyExchangeCipherName);
                    session.sendTuning("clientKeyExchangeMethod", exchangeResponse);
                }
                session.setState("client.tune receivedChallenge method=" + method);
                foxClientConnection.setAuthenticationScheme(method);
                if (bFoxSession != null) {
                    bFoxSession.setAuthenticationScheme(method);
                }
                if ((authenticationScheme = BAuthenticationScheme.getSchemeFromName((String)method)) == null) {
                    Lexicon lex = Lexicon.make(Tuner.class);
                    throw new AuthenticationException(lex.getText("fox.authScheme.unsupported", new Object[]{method}));
                }
                if (handler == null && (handler = (BFoxClientAuthnHandler)authenticationScheme.getAgentOn(BFoxClientAuthnHandler.class)) != null) {
                    handler.setData((BIObject)usernameCredential);
                }
                if (!(handler != null && handler.getType().equals(((BFoxClientAuthnHandler)authenticationScheme.getAgentOn(BFoxClientAuthnHandler.class)).getType()) || (handler = (BFoxClientAuthnHandler)authenticationScheme.getAgentOn(BFoxClientAuthnHandler.class)) == null)) {
                    handler.setData((BIObject)usernameCredential);
                }
                if (credentials instanceof BHttpFoxCredentials && handler != null) {
                    handler.setData((BIObject)credentials);
                }
                if (handler == null) {
                    throw new AuthenticationException((AuthenticationRealm)bFoxSession, LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED);
                }
                handler.handleAuthentication(session, authenticationClient);
                retry = Tuner.receiveWelcome(session, method);
            } while (retry);
            String foxVer = session.getRemoteHello().getString("fox.version", null);
            if (foxVer != null && new Version(foxVer).compareTo(FoxSession.FOX_VERSION_1_0_2) >= 0) {
                session.setState("client.tune receiveHello");
                session.receiveHello();
            }
            if (handler != null) {
                handler.success(session);
            }
            if (usernameCredential instanceof BKerberosCredentials) {
                ((BKerberosCredentials)usernameCredential).destroyTicket();
            }
            session.setState("client.tune starting");
            session.start();
            return session;
        }
        catch (Error e) {
            if (handler != null) {
                handler.failure(session);
            }
            session.close(e);
            throw e;
        }
        catch (FoxAuthenticationException fae) {
            String failReason = null;
            if (fae.data != null) {
                FoxMessage fm = fae.data;
                try {
                    failReason = fm.getString("authfail_reason");
                }
                catch (IOException usernameCredential) {
                    // empty catch block
                }
                if (failReason != null && failReason.equals("User Lockout")) {
                    if (handler != null) {
                        handler.failure(session);
                    }
                    FoxUserLockoutException ule = new FoxUserLockoutException(session);
                    session.close(ule);
                    throw new FoxUserLockoutException(session);
                }
            }
            if (handler != null) {
                handler.failure(session);
            }
            session.close(fae);
            throw fae;
        }
        catch (Exception exce) {
            if (handler != null) {
                handler.failure(session);
            }
            session.close(exce);
            throw exce;
        }
    }

    private static boolean receiveWelcome(FoxSession session, String method) throws IOException, FoxAuthenticationException {
        session.setState("client.tune receiveWelcome");
        FoxFrame frame = session.readFrame();
        if (Objects.equals(frame.command, "retry")) {
            return true;
        }
        if (!Objects.equals(frame.command, "welcome")) {
            session.setState("client.tune receivedRejected");
            String fatal = frame.message.getString("fatal", null);
            String msg = frame.message.getString("msg", null);
            FoxAuthenticationException e = null != msg ? new FoxAuthenticationException(msg, method, fatal, session) : new FoxAuthenticationException("Rejected", method, fatal, session);
            try {
                e.data = frame.message.getMessage("data");
            }
            catch (IOException ioe) {
                e.data = null;
            }
            throw e;
        }
        session.remoteWelcome = frame.message;
        session.setState("client.tune receivedWelcome");
        return false;
    }

    static void openServer(FoxServer server, Socket socket, String scheme) throws Exception {
        FoxSession session = null;
        try {
            session = new FoxSession(socket, null);
            int max = Math.max(1, Fox.maxServerSessions);
            if (Fox.getServerSessionCount() >= max) {
                LOGGER.warning("past fox.maxServerSessions limit: " + max);
                session.sendBusy();
            }
        }
        catch (Throwable e) {
            if (session != null) {
                session.release();
            }
            throw e;
        }
        Fox.register(session);
        try {
            session.setState("server.tune spawning");
            new Tuner(server, session, scheme).start();
        }
        catch (Exception e) {
            session.close(e);
            throw e;
        }
    }

    private Tuner(FoxServer server, FoxSession session, String scheme) {
        super("Fox:Tuner:" + session.getId());
        this.server = server;
        this.session = session;
        this.scheme = scheme;
    }

    @Override
    public final void run() {
        try {
            ArrayList<Object> schemes;
            this.session.setState("server.tune receiveHello");
            try {
                this.session.receiveHello();
            }
            catch (IncompatibleVersionException ive) {
                FoxMessage rejected = new FoxMessage();
                rejected.add("fatal", ive.getMessage());
                rejected.add("fox.version", "Niagara 4");
                this.session.setState("server.tune sendHello");
                this.session.sendTuning("hello", rejected);
                this.session.close(ive);
                return;
            }
            BFoxService service = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            String foxVer = this.session.getRemoteHello().getString("fox.version", null);
            if (!(service.allowLegacyClients() || foxVer != null && new Version(foxVer).compareTo(FoxSession.FOX_VERSION_1_0_2) >= 0)) {
                FoxMessage rejected = new FoxMessage();
                rejected.add("fatal", "Legacy FOX clients not allowed");
                rejected.add("fox.version", "Niagara 4 (Legacy clients not allowed)");
                this.session.setState("server.tune sendHello");
                this.session.sendTuning("hello", rejected);
                this.session.close(new IncompatibleVersionException("Legacy FOX clients not allowed"));
                return;
            }
            this.session.setState("server.tune makeConnection");
            this.session.conn = this.server.makeConnection(this.session, this.session.getRemoteHello());
            if (this.scheme.equalsIgnoreCase("fox") && service.getFoxsOnly() && service.getFoxsEnabled()) {
                this.session.setState("server.tune sendRedirect");
                this.session.sendRedirect(service.getFoxsPort().getPublicServerPort());
                throw new FoxsRedirectException(service.getFoxsPort().getPublicServerPort());
            }
            try {
                Acceptor.accept(this.session);
            }
            catch (Throwable e) {
                FoxMessage msg = this.session.initHello(null, null, this.session.getId(), null, this.session.getLegacyId(), false);
                msg.add("exception", e.getMessage());
                this.session.sendTuning("hello", msg);
                throw e;
            }
            this.session.setState("server.tune sendHello");
            boolean includeLegacyAttributes = false;
            if (service.allowLegacyClients() && foxVer != null && new Version(foxVer).compareTo(FoxSession.FOX_VERSION_1_0_2) < 0 && this.session.getRemoteHello().getOptional("app.name") != null && this.session.getRemoteHello().getOptional("app.version") != null && this.session.getRemoteHello().getOptional("vm.name") != null && this.session.getRemoteHello().getOptional("vm.version") != null && this.session.getRemoteHello().getOptional("os.name") != null && this.session.getRemoteHello().getOptional("os.version") != null) {
                includeLegacyAttributes = true;
            }
            FoxMessage msg = this.session.initHello(null, null, this.session.getId(), null, this.session.getLegacyId(), includeLegacyAttributes);
            BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            if (authnService.getStrictAuthentication()) {
                List availableSchemes = authnService.getSchemesWithAgent(BFoxClientAuthnHandler.class);
                StringJoiner schemes2 = new StringJoiner(",");
                for (BAuthenticationScheme scheme : availableSchemes) {
                    schemes2.add(scheme.getName());
                }
                msg.add("availableSchemes", schemes2.toString());
                msg.add("defaultScheme", authnService.getDefaultSchemeWithAgent(BFoxClientAuthnHandler.class).getName());
            }
            this.session.sendTuning("hello", msg);
            BLegacyDigestAuthenticationScheme authnScheme = null;
            BUser requestedUser = null;
            Boolean kerbKey = false;
            boolean unknownUser = false;
            if (this.session.isLegacyConnection()) {
                authnScheme = new BLegacyDigestAuthenticationScheme();
            } else {
                boolean useKerberos = false;
                for (BAuthenticationScheme scheme : authnService.getSupportedSchemes()) {
                    if (!scheme.getSchemeName().equals("n4Kerberos")) continue;
                    useKerberos = true;
                    break;
                }
                FoxMessage kerberos = new FoxMessage();
                kerberos.add("useKerberos", useKerberos);
                this.session.setState("server.tune sendKerberos");
                this.session.sendTuning("kerberos", kerberos);
                FoxMessage usernameMessage = this.session.receiveTuning("username");
                String username = usernameMessage.getString("username");
                kerbKey = usernameMessage.getBoolean("kerbKey");
                if (this.session.getRemoteHello().getString("requestedId", null) != null) {
                    authnScheme = new BSessionIdAuthenticationScheme();
                } else {
                    BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                    requestedUser = userService.getUser(username);
                    if (authnService.getStrictAuthentication()) {
                        String selectedScheme = usernameMessage.getString("scheme", null);
                        if (selectedScheme != null) {
                            try {
                                authnScheme = authnService.getAuthenticationScheme(selectedScheme);
                                if (authnScheme.getAgentOn(BFoxClientAuthnHandler.class) == null) {
                                    authnScheme = null;
                                    LOGGER.warning(String.format("Requested authentication scheme name <%s> does not support fox login. Falling back to default.", selectedScheme));
                                }
                            }
                            catch (Exception e) {
                                LOGGER.warning(String.format("Requested authentication scheme name <%s> not found. Falling back to default.", selectedScheme));
                            }
                        }
                        if (authnScheme == null) {
                            authnScheme = authnService.getDefaultSchemeWithAgent(BFoxClientAuthnHandler.class);
                        }
                    } else {
                        if (requestedUser == null) {
                            requestedUser = new BUser();
                            unknownUser = true;
                        }
                        try {
                            authnScheme = userService.getAuthenticationSchemeForUser(requestedUser);
                        }
                        catch (Exception e) {
                            authnScheme = null;
                        }
                    }
                }
            }
            if (unknownUser || kerbKey.booleanValue() && (authnScheme == null || !authnScheme.getSchemeName().equals("n4Kerberos"))) {
                schemes = authnService.getRemoteSchemes();
            } else {
                schemes = new ArrayList<Object>();
                if (authnScheme != null) {
                    if (authnScheme.getAgentOn(BFoxCallbackHandler.class) != null) {
                        schemes.add(authnScheme);
                    } else {
                        LOGGER.warning(String.format("User <%s> attempting fox login with unsupported authentication scheme <%s>", requestedUser.getName(), authnScheme.getName()));
                    }
                }
            }
            Throwable ae = null;
            ListIterator iterator = schemes.listIterator();
            while (iterator.hasNext()) {
                BAuthenticationScheme scheme = (BAuthenticationScheme)iterator.next();
                if (scheme.getAgentOn(BFoxCallbackHandler.class) != null && (!kerbKey.booleanValue() || scheme.getSchemeName().equals("n4Kerberos"))) continue;
                iterator.remove();
            }
            if (schemes.isEmpty()) {
                schemes.add(new BDigestAuthenticationScheme());
            }
            if (schemes.isEmpty()) {
                FoxMessage challenge = new FoxMessage();
                String method = unknownUser ? "n4digest" : FOX_LOGIN_UNSUPPORTED;
                challenge.add("method", method);
                challenge.add("useKeyExchange", false);
                this.session.setState("server.tune sendChallenge " + method);
                this.session.sendTuning("challenge", challenge);
                this.rejectAuthentication(this.session, null, ae);
            }
            for (int i = 0; i < schemes.size(); ++i) {
                authnScheme = (BAuthenticationScheme)schemes.get(i);
                FoxMessage challenge = new FoxMessage();
                challenge.add("method", authnScheme.getSchemeName());
                if (!this.session.isSecure() && !this.session.isLegacyConnection()) {
                    challenge.add("keyExchangeMethods", authnScheme.getKeyExchangeMethodName());
                    challenge.add("keyExchangeCiphers", KeyExchange.getPreferredKeyExchangeCiphers());
                } else {
                    challenge.add("keyExchangeMethods", NullAlgorithmBundle.getInstance().getAlgorithmName());
                }
                this.session.setState("server.tune sendChallenge " + authnScheme.getSchemeName());
                this.session.sendTuning("challenge", challenge);
                if (!this.session.isLegacyConnection()) {
                    CryptographicAlgorithmBundle bundle;
                    this.session.setState("server.tune receiveClientKeyExchange");
                    FoxMessage response = this.session.receiveTuning("clientKeyExchangeMethod");
                    String clientKeyExchangeMethod = response.getString("keyExchangeMethod", null);
                    String clientKeyExchangeCipher = response.getString("keyExchangeCipher", null);
                    KeyDerivationAlgorithmBundle keyDerivationAlgorithmBundle = null;
                    EncryptionAlgorithmBundle encryptionAlgorithmBundle = null;
                    if (clientKeyExchangeMethod != null && (bundle = CryptographicAlgorithmBundle.getInstance((String)clientKeyExchangeMethod)) instanceof KeyDerivationAlgorithmBundle) {
                        keyDerivationAlgorithmBundle = (KeyDerivationAlgorithmBundle)bundle;
                    }
                    if (clientKeyExchangeCipher != null && (bundle = CryptographicAlgorithmBundle.getInstance((String)clientKeyExchangeCipher)) instanceof EncryptionAlgorithmBundle) {
                        encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)bundle;
                    }
                    if (keyDerivationAlgorithmBundle != null && encryptionAlgorithmBundle != null) {
                        this.session.setKeyExchangeAlgorithmBundle(keyDerivationAlgorithmBundle);
                        this.session.setEncryptionAlgorithmBundle(encryptionAlgorithmBundle);
                        this.session.setState("server.tune receievedClientKeyExchange method=" + keyDerivationAlgorithmBundle.getAlgorithmName() + '/' + encryptionAlgorithmBundle.getAlgorithmName());
                    }
                }
                BFoxCallbackHandler handler = null;
                try {
                    handler = (BFoxCallbackHandler)authnScheme.getAgentOn(BFoxCallbackHandler.class);
                    Objects.requireNonNull(handler);
                    handler.init(this.session);
                    BUser user = authnService.authenticate((NiagaraSession)this.session, requestedUser, (CallbackHandler)((Object)handler), (BAuthenticationScheme)authnScheme);
                    this.authenticateAttempt(this.session, handler.getUsername());
                    this.authenticateSuccess(this.session, user);
                    this.acceptAuthentication(this.session);
                    break;
                }
                catch (AuthenticationException e) {
                    if (i == schemes.size() - 1) {
                        if (handler != null) {
                            this.authenticateAttempt(this.session, handler.getUsername());
                        }
                        this.rejectAuthentication(this.session, null, e);
                        continue;
                    }
                    FoxMessage retry = new FoxMessage();
                    this.session.setState("server.tune sendRetry");
                    this.session.sendTuning("retry", retry);
                    continue;
                }
            }
        }
        catch (Throwable e) {
            this.session.close(e);
        }
    }

    protected BUserService authenticateAttempt(FoxSession session, String username) {
        BFoxServerConnection conn = (BFoxServerConnection)session.conn();
        conn.setLastLoginTime(Clock.time());
        if (null != username) {
            conn.setLastLoginUsername(username);
        }
        conn.setLastLoginAddress(session.getRemoteHost() + ":" + session.getRemotePort());
        conn.setLastLoginApp(session.getRemoteHello().getString("app.name", "") + " " + session.getRemoteHello().getString("app.version", ""));
        return (BUserService)Sys.getService((Type)BUserService.TYPE);
    }

    public void acceptAuthentication(FoxSession session) throws Exception {
        FoxMessage welcome = new FoxMessage();
        if (SecurityInitializer.getInstance().isFips()) {
            welcome.add("fips", true);
        }
        BUser user = session.getUser();
        BAuthenticationScheme scheme = user.getAuthenticationScheme();
        BAbstractAuthenticator authenticator = user.getAuthenticator();
        BUserPasswordConfiguration userPassConfig = null;
        BGlobalPasswordConfiguration[] globalPassConfig = (BGlobalPasswordConfiguration[])scheme.getChildren(BGlobalPasswordConfiguration.class);
        if (authenticator instanceof BPasswordAuthenticator) {
            userPassConfig = ((BPasswordAuthenticator)authenticator).getPasswordConfig();
        }
        if (userPassConfig != null && globalPassConfig.length > 0) {
            BAbsTime expTime = userPassConfig.getExpiration();
            BRelTime warningPeriod = globalPassConfig[0].getWarningPeriod();
            TypeInfo USER_SYNC_EXT_TYPE = BTypeSpec.make((String)"niagaraDriver", (String)"UserSyncExt").getTypeInfo();
            Property syncExtProp = user.getProperty("syncExt");
            boolean networkUser = user.getNetworkUser() && Flags.isReadonly((BComplex)user.getParent(), (Slot)user.getPropertyInParent()) && syncExtProp != null && USER_SYNC_EXT_TYPE != null && syncExtProp.getType().is(USER_SYNC_EXT_TYPE);
            boolean forceReset = false;
            if (!expTime.isNull() && expTime.isBefore(BAbsTime.now())) {
                forceReset = true;
            } else if (!expTime.isNull() && expTime.subtract(warningPeriod).isBefore(BAbsTime.now())) {
                welcome.add("passwordExpires", expTime.getMillis());
                welcome.add("networkUser", networkUser);
            }
            boolean bl = forceReset = userPassConfig.getForceResetAtNextLogin() || forceReset;
            if (forceReset) {
                boolean illegalNetworkUserState = networkUser;
                welcome.add("forceReset", true);
                BPasswordStrength strength = globalPassConfig[0].getPasswordStrength();
                welcome.add("minLength", strength.getMinimumLength());
                welcome.add("minLowerCase", strength.getMinimumLowerCase());
                welcome.add("minUpperCase", strength.getMinimumUpperCase());
                welcome.add("minDigits", strength.getMinimumDigits());
                welcome.add("minSpecial", strength.getMinimumSpecial());
                welcome.add("illegalNetworkUserState", illegalNetworkUserState);
            }
        }
        session.setState("server.tune sendWelcome");
        session.sendTuning("welcome", welcome);
        String foxVersion = session.getRemoteHello().getString("fox.version", null);
        if (foxVersion != null && new Version(foxVersion).compareTo(FoxSession.FOX_VERSION_1_0_2) >= 0) {
            session.setState("server.tune sendHello");
            session.sendHello(null, true);
        }
        session.setState("server.tune starting");
        try {
            AccessController.doPrivileged(() -> {
                try {
                    Subject subject = SessionManager.getAuthenticatedSubjectFromSession((String)session.getSuperId());
                    Subject.doAs(subject, () -> {
                        session.start();
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public void rejectAuthentication(FoxSession session, Throwable fatal, Throwable msg) throws Exception {
        FoxMessage rejected = this.generateRejectedMessage(fatal, msg, session.getSessionContext());
        session.setState("server.tune sendRejected");
        session.sendTuning("rejected", rejected);
        throw new FoxAuthenticationException("client login failed", session);
    }

    protected FoxMessage generateRejectedMessage(Throwable fatal, Throwable msg, Context cx) {
        FoxMessage rejected = new FoxMessage();
        if (fatal != null) {
            rejected.add("fatal", this.toFatalMessage(fatal, cx));
            if (fatal instanceof FoxAuthenticationException) {
                rejected.add("data", ((FoxAuthenticationException)fatal).data);
            }
        }
        if (msg != null) {
            rejected.add("msg", this.toFatalMessage(msg, cx));
            if (fatal instanceof FoxAuthenticationException) {
                rejected.add("data", ((FoxAuthenticationException)fatal).data);
            }
            if (msg instanceof AuthenticationException) {
                String d = msg.getMessage();
                FoxMessage dataMessage = new FoxMessage();
                dataMessage.add("authfail_reason", d);
                rejected.add("data", dataMessage);
            }
        }
        return rejected;
    }

    public String toFatalMessage(Throwable e, Context cx) {
        String msg;
        if (e instanceof Localizable) {
            return ((Localizable)e).toString(cx);
        }
        String s = e.getClass().getName();
        int dot = s.lastIndexOf(46);
        if (dot > 0) {
            s = s.substring(dot + 1);
        }
        if ((msg = e.getMessage()) != null && msg.length() > 0) {
            s = s + ": " + msg;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateSuccess(FoxSession session, BUser user) {
        Object object = session.getSessionStateLock();
        synchronized (object) {
            FoxMessage hello = session.getRemoteHello();
            String lang = hello.getString("lang", null);
            String vmUuid = hello.getString("vmUuid", null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("foxSessionId", BString.make((String)session.getId()));
            if (vmUuid != null) {
                map.put("foxRemoteVmUuid", BString.make((String)vmUuid));
            }
            map.put("skipEncodingSensitive", BBoolean.TRUE);
            session.setUser(user);
            session.setSessionContext((Context)new BasicContext((Context)new BasicContext(user, lang), BFacets.make(map)));
        }
    }

    private static void addExtraAttributes(BICredentials credentials, FoxMessage message, FoxSession session) throws FoxAuthenticationException {
        if (credentials instanceof BIExtraAttributesCredentials) {
            Map extraAttributes = ((BIExtraAttributesCredentials)credentials).getExtraAttributes();
            for (Map.Entry entry : extraAttributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Boolean) {
                    message.add(key, (Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    message.add(key, (Integer)value);
                    continue;
                }
                if (value instanceof Double) {
                    message.add(key, (Double)value);
                    continue;
                }
                if (value instanceof String) {
                    message.add(key, (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    message.add(key, (Long)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    message.add(key, (byte[])value);
                    continue;
                }
                throw new FoxAuthenticationException("Credentials supplied extra attribute of unsupported type: " + value.getClass(), session);
            }
        }
    }
}

