/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FrameQueue;
import java.io.IOException;

public class SessionSender
implements Runnable {
    private static FoxFrame keepAlive = new FoxFrame(107, -1, -1, "fox", "keepalive", new FoxMessage());
    private FoxSession session;
    private String name;
    private boolean isAlive;
    private Thread thread;
    private FrameQueue queue;
    private volatile boolean running = false;

    public SessionSender(FoxSession session) {
        this.name = "Fox:Sender:" + session.getId();
        this.session = session;
        this.queue = new FrameQueue();
        this.isAlive = true;
    }

    public void enqueue(FoxFrame frame) throws InterruptedException {
        this.queue.enqueue(frame);
    }

    public void start() {
        this.thread = this.session.conn.makeThread(Fox.threadGroup, this, this.name);
        this.thread.start();
    }

    public void kill() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.kill();
    }

    public void sendClose(LoginFailureCause cause) {
        if (cause == null) {
            return;
        }
        FoxRequest req = new FoxRequest("fox", "close");
        req.add("cause", cause.name());
        FoxFrame close = new FoxFrame(99, -1, -1, "fox", "close", req);
        try {
            if (this.session.isClosed()) {
                return;
            }
            this.session.writeFrame(close);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            while (this.isAlive && !this.session.isClosed()) {
                try {
                    FoxFrame frame = this.queue.dequeue(Fox.keepAliveInterval);
                    if (this.session.isClosed()) {
                        break;
                    }
                    if (frame == null) {
                        frame = keepAlive;
                    }
                    this.session.writeFrame(frame);
                }
                catch (InterruptedException frame) {
                }
                catch (IOException e) {
                    this.session.close(e);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            Object sessionStateLock;
            this.running = false;
            Object object = sessionStateLock = this.session.getSessionStateLock();
            synchronized (object) {
                sessionStateLock.notifyAll();
            }
        }
    }

    public String toString() {
        return this.name + " {" + this.queue + "}";
    }
}

