/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import java.io.InterruptedIOException;

public class SessionBedroom {
    private Bed[] bedTable = new Bed[4];

    synchronized Bed getBed(Thread thread) {
        int i;
        for (i = 0; i < this.bedTable.length && this.bedTable[i] != null; ++i) {
        }
        if (i == this.bedTable.length) {
            Bed[] temp = new Bed[this.bedTable.length * 2];
            System.arraycopy(this.bedTable, 0, temp, 0, this.bedTable.length);
            this.bedTable = temp;
        }
        Bed bed = new Bed();
        bed.replyNumber = i;
        bed.thread = thread;
        this.bedTable[i] = bed;
        return this.bedTable[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleep(Bed bed) throws InterruptedIOException {
        try {
            Bed bed2 = bed;
            synchronized (bed2) {
                long sleepTime = Fox.clock.ticks();
                while (!bed.haveReply && Fox.clock.ticks() - sleepTime < (long)Fox.requestTimeout) {
                    long waitTime = (long)Fox.requestTimeout - (Fox.clock.ticks() - sleepTime);
                    if (waitTime < 50L) {
                        waitTime = 50L;
                    }
                    bed.wait(waitTime);
                }
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            SessionBedroom sessionBedroom = this;
            synchronized (sessionBedroom) {
                bed.thread = null;
                this.bedTable[bed.replyNumber] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wake(FoxFrame reply) throws Exception {
        Bed bed = null;
        Object object = this;
        synchronized (object) {
            bed = this.bedTable[reply.replyNumber];
        }
        if (bed == null) {
            return;
        }
        object = bed;
        synchronized (object) {
            bed.haveReply = true;
            bed.reply = reply;
            bed.notify();
            return;
        }
    }

    synchronized void wakeAll() {
        for (int i = 0; i < this.bedTable.length; ++i) {
            Bed bed = this.bedTable[i];
            if (bed == null) continue;
            bed.thread.interrupt();
            bed.thread = null;
        }
    }

    public synchronized String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.bedTable.length; ++i) {
            Bed bed = this.bedTable[i];
            if (bed == null) continue;
            s.append(bed.replyNumber).append(": ").append(bed.thread).append('\n');
        }
        if (s.length() == 0) {
            return "empty";
        }
        s.setLength(s.length() - 1);
        return s.toString();
    }

    static class Bed {
        int replyNumber;
        FoxFrame reply;
        boolean haveReply = false;
        Thread thread;

        Bed() {
        }
    }
}

