/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxFloat;
import com.tridium.fox.message.FoxInteger;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTime;
import com.tridium.fox.message.MessageReader;
import com.tridium.fox.message.MessageWriter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FoxTuple {
    public String name;

    public abstract int getType();

    public final void write(MessageWriter out) throws IOException {
        out.writeName(this.name).write(61).write(this.getType()).write(58);
        this.writeValue(out);
    }

    protected abstract void writeValue(MessageWriter var1) throws IOException;

    public static FoxTuple read(MessageReader in) throws IOException {
        String name = in.readName();
        in.consume(61);
        int type = in.read();
        FoxTuple tuple = null;
        switch (type) {
            case 98: {
                tuple = new FoxBlob();
                break;
            }
            case 102: {
                tuple = new FoxFloat();
                break;
            }
            case 105: {
                tuple = new FoxInteger();
                break;
            }
            case 109: {
                tuple = new FoxMessage();
                break;
            }
            case 111: {
                tuple = new FoxObject();
                break;
            }
            case 115: {
                tuple = new FoxString();
                break;
            }
            case 116: {
                tuple = new FoxTime();
                break;
            }
            case 122: {
                tuple = new FoxBoolean();
            }
        }
        in.consume(58);
        tuple.name = name.intern();
        tuple.readValue(in);
        in.consume(10);
        return tuple;
    }

    protected void readValue(MessageReader in) throws IOException {
        throw in.error("not implemented");
    }

    public void dump(OutputStream out) {
        try {
            MessageWriter msgOut = new MessageWriter(out, true);
            this.write(msgOut);
            msgOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public void dump() {
        this.dump(System.out);
    }
}

