/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.dashboard;

import com.tridium.fox.sys.BFoxService;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"fox:FoxService"})})
public class BFoxServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BFoxServiceSecurityDashboardProviderAgent.class);
    private static final String[] TRACE_PROPERTIES = new String[]{"traceMulticast", "traceReadFrame", "traceSessionStates", "traceWriteFrame"};
    private BFoxService foxService;
    private SecurityDashboardItemBuilder builder;
    private boolean legacyEnabledByDefault;
    private static final int VERSION = 2;
    private static final double CERT_EXPIRY_WARNING_MILLIS = BRelTime.makeDays((int)90).getMillis();
    private static final int LEGACY_DEFAULT = 0;
    private static final int LEGACY_NO = 1;
    private static final int LEGACY_YES = 2;
    private static final String CERT_EXPIRED_SUMMARY = "securityDashboard.foxCertificateExpired.summary";
    private static final String CERT_EXPIRED_DESCRIPTION = "securityDashboard.foxCertificateExpired.description";
    private static final String CERT_MISSING_SUMMARY = "securityDashboard.foxCertificateNotAvailable.summary";
    private static final String CERT_MISSING_DESCRIPTION = "securityDashboard.foxCertificateNotAvailable.description";
    private static final String CERT_NEAR_EXPIRY_SUMMARY = "securityDashboard.foxCertificateNearExpiry.summary";
    private static final String CERT_NEAR_EXPIRY_DESCRIPTION = "securityDashboard.foxCertificateNearExpiry.description";
    private static final String CERT_NOT_SELF_SIGNED_SUMMARY = "securityDashboard.foxCertificateNotSelfSigned.summary";
    private static final String CERT_NOT_SELF_SIGNED_DESCRIPTION = "securityDashboard.foxCertificateNotSelfSigned.description";
    private static final String CERT_NOT_YET_VALID_SUMMARY = "securityDashboard.foxCertificateNotYetValidException.summary";
    private static final String CERT_NOT_YET_VALID_DESCRIPTION = "securityDashboard.foxCertificateNotYetValidException.description";
    private static final String CERT_SELF_SIGNED_SUMMARY = "securityDashboard.foxCertificateSelfSigned.summary";
    private static final String CERT_SELF_SIGNED_DESCRIPTION = "securityDashboard.foxCertificateSelfSigned.description";
    private static final String CERT_IN_VALIDITY_PERIOD_SUMMARY = "securityDashboard.foxCertificateValid.summary";
    private static final String CERT_IN_VALIDITY_PERIOD_DESCRIPTION = "securityDashboard.foxCertificateValid.description";
    private static final String CIPHER_SUITE_SUMMARY = "securityDashboard.cipherSuiteGroup.summary";
    private static final String CIPHER_SUITE_DESCRIPTION = "securityDashboard.cipherSuiteGroup.description";
    private static final String FORWARDING_SUMMARY = "securityDashboard.foxForwarding.summary";
    private static final String FORWARDING_DESCRIPTION = "securityDashboard.foxForwarding.description";
    private static final String LEGACY_CLIENTS_DEFAULT_YES_SUMMARY = "securityDashboard.legacyClients.defaultYes.summary";
    private static final String LEGACY_CLIENTS_DEFAULT_NO_SUMMARY = "securityDashboard.legacyClients.defaultNo.summary";
    private static final String LEGACY_CLIENTS_DISABLED_SUMMARY = "securityDashboard.legacyClients.disabled.summary";
    private static final String LEGACY_CLIENTS_ENABLED_SUMMARY = "securityDashboard.legacyClients.enabled.summary";
    private static final String LEGACY_CLIENTS_DESCRIPTION = "securityDashboard.legacyClients.description";
    private static final String NON_TLS_SUMMARY = "securityDashboard.foxNonTlsProtocol.summary";
    private static final String NON_TLS_DESCRIPTION = "securityDashboard.foxNonTlsProtocol.description";
    private static final String SECTION_HEADER = "securityDashboard.sectionHeader";
    private static final String TLS_OFF_SUMMARY = "securityDashboard.foxTlsProtocolOff.summary";
    private static final String TLS_OFF_DESCRIPTION = "securityDashboard.foxTlsProtocolOff.description";
    private static final String TLS_ON_SUMMARY = "securityDashboard.foxTlsProtocolOn.summary";
    private static final String TLS_ON_DESCRIPTION = "securityDashboard.foxTlsProtocolOn.description";
    private static final String TLS_VERSION_SUMMARY = "securityDashboard.foxTlsProtocol.summary";
    private static final String TLS_VERSION_DESCRIPTION = "securityDashboard.foxTlsProtocol.description";
    private static final String TRACE_ENABLED_SUMMARY = "securityDashboard.foxTracePropertiesEnabled.summary";
    private static final String TRACE_ENABLED_DESCRIPTION = "securityDashboard.foxTracePropertiesEnabled.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.foxService = (BFoxService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
        this.legacyEnabledByDefault = true;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.foxService.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 2;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>(this.getTlsItems());
        items.addAll(this.getCipherSuiteItems());
        items.addAll(this.getCertificateItems());
        items.addAll(this.getTraceItems());
        items.addAll(this.getLegacyConnectionItems());
        return items;
    }

    private List<SecurityDashboardItem> getTlsItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        boolean foxEnabled = this.foxService.getFoxEnabled();
        boolean foxsEnabled = this.foxService.getFoxsEnabled();
        boolean foxsOnly = this.foxService.getFoxsOnly();
        BSslTlsEnum minProtocol = this.foxService.getFoxsMinProtocol();
        if (foxEnabled && !foxsEnabled) {
            items.add(this.builder.makeAlert(TLS_OFF_SUMMARY, TLS_OFF_DESCRIPTION));
        }
        if (!foxEnabled && foxsEnabled) {
            items.add(this.builder.makeOk(TLS_ON_SUMMARY, TLS_ON_DESCRIPTION));
        }
        if (foxEnabled && foxsEnabled) {
            if (foxsOnly) {
                items.add(this.builder.makeWarning(FORWARDING_SUMMARY, FORWARDING_DESCRIPTION));
            } else {
                items.add(this.builder.makeAlert(NON_TLS_SUMMARY, NON_TLS_DESCRIPTION));
            }
        }
        if (foxsEnabled) {
            BSecurityItemStatus status = minProtocol.equals((Object)BSslTlsEnum.tlsv1_2) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(this.builder.make(status).withSummary(TLS_VERSION_SUMMARY, new Object[]{minProtocol}).withDescription(TLS_VERSION_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
        }
        return items;
    }

    private List<SecurityDashboardItem> getCipherSuiteItems() {
        if (!this.foxService.getFoxsEnabled()) {
            return Collections.emptyList();
        }
        BTlsCipherSuiteGroup cipherSuite = this.foxService.getCipherSuiteGroup();
        BSecurityItemStatus status = cipherSuite.equals((Object)BTlsCipherSuiteGroup.recommended) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
        return Collections.singletonList(this.builder.make(status).withSummary(CIPHER_SUITE_SUMMARY, new Object[]{cipherSuite}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
    }

    private List<SecurityDashboardItem> getCertificateItems() {
        if (!this.foxService.getFoxsEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        String foxsCert = this.foxService.getFoxsCert();
        try {
            X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(foxsCert);
            try {
                certificate.checkValidity();
                if (BFoxServiceSecurityDashboardProviderAgent.isNearExpiration(certificate)) {
                    items.add(this.builder.makeWarning().withSummary(CERT_NEAR_EXPIRY_SUMMARY, new Object[]{foxsCert, certificate.getNotAfter()}).withDescription(CERT_NEAR_EXPIRY_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeOk().withSummary(CERT_IN_VALIDITY_PERIOD_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_IN_VALIDITY_PERIOD_DESCRIPTION, new Object[0]));
                }
            }
            catch (CertificateExpiredException e) {
                items.add(this.builder.makeAlert().withSummary(CERT_EXPIRED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_EXPIRED_DESCRIPTION, new Object[0]));
            }
            catch (CertificateNotYetValidException e) {
                items.add(this.builder.makeAlert().withSummary(CERT_NOT_YET_VALID_SUMMARY, new Object[]{foxsCert, certificate.getNotBefore()}).withDescription(CERT_NOT_YET_VALID_DESCRIPTION, new Object[0]));
            }
            if (BFoxServiceSecurityDashboardProviderAgent.isSelfSigned(certificate)) {
                items.add(this.builder.makeWarning().withSummary(CERT_SELF_SIGNED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_SELF_SIGNED_DESCRIPTION, new Object[0]));
            } else {
                items.add(this.builder.makeOk().withSummary(CERT_NOT_SELF_SIGNED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_NOT_SELF_SIGNED_DESCRIPTION, new Object[0]));
            }
        }
        catch (Exception e) {
            items.add(this.builder.makeWarning().withSummary(CERT_MISSING_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_MISSING_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getTraceItems() {
        ArrayList<String> tracePropertiesList = new ArrayList<String>();
        for (String prop : TRACE_PROPERTIES) {
            if (!BBoolean.TRUE.equals((Object)this.foxService.get(prop))) continue;
            tracePropertiesList.add(prop);
        }
        if (tracePropertiesList.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.builder.makeWarning().withSummary(TRACE_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", tracePropertiesList)}).withDescription(TRACE_ENABLED_DESCRIPTION, new Object[0]));
    }

    private List<SecurityDashboardItem> getLegacyConnectionItems() {
        String summary = null;
        BSecurityItemStatus status = null;
        switch (this.foxService.getSupportLegacyClients().getOrdinal()) {
            case 0: {
                if (this.legacyEnabledByDefault) {
                    summary = LEGACY_CLIENTS_DEFAULT_YES_SUMMARY;
                    status = BSecurityItemStatus.securityStatusWarning;
                    break;
                }
                summary = LEGACY_CLIENTS_DEFAULT_NO_SUMMARY;
                status = BSecurityItemStatus.securityStatusOK;
                break;
            }
            case 1: {
                summary = LEGACY_CLIENTS_DISABLED_SUMMARY;
                status = BSecurityItemStatus.securityStatusOK;
                break;
            }
            case 2: {
                summary = LEGACY_CLIENTS_ENABLED_SUMMARY;
                status = BSecurityItemStatus.securityStatusAlert;
            }
        }
        return Collections.singletonList(this.builder.make(status, summary, LEGACY_CLIENTS_DESCRIPTION));
    }

    private static boolean isNearExpiration(X509Certificate certificate) {
        return (double)(certificate.getNotAfter().getTime() - new Date().getTime()) < CERT_EXPIRY_WARNING_MILLIS;
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getIssuerDN().equals(certificate.getSubjectDN());
    }
}

