/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore;

import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOpcHttpsSecurityPolicies
extends BBitString {
    public static final int TLS1_0 = 1;
    public static final int TLS1_1 = 2;
    public static final int TLS1_2 = 4;
    public static final BOpcHttpsSecurityPolicies tls1_0 = (BOpcHttpsSecurityPolicies)new BOpcHttpsSecurityPolicies(1).intern();
    public static final BOpcHttpsSecurityPolicies tls1_1 = (BOpcHttpsSecurityPolicies)new BOpcHttpsSecurityPolicies(2).intern();
    public static final BOpcHttpsSecurityPolicies tls1_2 = (BOpcHttpsSecurityPolicies)new BOpcHttpsSecurityPolicies(4).intern();
    public static final BOpcHttpsSecurityPolicies DEFAULT = new BOpcHttpsSecurityPolicies(7);
    public static final BOpcHttpsSecurityPolicies EMPTY = new BOpcHttpsSecurityPolicies(0);
    public static final BOpcHttpsSecurityPolicies ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private int bits;

    public static BOpcHttpsSecurityPolicies make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BOpcHttpsSecurityPolicies make(int bits) {
        if (bits == BOpcHttpsSecurityPolicies.ALL.bits) {
            return ALL;
        }
        if (bits == BOpcHttpsSecurityPolicies.EMPTY.bits) {
            return EMPTY;
        }
        return (BOpcHttpsSecurityPolicies)new BOpcHttpsSecurityPolicies(bits).intern();
    }

    private BOpcHttpsSecurityPolicies(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean includes(int mode) {
        return (this.bits & mode) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i2 = 0; i2 < ordinals.length; ++i2) {
            mask |= ordinals[i2];
        }
        return BOpcHttpsSecurityPolicies.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean isAllPolicies() {
        return this.bits == BOpcHttpsSecurityPolicies.ALL.bits;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BOpcHttpsSecurityPolicies) {
            return ((BOpcHttpsSecurityPolicies)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BOpcHttpsSecurityPolicies.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s2) throws IOException {
        try {
            return BOpcHttpsSecurityPolicies.make(Integer.parseInt(s2, 16));
        }
        catch (Exception e2) {
            throw new IOException("Invalid bits: " + s2);
        }
    }

    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{}";
        }
        StringBuffer s2 = new StringBuffer();
        s2.append('{');
        if (this.includes(1)) {
            s2.append(support.getDisplayTag(1, cx));
            s2.append(" ");
        }
        if (this.includes(2)) {
            s2.append(support.getDisplayTag(2, cx));
            s2.append(" ");
        }
        if (this.includes(4)) {
            s2.append(support.getDisplayTag(4, cx));
            s2.append(" ");
        }
        s2.append('}');
        return s2.toString();
    }

    public HttpsSecurityPolicy[] getSupportedPolicies() {
        if (this.bits == 7) {
            return new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_0, HttpsSecurityPolicy.TLS_1_1, HttpsSecurityPolicy.TLS_1_2};
        }
        if ((this.bits & 1) != 0) {
            return new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_0};
        }
        if ((this.bits & 2) != 0) {
            return new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_1};
        }
        if ((this.bits & 4) != 0) {
            return new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_2};
        }
        return new HttpsSecurityPolicy[0];
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "TLS 1.0");
        support.add(2, "TLS 1.1");
        support.add(4, "TLS 1.2");
        TYPE = Sys.loadType(BOpcHttpsSecurityPolicies.class);
    }
}

