/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore;

import javax.baja.alarm.BSourceState;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="toOffnormal", type="int", defaultValue="700", facets={@Facet(name="BFacets.MAX", value="1000"), @Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="toFault", type="int", defaultValue="900", facets={@Facet(name="BFacets.MAX", value="1000"), @Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="toNormal", type="int", defaultValue="500", facets={@Facet(name="BFacets.MAX", value="1000"), @Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="toAlert", type="int", defaultValue="600", facets={@Facet(name="BFacets.MAX", value="1000"), @Facet(name="BFacets.MIN", value="1")})})
public final class BAlarmSeverities
extends BStruct {
    public static final Property toOffnormal = BAlarmSeverities.newProperty((int)0, (int)700, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)1000), (BFacets)BFacets.make((String)"min", (int)1)));
    public static final Property toFault = BAlarmSeverities.newProperty((int)0, (int)900, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)1000), (BFacets)BFacets.make((String)"min", (int)1)));
    public static final Property toNormal = BAlarmSeverities.newProperty((int)0, (int)500, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)1000), (BFacets)BFacets.make((String)"min", (int)1)));
    public static final Property toAlert = BAlarmSeverities.newProperty((int)0, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)1000), (BFacets)BFacets.make((String)"min", (int)1)));
    public static final Type TYPE = Sys.loadType(BAlarmSeverities.class);
    public static final BAlarmSeverities DEFAULT = new BAlarmSeverities();
    public static final int SEVERITY_NORMAL_DEFAULT = 500;
    public static final int SEVERITY_OFFNORMAL_DEFAULT = 700;
    public static final int SEVERITY_FAULT_DEFAULT = 900;
    public static final int SEVERITY_ALERT_DEFAULT = 600;
    public static final int MAX_PRIORITY = 1000;
    public static final int MIN_PRIORITY = 1;

    public int getToOffnormal() {
        return this.getInt(toOffnormal);
    }

    public void setToOffnormal(int v) {
        this.setInt(toOffnormal, v, null);
    }

    public int getToFault() {
        return this.getInt(toFault);
    }

    public void setToFault(int v) {
        this.setInt(toFault, v, null);
    }

    public int getToNormal() {
        return this.getInt(toNormal);
    }

    public void setToNormal(int v) {
        this.setInt(toNormal, v, null);
    }

    public int getToAlert() {
        return this.getInt(toAlert);
    }

    public void setToAlert(int v) {
        this.setInt(toAlert, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmSeverities(int toOffnormal, int toFault, int toNormal, int toAlert) {
        this.setToOffnormal(this.checkPriority(toOffnormal));
        this.setToFault(this.checkPriority(toFault));
        this.setToNormal(this.checkPriority(toNormal));
        this.setToAlert(this.checkPriority(toAlert));
    }

    public BAlarmSeverities() {
        this(700, 900, 500, 600);
    }

    public int alarmStateToSeverity(BSourceState state) {
        switch (state.getOrdinal()) {
            case 2: {
                return this.getToFault();
            }
            case 0: {
                return this.getToNormal();
            }
            case 1: {
                return this.getToOffnormal();
            }
            case 3: {
                return this.getToAlert();
            }
        }
        return this.getToNormal();
    }

    private int checkPriority(int priority) {
        if (priority < 1 || priority > 1000) {
            throw new IllegalStateException(priority + ": not in range 0-1000");
        }
        return priority;
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getToOffnormal()).append(", ").append(this.getToFault()).append(", ").append(this.getToNormal()).append(", ").append(this.getToAlert());
        return sb.toString();
    }
}

