/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.SamplingIntervalDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SamplingIntervalDiagnosticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2165")
public abstract class SamplingIntervalDiagnosticsTypeNodeBase
extends BaseDataVariableTypeNode
implements SamplingIntervalDiagnosticsType {
    private static GeneratedNodeInitializer<SamplingIntervalDiagnosticsTypeNode> MM;

    protected SamplingIntervalDiagnosticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSampledMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getMaxSampledMonitoredItemsCountNode());
        this.callAfterCreateIfExists(this.getSamplingIntervalNode());
        this.callAfterCreateIfExists(this.getDisabledMonitoredItemsSamplingCountNode());
        GeneratedNodeInitializer<SamplingIntervalDiagnosticsTypeNode> generatedNodeInitializer = SamplingIntervalDiagnosticsTypeNodeBase.getSamplingIntervalDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SamplingIntervalDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SamplingIntervalDiagnosticsTypeNode> getSamplingIntervalDiagnosticsTypeNodeInitializer() {
        return MM;
    }

    public static void setSamplingIntervalDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<SamplingIntervalDiagnosticsTypeNode> generatedNodeInitializer) {
        MM = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSampledMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SampledMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSampledMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SampledMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSampledMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SampledMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SampledMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    public void setSampledMonitoredItemsCount(long l2) {
        this.setSampledMonitoredItemsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxSampledMonitoredItemsCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSampledMonitoredItemsCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxSampledMonitoredItemsCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxSampledMonitoredItemsCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxSampledMonitoredItemsCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxSampledMonitoredItemsCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxSampledMonitoredItemsCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSampledMonitoredItemsCount failed unexpectedly", statusException);
        }
    }

    public void setMaxSampledMonitoredItemsCount(long l2) {
        this.setMaxSampledMonitoredItemsCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSamplingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingInterval");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getSamplingInterval() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSamplingIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SamplingInterval does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setSamplingInterval(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSamplingIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SamplingInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SamplingInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDisabledMonitoredItemsSamplingCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DisabledMonitoredItemsSamplingCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDisabledMonitoredItemsSamplingCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisabledMonitoredItemsSamplingCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DisabledMonitoredItemsSamplingCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDisabledMonitoredItemsSamplingCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDisabledMonitoredItemsSamplingCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DisabledMonitoredItemsSamplingCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DisabledMonitoredItemsSamplingCount failed unexpectedly", statusException);
        }
    }

    public void setDisabledMonitoredItemsSamplingCount(long l2) {
        this.setDisabledMonitoredItemsSamplingCount(UnsignedInteger.valueOf(l2));
    }
}

