/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.RoleSetType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.RoleSetTypeAddRoleMethod;
import com.prosysopc.ua.types.opcua.server.RoleSetTypeNode;
import com.prosysopc.ua.types.opcua.server.RoleSetTypeRemoveRoleMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15607")
public abstract class RoleSetTypeNodeBase
extends BaseObjectTypeNode
implements RoleSetType {
    private static GeneratedNodeInitializer<RoleSetTypeNode> My;
    private static RoleSetTypeAddRoleMethod Mz;
    private static RoleSetTypeRemoveRoleMethod MA;

    protected RoleSetTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<RoleSetTypeNode> generatedNodeInitializer = RoleSetTypeNodeBase.getRoleSetTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((RoleSetTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<RoleSetTypeNode> getRoleSetTypeNodeInitializer() {
        return My;
    }

    public static void setRoleSetTypeNodeInitializer(GeneratedNodeInitializer<RoleSetTypeNode> generatedNodeInitializer) {
        My = generatedNodeInitializer;
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddRole"), nodeId)) {
            return new Variant[]{new Variant(this.c(serviceContext, (String)variantArray[0].getValue(), (String)variantArray[1].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveRole"), nodeId)) {
            this.m(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getAddRoleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddRole");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddRole(ServiceContext var1, String var2, String var3) throws StatusException;

    @Override
    public NodeId addRole(String string, String string2) throws StatusException {
        return this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, string2);
    }

    private NodeId c(ServiceContext serviceContext, String string, String string2) throws StatusException {
        RoleSetTypeAddRoleMethod roleSetTypeAddRoleMethod = RoleSetTypeNodeBase.getAddRoleMethodImplementation();
        if (roleSetTypeAddRoleMethod != null) {
            return roleSetTypeAddRoleMethod.addRole(serviceContext, (RoleSetTypeNode)this, string, string2);
        }
        return this.onAddRole(serviceContext, string, string2);
    }

    public static RoleSetTypeAddRoleMethod getAddRoleMethodImplementation() {
        return Mz;
    }

    public static void setAddRoleMethodImplementation(RoleSetTypeAddRoleMethod roleSetTypeAddRoleMethod) {
        Mz = roleSetTypeAddRoleMethod;
    }

    @Override
    @Mandatory
    public UaMethod getRemoveRoleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveRole");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveRole(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeRole(NodeId nodeId) throws StatusException {
        this.m(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void m(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        RoleSetTypeRemoveRoleMethod roleSetTypeRemoveRoleMethod = RoleSetTypeNodeBase.getRemoveRoleMethodImplementation();
        if (roleSetTypeRemoveRoleMethod != null) {
            roleSetTypeRemoveRoleMethod.removeRole(serviceContext, (RoleSetTypeNode)this, nodeId);
        } else {
            this.onRemoveRole(serviceContext, nodeId);
        }
    }

    public static RoleSetTypeRemoveRoleMethod getRemoveRoleMethodImplementation() {
        return MA;
    }

    public static void setRemoveRoleMethodImplementation(RoleSetTypeRemoveRoleMethod roleSetTypeRemoveRoleMethod) {
        MA = roleSetTypeRemoveRoleMethod;
    }
}

