/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.PubSubConnectionDataType;
import com.prosysopc.ua.types.opcua.PublishSubscribeType;
import com.prosysopc.ua.types.opcua.server.DataSetFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubCapabilitiesTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsRootTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubKeyServiceTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;
import com.prosysopc.ua.types.opcua.server.PublishSubscribeTypeAddConnectionMethod;
import com.prosysopc.ua.types.opcua.server.PublishSubscribeTypeNode;
import com.prosysopc.ua.types.opcua.server.PublishSubscribeTypeRemoveConnectionMethod;
import com.prosysopc.ua.types.opcua.server.PublishSubscribeTypeSetSecurityKeysMethod;
import com.prosysopc.ua.types.opcua.server.SubscribedDataSetFolderTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14416")
public abstract class PublishSubscribeTypeNodeBase
extends PubSubKeyServiceTypeNode
implements PublishSubscribeType {
    private static GeneratedNodeInitializer<PublishSubscribeTypeNode> Mb;
    private static PublishSubscribeTypeSetSecurityKeysMethod Mc;
    private static PublishSubscribeTypeRemoveConnectionMethod Md;
    private static PublishSubscribeTypeAddConnectionMethod Me;

    protected PublishSubscribeTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStatusNode());
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        this.callAfterCreateIfExists(this.getDataSetClassesNode());
        this.callAfterCreateIfExists(this.getPubSubConfigurationNode());
        this.callAfterCreateIfExists(this.getSubscribedDataSetsNode());
        this.callAfterCreateIfExists(this.getPubSubCapablitiesNode());
        this.callAfterCreateIfExists(this.getPublishedDataSetsNode());
        GeneratedNodeInitializer<PublishSubscribeTypeNode> generatedNodeInitializer = PublishSubscribeTypeNodeBase.getPublishSubscribeTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PublishSubscribeTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PublishSubscribeTypeNode> getPublishSubscribeTypeNodeInitializer() {
        return Mb;
    }

    public static void setPublishSubscribeTypeNodeInitializer(GeneratedNodeInitializer<PublishSubscribeTypeNode> generatedNodeInitializer) {
        Mb = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSupportedTransportProfilesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedTransportProfiles");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getSupportedTransportProfiles() {
        UaProperty uaProperty = this.getSupportedTransportProfilesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SupportedTransportProfiles does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setSupportedTransportProfiles(String[] stringArray) {
        UaProperty uaProperty = this.getSupportedTransportProfilesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedTransportProfiles failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedTransportProfiles failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConfigurationPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfigurationProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public KeyValuePair[] getConfigurationProperties() {
        UaProperty uaProperty = this.getConfigurationPropertiesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Optional
    public void setConfigurationProperties(KeyValuePair[] keyValuePairArray) {
        UaProperty uaProperty = this.getConfigurationPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConfigurationProperties failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(keyValuePairArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfigurationProperties failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConfigurationVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfigurationVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getConfigurationVersion() {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setConfigurationVersion(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConfigurationVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfigurationVersion failed unexpectedly", statusException);
        }
    }

    public void setConfigurationVersion(long l2) {
        this.setConfigurationVersion(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getDefaultSecurityKeyServicesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultSecurityKeyServices");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointDescription[] getDefaultSecurityKeyServices() {
        UaProperty uaProperty = this.getDefaultSecurityKeyServicesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointDescription[])object;
    }

    @Override
    @Optional
    public void setDefaultSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) {
        UaProperty uaProperty = this.getDefaultSecurityKeyServicesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultSecurityKeyServices failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(endpointDescriptionArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DefaultSecurityKeyServices failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDefaultDatagramPublisherIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultDatagramPublisherId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedLong getDefaultDatagramPublisherId() {
        UaProperty uaProperty = this.getDefaultDatagramPublisherIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Optional
    public void setDefaultDatagramPublisherId(UnsignedLong unsignedLong) {
        UaProperty uaProperty = this.getDefaultDatagramPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultDatagramPublisherId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedLong);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DefaultDatagramPublisherId failed unexpectedly", statusException);
        }
    }

    public void setDefaultDatagramPublisherId(long l2) {
        this.setDefaultDatagramPublisherId(UnsignedLong.valueOf(l2));
    }

    @Override
    @Mandatory
    public PubSubStatusTypeNode getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsRootTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsRootTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getDataSetClassesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetClasses");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubConfigurationTypeNode getPubSubConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PubSubConfiguration");
        return (PubSubConfigurationTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public SubscribedDataSetFolderTypeNode getSubscribedDataSetsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscribedDataSets");
        return (SubscribedDataSetFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubCapabilitiesTypeNode getPubSubCapablitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PubSubCapablities");
        return (PubSubCapabilitiesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetFolderTypeNode getPublishedDataSetsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishedDataSets");
        return (DataSetFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "SetSecurityKeys"), nodeId)) {
            this.a(serviceContext, (String)variantArray[0].getValue(), (String)variantArray[1].getValue(), (UnsignedInteger)variantArray[2].getValue(), (ByteString)variantArray[3].getValue(), (ByteString[])variantArray[4].getValue(), (Double)variantArray[5].getValue(), (Double)variantArray[6].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveConnection"), nodeId)) {
            this.k(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddConnection"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (PubSubConnectionDataType)variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getSetSecurityKeysNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetSecurityKeys");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSetSecurityKeys(ServiceContext var1, String var2, String var3, UnsignedInteger var4, ByteString var5, ByteString[] var6, Double var7, Double var8) throws StatusException;

    @Override
    public void setSecurityKeys(String string, String string2, UnsignedInteger unsignedInteger, ByteString byteString, ByteString[] byteStringArray, Double d2, Double d3) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, string2, unsignedInteger, byteString, byteStringArray, d2, d3);
    }

    private void a(ServiceContext serviceContext, String string, String string2, UnsignedInteger unsignedInteger, ByteString byteString, ByteString[] byteStringArray, Double d2, Double d3) throws StatusException {
        PublishSubscribeTypeSetSecurityKeysMethod publishSubscribeTypeSetSecurityKeysMethod = PublishSubscribeTypeNodeBase.getSetSecurityKeysMethodImplementation();
        if (publishSubscribeTypeSetSecurityKeysMethod != null) {
            publishSubscribeTypeSetSecurityKeysMethod.setSecurityKeys(serviceContext, (PublishSubscribeTypeNode)this, string, string2, unsignedInteger, byteString, byteStringArray, d2, d3);
        } else {
            this.onSetSecurityKeys(serviceContext, string, string2, unsignedInteger, byteString, byteStringArray, d2, d3);
        }
    }

    public static PublishSubscribeTypeSetSecurityKeysMethod getSetSecurityKeysMethodImplementation() {
        return Mc;
    }

    public static void setSetSecurityKeysMethodImplementation(PublishSubscribeTypeSetSecurityKeysMethod publishSubscribeTypeSetSecurityKeysMethod) {
        Mc = publishSubscribeTypeSetSecurityKeysMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveConnectionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveConnection");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveConnection(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeConnection(NodeId nodeId) throws StatusException {
        this.k(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void k(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        PublishSubscribeTypeRemoveConnectionMethod publishSubscribeTypeRemoveConnectionMethod = PublishSubscribeTypeNodeBase.getRemoveConnectionMethodImplementation();
        if (publishSubscribeTypeRemoveConnectionMethod != null) {
            publishSubscribeTypeRemoveConnectionMethod.removeConnection(serviceContext, (PublishSubscribeTypeNode)this, nodeId);
        } else {
            this.onRemoveConnection(serviceContext, nodeId);
        }
    }

    public static PublishSubscribeTypeRemoveConnectionMethod getRemoveConnectionMethodImplementation() {
        return Md;
    }

    public static void setRemoveConnectionMethodImplementation(PublishSubscribeTypeRemoveConnectionMethod publishSubscribeTypeRemoveConnectionMethod) {
        Md = publishSubscribeTypeRemoveConnectionMethod;
    }

    @Override
    @Optional
    public UaMethod getAddConnectionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddConnection");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddConnection(ServiceContext var1, PubSubConnectionDataType var2) throws StatusException;

    @Override
    public NodeId addConnection(PubSubConnectionDataType pubSubConnectionDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, pubSubConnectionDataType);
    }

    private NodeId a(ServiceContext serviceContext, PubSubConnectionDataType pubSubConnectionDataType) throws StatusException {
        PublishSubscribeTypeAddConnectionMethod publishSubscribeTypeAddConnectionMethod = PublishSubscribeTypeNodeBase.getAddConnectionMethodImplementation();
        if (publishSubscribeTypeAddConnectionMethod != null) {
            return publishSubscribeTypeAddConnectionMethod.addConnection(serviceContext, (PublishSubscribeTypeNode)this, pubSubConnectionDataType);
        }
        return this.onAddConnection(serviceContext, pubSubConnectionDataType);
    }

    public static PublishSubscribeTypeAddConnectionMethod getAddConnectionMethodImplementation() {
        return Me;
    }

    public static void setAddConnectionMethodImplementation(PublishSubscribeTypeAddConnectionMethod publishSubscribeTypeAddConnectionMethod) {
        Me = publishSubscribeTypeAddConnectionMethod;
    }
}

