/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.LldpManagementAddressTxPortType;
import com.prosysopc.ua.stack.core.PortIdSubtype;
import com.prosysopc.ua.types.opcua.LldpPortInformationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpPortInformationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19009")
public abstract class LldpPortInformationTypeNodeBase
extends BaseObjectTypeNode
implements LldpPortInformationType {
    private static GeneratedNodeInitializer<LldpPortInformationTypeNode> Kx;

    protected LldpPortInformationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getRemoteSystemsDataNode());
        GeneratedNodeInitializer<LldpPortInformationTypeNode> generatedNodeInitializer = LldpPortInformationTypeNodeBase.getLldpPortInformationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LldpPortInformationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LldpPortInformationTypeNode> getLldpPortInformationTypeNodeInitializer() {
        return Kx;
    }

    public static void setLldpPortInformationTypeNodeInitializer(GeneratedNodeInitializer<LldpPortInformationTypeNode> generatedNodeInitializer) {
        Kx = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getIetfBaseNetworkInterfaceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IetfBaseNetworkInterfaceName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getIetfBaseNetworkInterfaceName() {
        UaProperty uaProperty = this.getIetfBaseNetworkInterfaceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node IetfBaseNetworkInterfaceName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setIetfBaseNetworkInterfaceName(String string) {
        UaProperty uaProperty = this.getIetfBaseNetworkInterfaceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IetfBaseNetworkInterfaceName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IetfBaseNetworkInterfaceName failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getManagementAddressTxPortNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManagementAddressTxPort");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpManagementAddressTxPortType[] getManagementAddressTxPort() {
        UaProperty uaProperty = this.getManagementAddressTxPortNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpManagementAddressTxPortType[])object;
    }

    @Override
    @Optional
    public void setManagementAddressTxPort(LldpManagementAddressTxPortType[] lldpManagementAddressTxPortTypeArray) {
        UaProperty uaProperty = this.getManagementAddressTxPortNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ManagementAddressTxPort failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(lldpManagementAddressTxPortTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ManagementAddressTxPort failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPortIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getPortId() {
        UaProperty uaProperty = this.getPortIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PortId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setPortId(String string) {
        UaProperty uaProperty = this.getPortIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getPortDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getPortDescription() {
        UaProperty uaProperty = this.getPortDescriptionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPortDescription(String string) {
        UaProperty uaProperty = this.getPortDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDestMacAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DestMacAddress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[] getDestMacAddress() {
        UaProperty uaProperty = this.getDestMacAddressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DestMacAddress does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Mandatory
    public void setDestMacAddress(UnsignedByte[] unsignedByteArray) {
        UaProperty uaProperty = this.getDestMacAddressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DestMacAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByteArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DestMacAddress failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPortIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortIdSubtype");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PortIdSubtype getPortIdSubtype() {
        UaProperty uaProperty = this.getPortIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PortIdSubtype does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PortIdSubtype)variant.asEnum(PortIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setPortIdSubtype(PortIdSubtype portIdSubtype) {
        UaProperty uaProperty = this.getPortIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortIdSubtype failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(portIdSubtype);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortIdSubtype failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public FolderTypeNode getRemoteSystemsDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteSystemsData");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

