/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.LldpInformationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpInformationTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpLocalSystemTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpRemoteStatisticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18973")
public abstract class LldpInformationTypeNodeBase
extends BaseObjectTypeNode
implements LldpInformationType {
    private static GeneratedNodeInitializer<LldpInformationTypeNode> Kv;

    protected LldpInformationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getPortsNode());
        this.callAfterCreateIfExists(this.getRemoteStatisticsNode());
        this.callAfterCreateIfExists(this.getLocalSystemDataNode());
        GeneratedNodeInitializer<LldpInformationTypeNode> generatedNodeInitializer = LldpInformationTypeNodeBase.getLldpInformationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LldpInformationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LldpInformationTypeNode> getLldpInformationTypeNodeInitializer() {
        return Kv;
    }

    public static void setLldpInformationTypeNodeInitializer(GeneratedNodeInitializer<LldpInformationTypeNode> generatedNodeInitializer) {
        Kv = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public FolderTypeNode getPortsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Ports");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpRemoteStatisticsTypeNode getRemoteStatisticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteStatistics");
        return (LldpRemoteStatisticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LldpLocalSystemTypeNode getLocalSystemDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocalSystemData");
        return (LldpLocalSystemTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

